/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.util.CaseInsensitive;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;
import org.slf4j.Logger;

public class EnumUtil {
    public static <E extends Enum<E>> E fromEnum(Class<E> cls, Enum<?> other) throws NullPointerException {
        if (cls == null) {
            throw new NullPointerException();
        }
        if (other == null) {
            return null;
        }
        try {
            return Enum.valueOf(cls, other.name());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static <E extends Enum<E>> E fromName(Class<E> cls, String name) throws NoSuchEnumValueException {
        return EnumUtil.fromName(cls, name, CaseInsensitive.NO);
    }

    public static <E extends Enum<E>> E fromNameSafe(Class<E> cls, String name, Logger log) {
        return EnumUtil.fromNameSafe(cls, name, CaseInsensitive.NO, log);
    }

    public static <E extends Enum<E>> E fromNameSafe(Class<E> cls, String name, boolean writeIncidents) {
        return EnumUtil.fromNameSafe(cls, name, CaseInsensitive.NO, null, writeIncidents);
    }

    public static <E extends Enum<E>> E fromName(Class<E> cls, String name, CaseInsensitive caseSensitivity) throws NoSuchEnumValueException {
        if (cls == null) {
            throw new NullPointerException();
        }
        if (TextUtil.isBlank(name)) {
            return null;
        }
        try {
            if (caseSensitivity == CaseInsensitive.YES) {
                name = name.toUpperCase(Locale.ENGLISH);
            }
            return Enum.valueOf(cls, name);
        }
        catch (IllegalArgumentException iae) {
            throw new NoSuchEnumValueException(cls, name);
        }
    }

    public static <E extends Enum<E>> E fromNameSafe(Class<E> cls, String name, CaseInsensitive noCase, Logger log) {
        return EnumUtil.fromNameSafe(cls, name, noCase, log, true);
    }

    public static <E extends Enum<E>> E fromNameSafe(Class<E> cls, String name, CaseInsensitive noCase, Logger log, boolean writeIncidents) {
        try {
            return EnumUtil.fromName(cls, name, noCase);
        }
        catch (NoSuchEnumValueException e) {
            String message = e.getMessage();
            try {
                String enumName = message.substring(message.lastIndexOf(" "));
                if (message.contains("com.gridnine.xtrip.common.model.system.CardVendor")) {
                    message = "\u0422\u0438\u043f \u043a\u0430\u0440\u0442\u044b " + enumName + " \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0443\u0435\u0442\u0441\u044f \u0432 \u041c\u041e\u041c, \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c.";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (log != null) {
                log.warn(message, (Throwable)e);
            }
            if (writeIncidents) {
                IncidentsLog.reportException(message, e);
            }
            return null;
        }
    }

    public static String nameOf(Enum<? extends Enum<?>> e) {
        return e == null ? null : e.name();
    }

    public static String stringValueOf(Enum<? extends Enum<?>> e) {
        return e == null ? null : e.toString();
    }

    public static <ESrc extends Enum<ESrc>, ETarget extends Enum<ETarget>> ETarget recode(ESrc e, Class<ETarget> targetCls) throws NoSuchEnumValueException {
        if (e == null) {
            return null;
        }
        return EnumUtil.fromName(targetCls, EnumUtil.nameOf(e));
    }

    public static <ESrc extends Enum<ESrc>, ETarget extends Enum<ETarget>> ETarget recodeSafe(ESrc e, Class<ETarget> targetCls) {
        return EnumUtil.recodeSafe(e, targetCls, null);
    }

    public static <ESrc extends Enum<ESrc>, ETarget extends Enum<ETarget>> ETarget recodeSafe(ESrc e, Class<ETarget> targetCls, Logger log) {
        if (e == null) {
            return null;
        }
        return EnumUtil.fromNameSafe(targetCls, EnumUtil.nameOf(e), log);
    }

    private EnumUtil() {
    }

    public static class NoSuchEnumValueException
    extends Exception {
        private static final long serialVersionUID = 6609869214317412971L;

        NoSuchEnumValueException(Class<? extends Enum<?>> cls, String value) {
            super(String.format("no enum constant found in %s for value %s", cls, value));
        }
    }
}

