/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileLockInterruptionException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class ExceptionUtil {
    public static RuntimeException untaint(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e.getMessage(), e);
    }

    public static String getExceptionStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private static <T extends Throwable> void te(Throwable exception) throws T {
        throw exception;
    }

    public static void throwException(Throwable exception) {
        ExceptionUtil.te(exception);
    }

    public static <P, R> Function<P, R> wrapFunction(FunctionWithException<P, R> body) {
        return value -> {
            try {
                return body.apply(value);
            }
            catch (Exception e) {
                ExceptionUtil.throwException(e);
                return null;
            }
        };
    }

    public static <T> Consumer<? super T> wrapConsumer(ConsumerWithException<? super T> body) {
        return value -> {
            try {
                body.accept(value);
            }
            catch (Exception e) {
                ExceptionUtil.throwException(e);
            }
        };
    }

    public static <T> Supplier<T> wrapSupplier(SupplierWithException<T> body) {
        return () -> {
            try {
                return body.get();
            }
            catch (Exception e) {
                ExceptionUtil.throwException(e);
                return null;
            }
        };
    }

    public static <T> Predicate<? super T> wrapPredicate(PredicateWithException<? super T> body) {
        return value -> {
            try {
                return body.test(value);
            }
            catch (Exception e) {
                ExceptionUtil.throwException(e);
                return false;
            }
        };
    }

    public static void wrap(MethodWithException body) {
        try {
            body.apply();
        }
        catch (Exception e) {
            ExceptionUtil.throwException(e);
        }
    }

    public static boolean isInterruptedError(Throwable error) {
        IdentityHashMap map = new IdentityHashMap();
        for (Throwable cause = error; cause != null && !map.containsKey(cause); cause = cause.getCause()) {
            if (!cause.getClass().getSimpleName().toLowerCase().contains("timeout") && (cause instanceof InterruptedException || cause instanceof InterruptedIOException || cause instanceof ClosedByInterruptException || cause instanceof FileLockInterruptionException)) {
                return true;
            }
            map.put(cause, null);
        }
        return false;
    }

    public static Throwable findCause(Throwable throwable) {
        Throwable result = throwable;
        HashSet<Throwable> processed = new HashSet<Throwable>();
        while (result.getCause() != null && !processed.contains(result.getCause())) {
            result = result.getCause();
            processed.add(result);
        }
        return result;
    }

    private ExceptionUtil() {
    }

    @FunctionalInterface
    public static interface PredicateWithException<T> {
        public boolean test(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface SupplierWithException<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface ConsumerWithException<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface MethodWithException {
        public void apply() throws Exception;
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R> {
        public R apply(T var1) throws Exception;
    }
}

