/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormattedNumberUtil {
    public static boolean isValidNumber(String str) {
        if (TextUtil.isBlank(str)) {
            return true;
        }
        return TextUtil.isContainsDigits(str);
    }

    public static String add(String number, Number value) throws NumberFormatException {
        if (value == null) {
            return number;
        }
        return FormattedNumberUtil.add(number, value.longValue());
    }

    public static String add(String number, long amount) throws NumberFormatException {
        if (!TextUtil.isContainsDigits(number)) {
            throw new NumberFormatException("number does not contains any digits");
        }
        if (TextUtil.isBlank(number) || amount == 0L) {
            return number;
        }
        try {
            BigDecimal digit = new BigDecimal(number);
            int paddingValue = digit.compareTo(BigDecimal.ZERO) < 0 ? number.length() - 1 : number.length();
            digit = digit.add(BigDecimal.valueOf(amount));
            return String.format(String.format("%%0%sd", paddingValue += digit.compareTo(BigDecimal.ZERO) < 0 ? 1 : 0), digit.longValue());
        }
        catch (Exception digit) {
            String originalDigitString = number.replaceAll("\\D", "");
            try {
                BigDecimal digit2 = new BigDecimal(originalDigitString);
                digit2 = digit2.add(BigDecimal.valueOf(amount)).abs();
                String digitString = digit2.toString();
                if (digitString.length() > originalDigitString.length()) {
                    digitString = digitString.substring(digitString.length() - originalDigitString.length());
                } else if (digitString.length() < originalDigitString.length()) {
                    int paddingValue = originalDigitString.length();
                    digitString = String.format(String.format("%%0%sd", paddingValue), digit2.longValue());
                }
                Matcher matcher = Pattern.compile("\\d+").matcher(number);
                StringBuffer stringBuffer = new StringBuffer();
                int startIndex = 0;
                int endIndex = 0;
                while (matcher.find()) {
                    endIndex = startIndex + matcher.end() - matcher.start();
                    matcher.appendReplacement(stringBuffer, digitString.substring(startIndex, endIndex));
                    startIndex = endIndex;
                }
                matcher.appendTail(stringBuffer);
                return stringBuffer.toString();
            }
            catch (NumberFormatException numberFormatException) {
                return number;
            }
        }
    }

    public static String subtract(String number, long amount) throws NumberFormatException {
        if (!TextUtil.isContainsDigits(number)) {
            throw new NumberFormatException("number does not contains any digits");
        }
        if (TextUtil.isBlank(number) || amount == 0L) {
            return number;
        }
        try {
            BigDecimal digit = new BigDecimal(number);
            int paddingValue = digit.compareTo(BigDecimal.ZERO) < 0 ? number.length() - 1 : number.length();
            digit = digit.subtract(BigDecimal.valueOf(amount));
            return String.format(String.format("%%0%sd", paddingValue += digit.compareTo(BigDecimal.ZERO) < 0 ? 1 : 0), digit.longValue());
        }
        catch (Exception digit) {
            String originalDigitString = number.replaceAll("\\D", "");
            try {
                BigDecimal digit2 = new BigDecimal(originalDigitString);
                digit2 = digit2.subtract(BigDecimal.valueOf(amount)).abs();
                String digitString = digit2.toString();
                if (digitString.length() > originalDigitString.length()) {
                    digitString = digitString.substring(digitString.length() - originalDigitString.length());
                } else if (digitString.length() < originalDigitString.length()) {
                    int paddingValue = originalDigitString.length();
                    digitString = String.format(String.format("%%0%sd", paddingValue), digit2.longValue());
                }
                Matcher matcher = Pattern.compile("\\d+").matcher(number);
                StringBuffer stringBuffer = new StringBuffer();
                int startIndex = 0;
                int endIndex = 0;
                while (matcher.find()) {
                    endIndex = startIndex + matcher.end() - matcher.start();
                    matcher.appendReplacement(stringBuffer, digitString.substring(startIndex, endIndex));
                    startIndex = endIndex;
                }
                matcher.appendTail(stringBuffer);
                return stringBuffer.toString();
            }
            catch (NumberFormatException numberFormatException) {
                return number;
            }
        }
    }

    public static long diff(String number1, String number2) throws NumberFormatException {
        if (TextUtil.isBlank(number1) || TextUtil.isBlank(number2) || number1.equals(number2)) {
            return 0L;
        }
        BigInteger digit1 = new BigInteger(number1.replaceAll("\\D", ""));
        BigInteger digit2 = new BigInteger(number2.replaceAll("\\D", ""));
        return digit1.subtract(digit2).longValue();
    }

    public static boolean isInRange(String number, String startNumber, long count) throws NumberFormatException {
        if (TextUtil.isBlank(number) || TextUtil.isBlank(startNumber)) {
            return false;
        }
        if (startNumber.equals(number)) {
            return true;
        }
        return FormattedNumberUtil.isInRange(number, startNumber, FormattedNumberUtil.add(startNumber, count));
    }

    public static boolean isInRange(String number, String firstNumber, String lastNumber) throws NumberFormatException {
        BigInteger lastDigit;
        if (TextUtil.isBlank(number) || TextUtil.isBlank(firstNumber) || TextUtil.isBlank(lastNumber)) {
            return false;
        }
        if (firstNumber.equals(number) || lastNumber.equals(number)) {
            return true;
        }
        BigInteger digit = new BigInteger(number.replaceAll("\\D", ""));
        BigInteger firstDigit = new BigInteger(firstNumber.replaceAll("\\D", ""));
        if (firstDigit.compareTo(lastDigit = new BigInteger(lastNumber.replaceAll("\\D", ""))) <= 0) {
            return firstDigit.compareTo(digit) <= 0 && lastDigit.compareTo(digit) >= 0;
        }
        return firstDigit.compareTo(digit) >= 0 && lastDigit.compareTo(digit) <= 0;
    }
}

