/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class ImageUtil {
    public static BufferedImage getScaledInstance(BufferedImage image, double width, double height) {
        if (image == null || width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException();
        }
        AffineTransform at = new AffineTransform();
        at.scale((float)width / (float)image.getWidth(), (float)height / (float)image.getHeight());
        AffineTransformOp ato = new AffineTransformOp(at, 3);
        BufferedImage scaledImage = ato.filter(image, null);
        return scaledImage;
    }

    public static BufferedImage getScaledInstanceToFit(BufferedImage image, double fitWidth, double fitHeight) {
        if (image == null || fitWidth <= 0.0 || fitHeight <= 0.0) {
            throw new IllegalArgumentException();
        }
        double width = image.getWidth();
        double height = image.getHeight();
        double scaleFactor = Math.min(fitWidth / width, fitHeight / height);
        return ImageUtil.getScaledInstance(image, width * scaleFactor, height * scaleFactor);
    }

    public static BufferedImage toBufferedImage(Image image) {
        BufferedImage bi = null;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtil.hasAlpha(image);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bi = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException gs) {
            // empty catch block
        }
        if (bi == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bi = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bi;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            return bi.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static class ImageData {
        private final InputStream data;
        private final int width;
        private final int height;

        public ImageData(byte[] content) {
            ByteArrayInputStream is = null;
            BufferedImage image = null;
            if (content != null) {
                is = new ByteArrayInputStream(content);
                try {
                    image = ImageIO.read(is);
                    ((InputStream)is).reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.data = is;
            this.width = image != null ? image.getWidth() : 0;
            this.height = image != null ? image.getHeight() : 0;
        }

        public InputStream getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

