/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.util.function.Supplier;

public class LazyValueHolder<T> {
    private Supplier<T> supplier;
    private final boolean useSynchronized;
    private T value;
    private boolean valueInitialized;
    private IllegalStateException initializeException;

    public LazyValueHolder() {
        this(null, false);
    }

    public LazyValueHolder(Supplier<T> supplier) {
        this(supplier, false);
    }

    public LazyValueHolder(Supplier<T> supplier, boolean useSynchronized) {
        this.supplier = supplier;
        this.useSynchronized = useSynchronized;
    }

    public void setSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.valueInitialized) {
            return this.value;
        }
        if (this.initializeException != null) {
            throw this.initializeException;
        }
        try {
            if (this.useSynchronized) {
                LazyValueHolder lazyValueHolder = this;
                synchronized (lazyValueHolder) {
                    if (this.valueInitialized) {
                        return this.value;
                    }
                    if (this.initializeException != null) {
                        throw this.initializeException;
                    }
                    this.value = this.supplier.get();
                }
            } else {
                this.value = this.supplier.get();
            }
            this.valueInitialized = true;
        }
        catch (Throwable t) {
            this.initializeException = new IllegalStateException("error during lazy initialization", t);
            throw this.initializeException;
        }
        return this.value;
    }
}

