/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class LocaleUtil {
    public static final Locale LOCALE_EN = LocaleUtil.createLocale(new Locale("EN"));
    public static final Locale LOCALE_RU = LocaleUtil.createLocale(new Locale("RU"));
    public static final Locale LOCALE_UK = LocaleUtil.createLocale(new Locale("UK"));
    public static final Locale LOCALE_BG = LocaleUtil.createLocale(new Locale("BG"));
    public static final Locale LOCALE_HY = LocaleUtil.createLocale(new Locale("HY"));
    public static final Locale LOCALE_AZ = LocaleUtil.createLocale(new Locale("AZ"));
    public static final Locale LOCALE_KA = LocaleUtil.createLocale(new Locale("KA"));
    public static final Locale LOCALE_KK = LocaleUtil.createLocale(new Locale("KK"));
    public static final Locale LOCALE_RU_C = Locale.forLanguageTag("ru-Ru");
    public static final Locale LOCALE_UK_C = Locale.forLanguageTag("uk-Ua");
    public static final Locale LOCALE_BG_C = Locale.forLanguageTag("bg-Bg");
    public static final Locale LOCALE_HY_C = Locale.forLanguageTag("hy-Am");
    public static final Locale LOCALE_AZ_C = Locale.forLanguageTag("az-Az");
    public static final Locale LOCALE_KA_C = Locale.forLanguageTag("ka-Ge");
    public static final Locale LOCALE_KK_C = Locale.forLanguageTag("kk-Kz");

    public static List<Locale> getAvailableLocales() {
        return Arrays.asList(LOCALE_EN, LOCALE_RU, LOCALE_UK, LOCALE_BG, LOCALE_HY, LOCALE_AZ, LOCALE_KA, LOCALE_KK);
    }

    public static List<Locale> getAvailableLocalesWithCountries() {
        return Arrays.asList(LOCALE_EN, LOCALE_RU_C, LOCALE_UK_C, LOCALE_BG_C, LOCALE_HY_C, LOCALE_AZ_C, LOCALE_KA_C, LOCALE_KK_C);
    }

    public static boolean isNormalizedLocale(Locale locale) {
        return locale != null ? TextUtil.isBlank(locale.getCountry()) && TextUtil.isBlank(locale.getVariant()) : false;
    }

    public static Locale createNormalizedLocale(Locale locale) {
        if (locale != null && locale.getLanguage() != null) {
            switch (locale.getLanguage()) {
                case "ru": {
                    return LOCALE_RU;
                }
                case "en": {
                    return LOCALE_EN;
                }
                case "uk": {
                    return LOCALE_UK;
                }
                case "bg": {
                    return LOCALE_BG;
                }
                case "hy": {
                    return LOCALE_HY;
                }
                case "az": {
                    return LOCALE_AZ;
                }
                case "ka": {
                    return LOCALE_KA;
                }
                case "kk": {
                    return LOCALE_KK;
                }
            }
        }
        return LocaleUtil.createLocale(locale);
    }

    private static Locale createLocale(Locale locale) {
        return locale != null ? (LocaleUtil.isNormalizedLocale(locale) ? locale : new Locale(locale.getLanguage(), "", "")) : null;
    }

    public static Locale createNormalizedLocale(String languageCode) {
        return !TextUtil.isBlank(languageCode) ? new Locale(languageCode.trim(), "", "") : null;
    }
}

