/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.InvocationWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiCall {
    private static final Logger log = LoggerFactory.getLogger(MultiCall.class);

    public static <T> List<Throwable> invoke(Callback<T> callback, Set<T> targets) {
        return MultiCall.invoke(callback, targets, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Throwable> invoke(Callback<T> callback, Set<T> targets, long timeout) {
        if (targets.isEmpty()) {
            log.warn(String.format("no targets selected for invocation", new Object[0]));
            return Collections.emptyList();
        }
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        if (targets.size() == 1 && timeout <= 0L) {
            T target = targets.iterator().next();
            log.debug("BEGIN target=" + target);
            try {
                callback.invoke(target);
            }
            catch (Throwable t) {
                log.error("invocation error detected for target " + target, t);
                result.add(t);
            }
            finally {
                log.debug("END target=" + target);
            }
            return result;
        }
        ArrayList<InvocationWorker<T>> threads = new ArrayList<InvocationWorker<T>>();
        for (T target : targets) {
            InvocationWorker<T> thread = new InvocationWorker<T>(target, callback, DebugUtil.isThreadDebugEnabled());
            threads.add(thread);
            log.debug(String.format("created invocation thread for target %s", target));
            thread.start();
        }
        long startTime = System.currentTimeMillis();
        while (!threads.isEmpty()) {
            if (timeout > 0L && System.currentTimeMillis() - startTime > timeout) {
                for (InvocationWorker invocationWorker : threads) {
                    if (!invocationWorker.isAlive()) continue;
                    log.warn("invocation timeout detected for target " + invocationWorker.getTarget());
                    result.add(new TimeoutException(invocationWorker.getTarget()));
                    invocationWorker.interrupt();
                }
                break;
            }
            boolean interrupted = Thread.currentThread().isInterrupted();
            if (!interrupted) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (!interrupted) {
                Iterator iterator = threads.iterator();
                while (iterator.hasNext()) {
                    InvocationWorker invocationWorker = (InvocationWorker)iterator.next();
                    if (invocationWorker.isAlive()) continue;
                    iterator.remove();
                    if (invocationWorker.getError() == null) continue;
                    result.add(invocationWorker.getError());
                }
            }
            if (!interrupted) continue;
            for (InvocationWorker invocationWorker : threads) {
                if (!invocationWorker.isAlive()) continue;
                log.warn("invocation interrupted for target " + invocationWorker.getTarget());
                invocationWorker.interrupt();
            }
            break;
        }
        log.debug("multi-thread invocation done");
        return result;
    }

    private MultiCall() {
    }

    public static class TimeoutException
    extends Exception {
        private static final long serialVersionUID = -7627768210706194934L;
        private final Object target;

        public TimeoutException(Object tgt) {
            this.target = tgt;
        }

        public Object getTarget() {
            return this.target;
        }
    }

    public static interface Callback<T> {
        public void invoke(T var1) throws Exception;
    }
}

