/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

class Node<T>
implements Serializable {
    private static final long serialVersionUID = -8901780439404667814L;
    String string;
    T value;
    Node<T> parent;
    Node<T> prev;
    Node<T> next;
    final LinkedList<Node<T>> children = new LinkedList();

    Node() {
    }

    static <T> T remove(LinkedList<Node<T>> nodes, String key) {
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            T result;
            Node node = (Node)it.next();
            if (key.equals(node.string)) {
                if (node.children.isEmpty()) {
                    if (node.prev != null) {
                        node.prev.next = node.next;
                    }
                    if (node.next != null) {
                        node.next.prev = node.prev;
                    }
                    it.remove();
                    return node.value;
                }
                result = node.value;
                node.value = null;
                return result;
            }
            if (!key.startsWith(node.string) || (result = Node.remove(node.children, key.substring(node.string.length()))) == null) continue;
            return result;
        }
        return null;
    }

    static <T> Node<T> find(LinkedList<Node<T>> nodes, String key) {
        if (TextUtil.isBlank(key)) {
            return null;
        }
        for (Node node : nodes) {
            if (key.startsWith(node.string)) {
                if (key.equals(node.string)) {
                    return node;
                }
                return Node.find(node.children, key.substring(node.string.length()));
            }
            if (!node.string.startsWith(key)) continue;
            return node;
        }
        return null;
    }

    private static int match(String str1, String str2) {
        int i;
        for (i = 0; i < str1.length() && i < str2.length() && str1.charAt(i) == str2.charAt(i); ++i) {
        }
        return i - 1;
    }

    void clear() {
        for (Node node : this.children) {
            node.clear();
        }
        this.children.clear();
        this.string = null;
        this.value = null;
    }

    Node<T> get(String key) {
        if (key.equals(this.string)) {
            return this;
        }
        if (!key.startsWith(this.string)) {
            return null;
        }
        String subKey = key.substring(this.string.length());
        for (Node node : this.children) {
            Node<T> result = node.get(subKey);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    Node<T> put(String key) {
        if (key.equals(this.string)) {
            return this;
        }
        int matchPos = Node.match(this.string, key);
        if (matchPos == -1) {
            return null;
        }
        if (matchPos == this.string.length() - 1) {
            String subKey = key.substring(this.string.length());
            for (Node node : this.children) {
                Node<T> result = node.put(subKey);
                if (result == null) continue;
                return result;
            }
            Node<T> result = new Node<T>();
            result.string = subKey.intern();
            if (!this.children.isEmpty()) {
                this.children.getLast().next = result;
                result.prev = this.children.getLast();
            }
            result.parent = this;
            this.children.add(result);
            return result;
        }
        if (matchPos == key.length() - 1) {
            Node<T> node = new Node<T>();
            node.string = this.string.substring(key.length()).intern();
            node.value = this.value;
            node.children.addAll(this.children);
            node.parent = this;
            for (Node node2 : this.children) {
                node2.parent = node;
            }
            this.string = key.intern();
            this.value = null;
            this.children.clear();
            this.children.add(node);
            return this;
        }
        Node<T> node = new Node<T>();
        node.string = this.string.substring(matchPos + 1).intern();
        node.value = this.value;
        this.value = null;
        node.children.addAll(this.children);
        node.parent = this;
        for (Node node3 : this.children) {
            node3.parent = node;
        }
        Node<T> result = new Node<T>();
        result.string = key.substring(matchPos + 1).intern();
        this.string = this.string.substring(0, matchPos + 1).intern();
        this.children.clear();
        this.children.add(node);
        this.children.getLast().next = result;
        result.prev = this.children.getLast();
        result.parent = this;
        this.children.add(result);
        return result;
    }

    String getKey() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.string);
        Node<T> p = this.parent;
        while (p != null) {
            buf.insert(0, p.string);
            p = p.parent;
        }
        return buf.toString();
    }

    public String toString() {
        return String.format("{Node: %s=%s (%s)}", this.string, this.value, this.children.size());
    }
}

