/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.Node;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

class NodesIterator<T>
implements Iterator<Map.Entry<String, T>> {
    private final Node<T> root;
    private Node<T> current;

    NodesIterator(Node<T> node) {
        this.root = node;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return this.getNext(this.current) != null;
        }
        if (this.root == null) {
            return false;
        }
        if (this.root.value != null) {
            return true;
        }
        return this.getNext(this.root) != null;
    }

    @Override
    public Map.Entry<String, T> next() {
        this.current = this.current != null ? this.getNext(this.current) : (this.root == null ? null : (this.root.value != null ? this.root : this.getNext(this.root)));
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        final Node<T> result = this.current;
        return new Map.Entry<String, T>(){

            @Override
            public String getKey() {
                return result.getKey();
            }

            @Override
            public T getValue() {
                return result.value;
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Node<T> getNext(Node<T> node) {
        Node<T> result = node;
        while ((result = this.getNextInternal(result)) != null && result.value == null) {
        }
        return result;
    }

    private Node<T> getNextInternal(Node<T> node) {
        if (!node.children.isEmpty()) {
            return node.children.getFirst();
        }
        if (node == this.root) {
            return null;
        }
        if (node.next != null) {
            return node.next;
        }
        Node result = node.parent;
        while (result != this.root) {
            if (result.next != null) {
                return result.next;
            }
            result = result.parent;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("not implemented yet");
    }
}

