/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.common.util.TextUtil;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectTrace {
    public static final ObjectFilter<PropertyDescriptor> STANDARD_FILTER = descr -> {
        try {
            if (descr.getName().toLowerCase().contains("hibernate")) {
                return false;
            }
            Class<?> propertyType = descr.getPropertyType();
            if (propertyType == null) {
                return false;
            }
            if (Annotation.class.isAssignableFrom(propertyType)) {
                return false;
            }
            if (InputStream.class.isAssignableFrom(propertyType)) {
                return false;
            }
            if (OutputStream.class.isAssignableFrom(propertyType)) {
                return false;
            }
            if (Reader.class.isAssignableFrom(propertyType)) {
                return false;
            }
            return !Writer.class.isAssignableFrom(propertyType);
        }
        catch (Throwable t) {
            return false;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ObjectTrace.class);

    public static String toString(Object obj) throws IOException {
        StringBuilder sb = new StringBuilder();
        ObjectTrace.trace(sb, obj);
        return sb.toString();
    }

    public static void trace(Appendable buf, Object obj) throws IOException {
        ObjectTrace.trace(buf, obj, STANDARD_FILTER, true);
    }

    public static void trace(Appendable buf, Object obj, ObjectFilter<PropertyDescriptor> filter) throws IOException {
        ObjectTrace.trace(buf, obj, filter, true);
    }

    public static void trace(Appendable buf, Object obj, ObjectFilter<PropertyDescriptor> filter, boolean withNull) throws IOException {
        ObjectTrace.trace(buf, obj, filter, withNull, true, true, false);
    }

    public static void trace(Appendable buf, Object obj, ObjectFilter<PropertyDescriptor> filter, boolean withNull, boolean withSkipped, boolean withEmptyCollections, boolean sortProperties) throws IOException {
        if (obj == null) {
            buf.append("NULL");
            return;
        }
        buf.append("{\r\n");
        TraceProperties props = new TraceProperties();
        props.withNull = withNull;
        props.withSkipped = withSkipped;
        props.withEmptyCollections = withEmptyCollections;
        props.sortProperties = sortProperties;
        ObjectTrace.trace(buf, obj, 2, new HashSet<Object>(), filter, props);
        buf.append("}");
    }

    public static void traceToLog(String msg, Iterable<?> it) {
        if (!log.isDebugEnabled()) {
            return;
        }
        int i = 1;
        for (Object entry : it) {
            ObjectTrace.traceToLog(msg + ", N=" + i++, entry);
        }
    }

    public static void traceToLog(String msg, Object obj) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (obj == null) {
            log.debug(msg + "\r\nNULL");
        }
        try {
            StringBuilder buf = new StringBuilder();
            ObjectTrace.trace(buf, obj);
            log.debug(msg + "\r\n" + buf);
        }
        catch (Throwable t) {
            log.error("failed tracing bean " + obj, t);
        }
    }

    private static void trace(Appendable buf, Object obj, int level, Set<Object> processed, ObjectFilter<PropertyDescriptor> filter, TraceProperties props) throws IOException {
        String indent = TextUtil.fillLeft("", level);
        if (processed.contains(obj)) {
            buf.append(indent).append("recursive call detected\r\n");
            return;
        }
        processed.add(obj);
        try {
            PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(obj.getClass());
            if (props.sortProperties) {
                ArrayList<PropertyDescriptor> descriptorsList = new ArrayList<PropertyDescriptor>(Arrays.asList(descriptors));
                descriptorsList.sort((o1, o2) -> MiscUtil.compare(o1.getName(), o2.getName()));
                descriptorsList.toArray(descriptors);
            }
            for (PropertyDescriptor descr : descriptors) {
                if (!filter.accept(descr)) {
                    if (!props.withSkipped) continue;
                    try {
                        buf.append(indent).append(descr.getName()).append(":skipped ").append(descr.getPropertyType().toString()).append(",\r\n");
                    }
                    catch (Throwable t) {
                        buf.append(indent).append(descr.getName()).append(":skipped,\r\n");
                    }
                    continue;
                }
                Object value = ObjectTrace.getValue(obj, descr.getName());
                if (value == null) {
                    if (!props.withNull) continue;
                    buf.append(indent).append(descr.getName()).append(":NULL,\r\n");
                    continue;
                }
                String str = ObjectTrace.handleSimpleObject(value);
                if (str != null) {
                    buf.append(indent).append(descr.getName()).append(':').append(str).append(",\r\n");
                    continue;
                }
                if (value instanceof Object[]) {
                    buf.append(indent).append(descr.getName()).append(":\r\n");
                    buf.append(indent).append("[\r\n");
                    ObjectTrace.trace(buf, new ArrayList<Object>(Arrays.asList((Object[])value)), level + 2, processed, filter, props);
                    buf.append(indent).append("],\r\n");
                    continue;
                }
                Class<?> eClass = value.getClass();
                if (eClass.isArray()) {
                    buf.append(indent).append(descr.getName()).append(':');
                    if (eClass == byte[].class) {
                        buf.append(Arrays.toString((byte[])value));
                    } else if (eClass == short[].class) {
                        buf.append(Arrays.toString((short[])value));
                    } else if (eClass == int[].class) {
                        buf.append(Arrays.toString((int[])value));
                    } else if (eClass == long[].class) {
                        buf.append(Arrays.toString((long[])value));
                    } else if (eClass == char[].class) {
                        buf.append(Arrays.toString((char[])value));
                    } else if (eClass == float[].class) {
                        buf.append(Arrays.toString((float[])value));
                    } else if (eClass == double[].class) {
                        buf.append(Arrays.toString((double[])value));
                    } else if (eClass == boolean[].class) {
                        buf.append(Arrays.toString((boolean[])value));
                    } else {
                        buf.append(value.toString());
                    }
                    buf.append(",\r\n");
                    continue;
                }
                if (value instanceof Iterable) {
                    Iterable factValue = (Iterable)value;
                    if (!factValue.iterator().hasNext() && !props.withEmptyCollections) continue;
                    buf.append(indent).append(descr.getName()).append(":\r\n");
                    buf.append(indent).append("[\r\n");
                    ObjectTrace.trace(buf, factValue, level + 2, processed, filter, props);
                    buf.append(indent).append("],\r\n");
                    continue;
                }
                if (value instanceof Map) {
                    buf.append(indent).append(descr.getName()).append(":\r\n");
                    buf.append(indent).append("[\r\n");
                    ObjectTrace.trace(buf, ((Map)value).entrySet(), level + 2, processed, filter, props);
                    buf.append(indent).append("]\r\n");
                    continue;
                }
                buf.append(indent).append(descr.getName()).append('@').append(Integer.toHexString(value.hashCode())).append(":\r\n");
                buf.append(indent).append("{\r\n");
                ObjectTrace.trace(buf, value, level + 2, processed, filter, props);
                buf.append(indent).append("},\r\n");
            }
            if (descriptors.length == 0) {
                buf.append(indent).append("toString():").append(obj.toString()).append("\r\n");
            }
        }
        catch (Throwable t) {
            buf.append(indent).append("failed tracing obj ").append(String.valueOf(obj)).append(", error is ").append(t.toString()).append("\r\n");
        }
        processed.remove(obj);
    }

    private static void trace(Appendable buf, Iterable<?> coll, int level, Set<Object> processed, ObjectFilter<PropertyDescriptor> filter, TraceProperties props) throws IOException {
        String indent2 = TextUtil.fillLeft("", level);
        for (Object item : coll) {
            if (item == null) {
                buf.append(indent2).append("NULL").append(",\r\n");
                continue;
            }
            String itemStr = ObjectTrace.handleSimpleObject(item);
            if (itemStr != null) {
                buf.append(indent2).append(itemStr).append(",\r\n");
                continue;
            }
            buf.append(indent2).append("{\r\n");
            if (item instanceof Object[]) {
                ObjectTrace.trace(buf, new ArrayList<Object>(Arrays.asList((Object[])item)), level + 2, processed, filter, props);
            } else if (item instanceof Iterable) {
                ObjectTrace.trace(buf, (Iterable)item, level + 2, processed, filter, props);
            } else if (item instanceof Map) {
                ObjectTrace.trace(buf, ((Map)item).entrySet(), level + 2, processed, filter, props);
            } else {
                ObjectTrace.trace(buf, item, level + 2, processed, filter, props);
            }
            buf.append(indent2).append("},\r\n");
        }
    }

    private static String handleSimpleObject(Object value) {
        if (value instanceof CharSequence) {
            return "\"" + ObjectTrace.escape(value.toString()) + "\"";
        }
        if (value instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(value);
        }
        if (value instanceof Calendar) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z").format(((Calendar)value).getTime());
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "true" : "false";
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof Locale) {
            return value.toString();
        }
        if (value instanceof Currency) {
            return ((Currency)value).getCurrencyCode();
        }
        if (value instanceof URL) {
            return value.toString();
        }
        if (value instanceof URI) {
            return value.toString();
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (value instanceof Void) {
            return "VOID";
        }
        return null;
    }

    private static Object getValue(Object obj, String property) {
        try {
            return PropertyUtils.getProperty((Object)obj, (String)property);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private static String escape(String str) {
        return str.replaceAll("\\\"", "\\\\\"").replaceAll("\\\\", "\\\\\\\\").replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n").replaceAll("\\t", "\\\\t");
    }

    private ObjectTrace() {
    }

    static class TraceProperties {
        boolean withNull = true;
        boolean withSkipped = true;
        boolean withEmptyCollections = true;
        boolean sortProperties = false;

        TraceProperties() {
        }
    }
}

