/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

public final class PairUtil {
    public static <T extends Comparable<T>> boolean match(Pair<T> pair, T value) {
        if (value == null) {
            return false;
        }
        if (pair.getFirst() != null && value.compareTo(pair.getFirst()) < 0) {
            return false;
        }
        return pair.getLast() == null || value.compareTo(pair.getLast()) <= 0;
    }

    public static <T> boolean match(Pair<T> pair, T value, Comparator<T> comparator) {
        if (value == null) {
            return false;
        }
        if (pair.getFirst() != null && comparator.compare(value, pair.getFirst()) < 0) {
            return false;
        }
        return pair.getLast() == null || comparator.compare(value, pair.getLast()) <= 0;
    }

    public static boolean matchDate(Pair<Date> pair, Date value) {
        if (value == null) {
            return false;
        }
        long val = MiscUtil.clearTime(value).getTime();
        if (pair.getFirst() != null && val < MiscUtil.clearTime(pair.getFirst()).getTime()) {
            return false;
        }
        return pair.getLast() == null || val <= MiscUtil.clearTime(pair.getLast()).getTime();
    }

    public static boolean matchTime(Pair<Date> pair, Date value) {
        if (value == null) {
            return false;
        }
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(value);
        int val = cldr.get(11) * 60 + cldr.get(12);
        if (pair.getFirst() != null) {
            cldr.setTime(pair.getFirst());
            if (val < cldr.get(11) * 60 + cldr.get(12)) {
                return false;
            }
        }
        if (pair.getLast() != null) {
            cldr.setTime(pair.getLast());
            if (val > cldr.get(11) * 60 + cldr.get(12)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isOvernight(Pair<Date> pair) {
        if (pair.getFirst() == null || pair.getLast() == null) {
            return false;
        }
        return MiscUtil.compare(MiscUtil.clearTime(pair.getFirst()), MiscUtil.clearTime(pair.getLast())) != 0;
    }

    public static int getDurationInMinutes(Pair<Date> pair) {
        if (pair.getFirst() == null || pair.getLast() == null) {
            return 0;
        }
        long diff = pair.getLast().getTime() - pair.getFirst().getTime();
        return (int)(diff / 1000L / 60L);
    }

    private PairUtil() {
    }
}

