/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplacementUtils {
    private static final String[] emptyStringArray = new String[0];

    private ReplacementUtils() {
    }

    public static final String replace(Pattern pattern, String text, Delegate delegate) {
        StringBuilder result = new StringBuilder(text.length());
        ArrayList<int[]> matchedPairs = new ArrayList<int[]>();
        Matcher m = pattern.matcher(text);
        while (m.find()) {
            matchedPairs.add(new int[]{m.start(), m.end()});
        }
        int prevTextPartStart = 0;
        for (int[] pair : matchedPairs) {
            result.append(text.substring(prevTextPartStart, pair[0]));
            result.append(delegate.handleReplacement(text.substring(pair[0], pair[1])));
            prevTextPartStart = pair[1];
        }
        result.append(text.substring(prevTextPartStart, text.length()));
        return result.toString();
    }

    public static final String replace(Pattern pattern, String text, DelegateExtended delegate) {
        int i;
        StringBuilder result = new StringBuilder(text.length());
        ArrayList<int[]> matchedPairs = new ArrayList<int[]>();
        ArrayList<String[]> matchedGroups = new ArrayList<String[]>();
        Matcher m = pattern.matcher(text);
        while (m.find()) {
            matchedPairs.add(new int[]{m.start(), m.end()});
            int groupsCount = m.groupCount();
            if (groupsCount != 0) {
                String[] gr = new String[groupsCount];
                for (i = 0; i < groupsCount; ++i) {
                    gr[i] = m.group(i + 1);
                }
                matchedGroups.add(gr);
                continue;
            }
            matchedGroups.add(emptyStringArray);
        }
        int prevTextPartStart = 0;
        int l = matchedPairs.size();
        for (i = 0; i < l; ++i) {
            int[] pair = (int[])matchedPairs.get(i);
            String[] groups = (String[])matchedGroups.get(i);
            result.append(text.substring(prevTextPartStart, pair[0]));
            result.append(delegate.handleReplacement(text.substring(pair[0], pair[1]), groups));
            prevTextPartStart = pair[1];
        }
        result.append(text.substring(prevTextPartStart, text.length()));
        return result.toString();
    }

    public static interface DelegateExtended {
        public String handleReplacement(String var1, String[] var2);
    }

    public static interface Delegate {
        public String handleReplacement(String var1);
    }
}

