/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.InvocationContext;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XReference;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;

public class XCloneHelper {
    private static Set<String> immutableClasses = new HashSet<String>();

    public static <T extends XCloneable> List<T> cloneList(List<T> sourceList) throws Exception {
        if (sourceList == null) {
            return null;
        }
        int sourceListSize = sourceList.size();
        ArrayList<XCloneable> cloneList = new ArrayList<XCloneable>(sourceListSize);
        if (sourceListSize == 0) {
            return cloneList;
        }
        for (XCloneable sourceObject : sourceList) {
            XCloneable cloneObject = XCloneHelper.clone(sourceObject);
            cloneList.add(cloneObject);
        }
        return cloneList;
    }

    public static <T extends XCloneable> T clone(T sourceObject) throws Exception {
        return XCloneHelper.clone(sourceObject, false);
    }

    public static <T extends XCloneable> T clone(T sourceObject, boolean newUids, Set<String> excludedObjectUids) throws Exception {
        if (sourceObject == null) {
            return null;
        }
        HashMap<String, String> uids = new HashMap<String, String>();
        if (CollectionUtil.isNotEmpty(excludedObjectUids)) {
            excludedObjectUids.forEach(excludeUid -> uids.put((String)excludeUid, (String)excludeUid));
        }
        return (T)((XCloneable)sourceObject.clone(newUids, uids));
    }

    public static <T extends XCloneable> T clone(T sourceObject, boolean newUids) throws Exception {
        return XCloneHelper.clone(sourceObject, newUids, null);
    }

    public static java.util.Date cloneDate(java.util.Date sourceObject) {
        if (sourceObject == null) {
            return null;
        }
        return new java.util.Date(sourceObject.getTime());
    }

    public static <T> Collection<T> cloneCollection(Collection<T> sourceCollection, boolean newUids, Map<String, String> uids) throws Exception {
        if (sourceCollection == null) {
            return null;
        }
        int sourceCollectionSize = sourceCollection.size();
        AbstractCollection cloneCollection = List.class.isInstance(sourceCollection) ? new ArrayList(sourceCollectionSize) : new LinkedHashSet(sourceCollectionSize);
        if (sourceCollectionSize == 0) {
            return cloneCollection;
        }
        if (sourceCollection instanceof List) {
            if (!(sourceCollection instanceof RandomAccess)) {
                IncidentsLog.reportStackTrace("List and not RandomAccess");
            }
            List sourceList = (List)sourceCollection;
            for (int i = 0; i < sourceCollectionSize; ++i) {
                Object sourceObject = sourceList.get(i);
                Object cloneObject = XCloneHelper.cloneObject(sourceObject, newUids, uids);
                cloneCollection.add(cloneObject);
            }
        } else {
            for (T sourceObject : sourceCollection) {
                T cloneObject = XCloneHelper.cloneObject(sourceObject, newUids, uids);
                cloneCollection.add(cloneObject);
            }
        }
        return cloneCollection;
    }

    public static <T> T cloneArray(T sourceArray, boolean newUids, Map<String, String> uids) throws Exception {
        if (sourceArray == null) {
            return null;
        }
        int sourceArrayLength = Array.getLength(sourceArray);
        Class<?> arrayTypeCls = sourceArray.getClass().getComponentType();
        Object cloneArray = Array.newInstance(arrayTypeCls, sourceArrayLength);
        if (sourceArrayLength == 0) {
            return (T)cloneArray;
        }
        if (immutableClasses.contains(arrayTypeCls.getName())) {
            System.arraycopy(sourceArray, 0, cloneArray, 0, sourceArrayLength);
        } else {
            for (int i = 0; i < sourceArrayLength; ++i) {
                Object sourceObject = Array.get(sourceArray, i);
                Object cloneObject = XCloneHelper.cloneObject(sourceObject, newUids, uids);
                Array.set(cloneArray, i, cloneObject);
            }
        }
        return (T)cloneArray;
    }

    public static <K, V> Map<K, V> cloneMap(Map<K, V> sourceMap, boolean newUids, Map<String, String> uids) throws Exception {
        if (sourceMap == null) {
            return null;
        }
        Map cloneMap = (Map)sourceMap.getClass().newInstance();
        if (sourceMap.size() == 0) {
            return cloneMap;
        }
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            K cloneKey = XCloneHelper.cloneObject(entry.getKey(), newUids, uids);
            V cloneValue = XCloneHelper.cloneObject(entry.getValue(), newUids, uids);
            cloneMap.put(cloneKey, cloneValue);
        }
        return cloneMap;
    }

    public static <T> T cloneObject(T obj, boolean newUids, Map<String, String> uids) throws Exception {
        if (obj == null) {
            return null;
        }
        if (immutableClasses.contains(obj.getClass().getName())) {
            return obj;
        }
        if (obj.getClass().getName().equals(java.util.Date.class.getName())) {
            return (T)XCloneHelper.cloneDate((java.util.Date)obj);
        }
        if (obj.getClass().getName().equals(Date.class.getName())) {
            return (T)new Date(((Date)obj).getTime());
        }
        if (obj.getClass().getName().equals(Time.class.getName())) {
            return (T)new Time(((Time)obj).getTime());
        }
        if (obj.getClass().getName().equals(Timestamp.class.getName())) {
            return (T)new Timestamp(((Timestamp)obj).getTime());
        }
        if (Collection.class.isAssignableFrom(obj.getClass())) {
            return (T)XCloneHelper.cloneCollection((Collection)obj, newUids, uids);
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            return (T)XCloneHelper.cloneMap((Map)obj, newUids, uids);
        }
        if (obj instanceof Enum) {
            return obj;
        }
        if (obj.getClass().isArray()) {
            return XCloneHelper.cloneArray(obj, newUids, uids);
        }
        if (obj instanceof Pair) {
            Pair pair = (Pair)obj;
            return (T)new Pair(XCloneHelper.cloneObject(pair.getFirst(), newUids, uids), XCloneHelper.cloneObject(pair.getLast(), newUids, uids));
        }
        if (obj instanceof XCloneable) {
            if (Identity.class.isInstance(obj) && !XReference.class.isInstance(obj)) {
                Identity identity = (Identity)obj;
                String uid = XCloneHelper.getNewUid(identity.getUid(), newUids, uids);
                Identity result = InvocationContext.get("entityClone").getIdentity(uid);
                if (Objects.nonNull(result)) {
                    Class<?> resultClass;
                    Class<?> identityClass = identity.getClass();
                    if (!identityClass.equals(resultClass = result.getClass())) {
                        String errorMessage = String.format("%s cannot be cast to %s by uid=%s", resultClass.getName(), identityClass.getName(), uid);
                        IncidentsLog.reportStackTrace(errorMessage);
                        throw new ClassCastException(errorMessage);
                    }
                    return (T)result;
                }
            }
            return (T)((XCloneable)obj).clone(newUids, uids);
        }
        throw new Exception("cloneObject doesn't support the following class " + obj.getClass().getName());
    }

    public static String getNewUid(String uid, boolean newUids, Map<String, String> uids) {
        if (!newUids) {
            return uid;
        }
        String newUid = uids.get(uid);
        if (newUid == null) {
            newUid = UUIDUtil.toString(UUID.randomUUID());
            uids.put(uid, newUid);
        }
        return newUid;
    }

    static {
        immutableClasses.add(String.class.getName());
        immutableClasses.add(Boolean.class.getName());
        immutableClasses.add(Boolean.TYPE.getName());
        immutableClasses.add(Byte.class.getName());
        immutableClasses.add(Byte.TYPE.getName());
        immutableClasses.add(Character.class.getName());
        immutableClasses.add(Character.TYPE.getName());
        immutableClasses.add(Short.class.getName());
        immutableClasses.add(Short.TYPE.getName());
        immutableClasses.add(Integer.class.getName());
        immutableClasses.add(Integer.TYPE.getName());
        immutableClasses.add(Long.class.getName());
        immutableClasses.add(Long.TYPE.getName());
        immutableClasses.add(Float.class.getName());
        immutableClasses.add(Float.TYPE.getName());
        immutableClasses.add(Double.class.getName());
        immutableClasses.add(Double.TYPE.getName());
        immutableClasses.add(BigDecimal.class.getName());
        immutableClasses.add(BigInteger.class.getName());
        immutableClasses.add(Locale.class.getName());
        immutableClasses.add(URL.class.getName());
        immutableClasses.add(URI.class.getName());
        immutableClasses.add(UUID.class.getName());
        immutableClasses.add(LocalDate.class.getName());
        immutableClasses.add(java.time.LocalTime.class.getName());
        immutableClasses.add(LocalDateTime.class.getName());
        immutableClasses.add(org.joda.time.LocalDate.class.getName());
        immutableClasses.add(LocalTime.class.getName());
        immutableClasses.add(org.joda.time.LocalDateTime.class.getName());
        immutableClasses.add(DateTime.class.getName());
    }
}

