/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.interceptors.HasPriority;
import com.gridnine.xtrip.common.util.interceptors.InterceptorsRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterceptorsHelper {
    private static final Logger log = LoggerFactory.getLogger(InterceptorsHelper.class);
    static final Comparator<HasPriority> INTERCEPTORS_COMPARATOR = new Comparator<HasPriority>(){

        @Override
        public int compare(HasPriority o1, HasPriority o2) {
            return Double.compare(o1.getPriority(), o2.getPriority());
        }
    };

    public static <I extends HasPriority> Exception performInterception(Class<I> cls, CodeInterceptorCallback<I> callback, Object ... arguments) {
        Exception result = null;
        for (HasPriority item : Environment.getPublished(InterceptorsRegistry.class).getInterceptors(cls)) {
            try {
                callback.execute(item, arguments);
            }
            catch (Exception e) {
                result = e;
                log.error("unable to perform operation with interceptor " + item, (Throwable)e);
                break;
            }
        }
        return result;
    }

    public static <I extends HasPriority> void sort(List<I> items) {
        Collections.sort(items, INTERCEPTORS_COMPARATOR);
    }

    private InterceptorsHelper() {
    }

    public static interface CodeInterceptorCallback<I extends HasPriority> {
        public void execute(I var1, Object ... var2) throws Exception;
    }
}

