/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StAXRecorder
implements XMLStreamWriter {
    private final List<Event> events = new ArrayList<Event>();

    public void clear() {
        this.events.clear();
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public void write(StAXRecorder recorder) {
        this.events.addAll(recorder.events);
    }

    public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        block27: for (Event event : this.events) {
            switch (event.type) {
                case START_ELEMENT1: {
                    writer.writeStartElement(event.p1);
                    continue block27;
                }
                case START_ELEMENT2: {
                    writer.writeStartElement(event.p1, event.p2);
                    continue block27;
                }
                case START_ELEMENT3: {
                    writer.writeStartElement(event.p1, event.p2, event.p3);
                    continue block27;
                }
                case EMPTY_ELEMENT1: {
                    writer.writeEmptyElement(event.p1);
                    continue block27;
                }
                case EMPTY_ELEMENT2: {
                    writer.writeEmptyElement(event.p1, event.p2);
                    continue block27;
                }
                case EMPTY_ELEMENT3: {
                    writer.writeEmptyElement(event.p1, event.p2, event.p3);
                    continue block27;
                }
                case END_ELEMENT: {
                    writer.writeEndElement();
                    continue block27;
                }
                case END_DOCUMENT: {
                    writer.writeEndDocument();
                    continue block27;
                }
                case ATTRIBUTE1: {
                    writer.writeAttribute(event.p1, event.p2);
                    continue block27;
                }
                case ATTRIBUTE2: {
                    writer.writeAttribute(event.p1, event.p2, event.p3);
                    continue block27;
                }
                case ATTRIBUTE3: {
                    writer.writeAttribute(event.p1, event.p2, event.p3, event.p4);
                    continue block27;
                }
                case DEFAULT_NAMESPACE: {
                    writer.writeDefaultNamespace(event.p1);
                    continue block27;
                }
                case NAMESPACE: {
                    writer.writeNamespace(event.p1, event.p2);
                    continue block27;
                }
                case COMMENT: {
                    writer.writeComment(event.p1);
                    continue block27;
                }
                case PROCESSING_INSTRUCTION1: {
                    writer.writeProcessingInstruction(event.p1);
                    continue block27;
                }
                case PROCESSING_INSTRUCTION2: {
                    writer.writeProcessingInstruction(event.p1, event.p2);
                    continue block27;
                }
                case CDATA: {
                    writer.writeCData(event.p1);
                    continue block27;
                }
                case DTD: {
                    writer.writeDTD(event.p1);
                    continue block27;
                }
                case ENTITY_REF: {
                    writer.writeEntityRef(event.p1);
                    continue block27;
                }
                case START_DOCUMENT1: {
                    writer.writeStartDocument();
                    continue block27;
                }
                case START_DOCUMENT2: {
                    writer.writeStartDocument(event.p1);
                    continue block27;
                }
                case START_DOCUMENT3: {
                    writer.writeStartDocument(event.p1, event.p2);
                    continue block27;
                }
                case CHARACTERS: {
                    writer.writeCharacters(event.p1);
                    continue block27;
                }
                case SET_PREFIX: {
                    writer.setPrefix(event.p1, event.p2);
                    continue block27;
                }
                case SET_DEFAULT_NAMESPACE: {
                    writer.setDefaultNamespace(event.p1);
                    continue block27;
                }
            }
            throw new UnsupportedOperationException(event.type.name());
        }
    }

    @Override
    public void writeStartElement(String localName) {
        Event event = new Event();
        event.type = EventType.START_ELEMENT1;
        event.p1 = localName;
        this.events.add(event);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        Event event = new Event();
        event.type = EventType.START_ELEMENT2;
        event.p1 = namespaceURI;
        event.p2 = localName;
        this.events.add(event);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        Event event = new Event();
        event.type = EventType.START_ELEMENT3;
        event.p1 = prefix;
        event.p2 = namespaceURI;
        event.p3 = localName;
        this.events.add(event);
    }

    @Override
    public void writeEmptyElement(String localName) {
        Event event = new Event();
        event.type = EventType.EMPTY_ELEMENT1;
        event.p1 = localName;
        this.events.add(event);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        Event event = new Event();
        event.type = EventType.EMPTY_ELEMENT2;
        event.p1 = namespaceURI;
        event.p2 = localName;
        this.events.add(event);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        Event event = new Event();
        event.type = EventType.EMPTY_ELEMENT3;
        event.p1 = prefix;
        event.p2 = namespaceURI;
        event.p3 = localName;
        this.events.add(event);
    }

    @Override
    public void writeEndElement() {
        Event event = new Event();
        event.type = EventType.END_ELEMENT;
        this.events.add(event);
    }

    @Override
    public void writeEndDocument() {
        Event event = new Event();
        event.type = EventType.END_DOCUMENT;
        this.events.add(event);
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public void writeAttribute(String localName, String value) {
        if (null == localName || null == value) {
            throw new NullPointerException();
        }
        Event event = new Event();
        event.type = EventType.ATTRIBUTE1;
        event.p1 = localName;
        event.p2 = value;
        this.events.add(event);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        Event event = new Event();
        event.type = EventType.ATTRIBUTE2;
        event.p1 = namespaceURI;
        event.p2 = localName;
        event.p3 = value;
        this.events.add(event);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        Event event = new Event();
        event.type = EventType.ATTRIBUTE3;
        event.p1 = prefix;
        event.p2 = namespaceURI;
        event.p3 = localName;
        event.p4 = value;
        this.events.add(event);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
        Event event = new Event();
        event.type = EventType.DEFAULT_NAMESPACE;
        event.p1 = namespaceURI;
        this.events.add(event);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        Event event = new Event();
        event.type = EventType.NAMESPACE;
        event.p1 = prefix;
        event.p2 = namespaceURI;
        this.events.add(event);
    }

    @Override
    public void writeComment(String data) {
        Event event = new Event();
        event.type = EventType.COMMENT;
        event.p1 = data;
        this.events.add(event);
    }

    @Override
    public void writeProcessingInstruction(String target) {
        Event event = new Event();
        event.type = EventType.PROCESSING_INSTRUCTION1;
        event.p1 = target;
        this.events.add(event);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        Event event = new Event();
        event.type = EventType.PROCESSING_INSTRUCTION2;
        event.p1 = target;
        event.p2 = data;
        this.events.add(event);
    }

    @Override
    public void writeCData(String data) {
        Event event = new Event();
        event.type = EventType.CDATA;
        event.p1 = data;
        this.events.add(event);
    }

    @Override
    public void writeDTD(String dtd) {
        Event event = new Event();
        event.type = EventType.DTD;
        event.p1 = dtd;
        this.events.add(event);
    }

    @Override
    public void writeEntityRef(String name) {
        Event event = new Event();
        event.type = EventType.ENTITY_REF;
        event.p1 = name;
        this.events.add(event);
    }

    @Override
    public void writeStartDocument() {
        Event event = new Event();
        event.type = EventType.START_DOCUMENT1;
        this.events.add(event);
    }

    @Override
    public void writeStartDocument(String version) {
        Event event = new Event();
        event.type = EventType.START_DOCUMENT2;
        event.p1 = version;
        this.events.add(event);
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        Event event = new Event();
        event.type = EventType.START_DOCUMENT3;
        event.p1 = encoding;
        event.p2 = version;
        this.events.add(event);
    }

    @Override
    public void writeCharacters(String text) {
        Event event = new Event();
        event.type = EventType.CHARACTERS;
        event.p1 = text;
        this.events.add(event);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        Event event = new Event();
        event.type = EventType.CHARACTERS;
        event.p1 = new String(text, start, len);
        this.events.add(event);
    }

    @Override
    public String getPrefix(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        Event event = new Event();
        event.type = EventType.SET_PREFIX;
        event.p1 = prefix;
        event.p2 = uri;
        this.events.add(event);
    }

    @Override
    public void setDefaultNamespace(String uri) {
        Event event = new Event();
        event.type = EventType.SET_DEFAULT_NAMESPACE;
        event.p1 = uri;
        this.events.add(event);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    protected static class Event {
        EventType type;
        String p1;
        String p2;
        String p3;
        String p4;

        protected Event() {
        }
    }

    protected static enum EventType {
        START_ELEMENT1,
        START_ELEMENT2,
        START_ELEMENT3,
        EMPTY_ELEMENT1,
        EMPTY_ELEMENT2,
        EMPTY_ELEMENT3,
        END_ELEMENT,
        END_DOCUMENT,
        ATTRIBUTE1,
        ATTRIBUTE2,
        ATTRIBUTE3,
        DEFAULT_NAMESPACE,
        NAMESPACE,
        COMMENT,
        PROCESSING_INSTRUCTION1,
        PROCESSING_INSTRUCTION2,
        CDATA,
        DTD,
        ENTITY_REF,
        START_DOCUMENT1,
        START_DOCUMENT2,
        START_DOCUMENT3,
        CHARACTERS,
        SET_PREFIX,
        SET_DEFAULT_NAMESPACE;

    }
}

