/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.common.util.CaseInsensitive;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.InvocationContext;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHandler;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.common.xml.XmlEnumItemRenamer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public final class XHelper {
    static final Logger log = LoggerFactory.getLogger(XHelper.class);
    private static final Map<String, XHandler<?>> handlers = new HashMap();
    private static final XHandler<String> HANDLER_TEXT = new XHandler<String>(){

        @Override
        public String read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            return XmlUtil.getValue(elm, path);
        }

        @Override
        public Element write(Element elm, String path, String value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value, true);
            return result;
        }
    };
    private static final XHandler<Boolean> HANDLER_BOOLEAN = new XHandler<Boolean>(){

        @Override
        public Boolean read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Boolean.valueOf(value);
        }

        @Override
        public Element write(Element elm, String path, Boolean value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<Byte> HANDLER_BYTE = new XHandler<Byte>(){

        @Override
        public Byte read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Byte.valueOf(value);
        }

        @Override
        public Element write(Element elm, String path, Byte value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<byte[]> HANDLER_BYTES_ARRAY = new XHandler<byte[]>(){

        @Override
        public byte[] read(Element elm, String path) {
            return XHelper.readBytes(elm, path);
        }

        @Override
        public Element write(Element elm, String path, byte[] value) {
            return XHelper.writeBytes(elm, path, value);
        }
    };
    private static final XHandler<Character> HANDLER_CHAR = new XHandler<Character>(){

        @Override
        public Character read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (value == null || value.length() == 0) {
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public Element write(Element elm, String path, Character value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString(), true);
            return result;
        }
    };
    private static final XHandler<Short> HANDLER_SHORT = new XHandler<Short>(){

        @Override
        public Short read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Short.valueOf(value);
        }

        @Override
        public Element write(Element elm, String path, Short value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<Integer> HANDLER_INT = new XHandler<Integer>(){

        @Override
        public Integer read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Integer.valueOf(value);
        }

        @Override
        public Element write(Element elm, String path, Integer value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<Long> HANDLER_LONG = new XHandler<Long>(){

        @Override
        public Long read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Long.valueOf(value);
        }

        @Override
        public Element write(Element elm, String path, Long value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<Float> HANDLER_FLOAT = new XHandler<Float>(){

        @Override
        public Float read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Float.valueOf(value);
        }

        @Override
        public Element write(Element elm, String path, Float value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<Double> HANDLER_DOUBLE = new XHandler<Double>(){

        @Override
        public Double read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Double.valueOf(value);
        }

        @Override
        public Element write(Element elm, String path, Double value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<BigDecimal> HANDLER_BIG_DECIMAL = new XHandler<BigDecimal>(){

        @Override
        public BigDecimal read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return new BigDecimal(value);
        }

        @Override
        public Element write(Element elm, String path, BigDecimal value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toPlainString());
            return result;
        }
    };
    private static final XHandler<BigInteger> HANDLER_BIG_INTEGER = new XHandler<BigInteger>(){

        @Override
        public BigInteger read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return new BigInteger(value);
        }

        @Override
        public Element write(Element elm, String path, BigInteger value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    static final DateTimeFormatter DTF_JODA_DATE = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    static final DateTimeFormatter DTF_JODA_TIME = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
    static final DateTimeFormatter DTF_JODA_DATETIME = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    static final DateTimeFormatter DTF_JODA_DATETIME_WITH_TZ = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZZ");
    private static final XHandler<org.joda.time.LocalDate> HANDLER_JODA_LOCAL_DATE = new XHandler<org.joda.time.LocalDate>(){

        @Override
        public Element write(Element elm, String path, org.joda.time.LocalDate value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JODA_DATE.print((ReadablePartial)value));
            return result;
        }

        @Override
        public org.joda.time.LocalDate read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return (value.indexOf(32) == -1 ? DTF_JODA_DATE : DTF_JODA_DATETIME).parseLocalDate(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local date value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<LocalTime> HANDLER_JODA_LOCAL_TIME = new XHandler<LocalTime>(){

        @Override
        public Element write(Element elm, String path, LocalTime value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JODA_TIME.print((ReadablePartial)value));
            return result;
        }

        @Override
        public LocalTime read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JODA_TIME.parseLocalTime(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local time value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<org.joda.time.LocalDateTime> HANDLER_JODA_LOCAL_DATETIME = new XHandler<org.joda.time.LocalDateTime>(){

        @Override
        public Element write(Element elm, String path, org.joda.time.LocalDateTime value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JODA_DATETIME.print((ReadablePartial)value));
            return result;
        }

        @Override
        public org.joda.time.LocalDateTime read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JODA_DATETIME.parseLocalDateTime(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<DateTime> HANDLER_JODA_DATETIME = new XHandler<DateTime>(){

        @Override
        public Element write(Element elm, String path, DateTime value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JODA_DATETIME_WITH_TZ.print((ReadableInstant)value));
            return result;
        }

        @Override
        public DateTime read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JODA_DATETIME_WITH_TZ.parseDateTime(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    static final java.time.format.DateTimeFormatter DTF_JAVA_DATE = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd");
    static final java.time.format.DateTimeFormatter DTF_JAVA_TIME = java.time.format.DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    static final java.time.format.DateTimeFormatter DTF_JAVA_DATETIME = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    static final java.time.format.DateTimeFormatter DTF_JAVA_DATETIME_WITH_TZ = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZZ");
    private static final XHandler<LocalDate> HANDLER_JAVA_LOCAL_DATE = new XHandler<LocalDate>(){

        @Override
        public Element write(Element elm, String path, LocalDate value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JAVA_DATE.format(value));
            return result;
        }

        @Override
        public LocalDate read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return (value.indexOf(32) == -1 ? DTF_JAVA_DATE : DTF_JAVA_DATETIME).parse((CharSequence)value, LocalDate::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local date value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<java.time.LocalTime> HANDLER_JAVA_LOCAL_TIME = new XHandler<java.time.LocalTime>(){

        @Override
        public Element write(Element elm, String path, java.time.LocalTime value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JAVA_TIME.format(value));
            return result;
        }

        @Override
        public java.time.LocalTime read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_TIME.parse((CharSequence)value, java.time.LocalTime::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local time value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<LocalDateTime> HANDLER_JAVA_LOCAL_DATETIME = new XHandler<LocalDateTime>(){

        @Override
        public Element write(Element elm, String path, LocalDateTime value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JAVA_DATETIME.format(value));
            return result;
        }

        @Override
        public LocalDateTime read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_DATETIME.parse((CharSequence)value, LocalDateTime::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<OffsetDateTime> HANDLER_JAVA_OFFSET_DATETIME = new XHandler<OffsetDateTime>(){

        @Override
        public Element write(Element elm, String path, OffsetDateTime value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JAVA_DATETIME_WITH_TZ.format(value));
            return result;
        }

        @Override
        public OffsetDateTime read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_DATETIME_WITH_TZ.parse((CharSequence)value, OffsetDateTime::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<Instant> HANDLER_JAVA_INSTANT = new XHandler<Instant>(){

        @Override
        public Element write(Element elm, String path, Instant value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, DTF_JAVA_DATETIME.format(value));
            return result;
        }

        @Override
        public Instant read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_DATETIME.parse((CharSequence)value, Instant::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<DayOfWeek> HANDLER_JAVA_DAY_OF_WEEK = new XHandler<DayOfWeek>(){

        @Override
        public Element write(Element elm, String path, DayOfWeek value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.name());
            return result;
        }

        @Override
        public DayOfWeek read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DayOfWeek.valueOf(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XHandler<java.util.Date> HANDLER_DATE = new XHandler<java.util.Date>(){
        private final ThreadLocal<DateFormat> DATE_FORMATS = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT));
        private final ThreadLocal<DateFormat> DATETIME_FORMATS = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT));

        @Override
        public java.util.Date read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return (value.indexOf(32) == -1 ? this.DATE_FORMATS.get() : this.DATETIME_FORMATS.get()).parse(value);
            }
            catch (ParseException pe) {
                log.warn("failed reading date value " + value, (Throwable)pe);
                return null;
            }
        }

        @Override
        public Element write(Element elm, String path, java.util.Date value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, this.DATETIME_FORMATS.get().format(value));
            return result;
        }
    };
    private static final XHandler<Pair> HANDLER_PAIR = new XHandler<Pair>(){

        @Override
        public Pair read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            Element valueElm = XmlUtil.getElement(elm, path);
            Object first = XHelper.readObject(valueElm, "first");
            Object last = XHelper.readObject(valueElm, "last");
            return new Pair(first, last);
        }

        @Override
        public Element write(Element elm, String path, Pair value) {
            if (elm == null) {
                return null;
            }
            if (value == null) {
                return null;
            }
            Element valueElm = XmlUtil.addElement(elm, path);
            XHelper.writeObject(valueElm, "first", value.getFirst());
            XHelper.writeObject(valueElm, "last", value.getLast());
            return valueElm;
        }
    };
    private static final XHandler<DateInterval> HANDLER_DATE_INTERVAL = new XHandler<DateInterval>(){
        private final ThreadLocal<DateFormat> DATE_FORMATS = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT));
        private final ThreadLocal<DateFormat> DATETIME_FORMATS = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT));

        @Override
        public DateInterval read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            int index = value.indexOf("|");
            String str = value.substring(0, index);
            java.util.Date date1 = null;
            if (!TextUtil.isBlank(str)) {
                try {
                    date1 = (str.indexOf(32) == -1 ? this.DATE_FORMATS.get() : this.DATETIME_FORMATS.get()).parse(str);
                }
                catch (Throwable e) {
                    log.error("unable to parse date " + str, e);
                }
            }
            str = value.substring(index + 1);
            java.util.Date date2 = null;
            if (!TextUtil.isBlank(str)) {
                try {
                    date2 = (str.indexOf(32) == -1 ? this.DATE_FORMATS.get() : this.DATETIME_FORMATS.get()).parse(str);
                }
                catch (Throwable e) {
                    log.error("unable to parse date " + str, e);
                }
            }
            return new DateInterval(date1, date2);
        }

        @Override
        public Element write(Element elm, String path, DateInterval value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, String.format("%s|%s", value.getBeginDate() != null ? this.DATETIME_FORMATS.get().format(value.getBeginDate()) : "", value.getEndDate() != null ? this.DATETIME_FORMATS.get().format(value.getEndDate()) : ""));
            return result;
        }
    };
    private static final XHandler<Locale> HANDLER_LOCALE = new XHandler<Locale>(){

        @Override
        public Locale read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return TextUtil.str2locale(value);
        }

        @Override
        public Element write(Element elm, String path, Locale value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<URL> HANDLER_URL = new XHandler<URL>(){

        @Override
        public URL read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return new URL(value);
            }
            catch (MalformedURLException mue) {
                log.warn("failed reading URL value " + value, (Throwable)mue);
                return null;
            }
        }

        @Override
        public Element write(Element elm, String path, URL value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toExternalForm());
            return result;
        }
    };
    private static final XHandler<URI> HANDLER_URI = new XHandler<URI>(){

        @Override
        public URI read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return new URI(value);
            }
            catch (URISyntaxException use) {
                log.warn("failed reading URI value " + value, (Throwable)use);
                return null;
            }
        }

        @Override
        public Element write(Element elm, String path, URI value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<UUID> HANDLER_UUID = new XHandler<UUID>(){

        @Override
        public UUID read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            String value = XmlUtil.getValue(elm, path);
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return UUID.fromString(value);
        }

        @Override
        public Element write(Element elm, String path, UUID value) {
            if (value == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, value.toString());
            return result;
        }
    };
    private static final XHandler<NonSerializableObject> HANDLER_NON_SERIALIZABLE_OBJECT = new XHandler<NonSerializableObject>(){

        @Override
        public Element write(Element elm, String path, NonSerializableObject value) {
            if (value == null) {
                return null;
            }
            return XHelper.writeString(elm, path, value.toString(), true);
        }

        @Override
        public NonSerializableObject read(Element elm, String path) {
            return null;
        }
    };
    private static final XHandler<L10nString> HANDLER_LOCALIZATION_STRING = new XHandler<L10nString>(){

        @Override
        public L10nString read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            L10nString localizationString = new L10nString();
            localizationString.setStringValue(XHelper.readString(elm, path));
            return localizationString;
        }

        @Override
        public Element write(Element elm, String path, L10nString localizationString) {
            if (localizationString == null) {
                return null;
            }
            String stringValue = localizationString.getStringValue();
            if (stringValue == null) {
                return null;
            }
            Element result = XmlUtil.addElement(elm, path);
            XmlUtil.setValue(result, stringValue, true);
            return result;
        }
    };
    private static final XHandler<L10nMessage> HANDLER_L10N_MESSAGE = new XHandler<L10nMessage>(){

        @Override
        public L10nMessage read(Element elm, String path) {
            if (elm == null) {
                return null;
            }
            Element valueElm = XmlUtil.getElement(elm, path);
            L10nMessage l10nMessage = new L10nMessage();
            l10nMessage.setKey(XHelper.readString(valueElm, "key"));
            l10nMessage.getParameters().clear();
            for (Element item : XmlUtil.getElements(valueElm, "parameters/item")) {
                l10nMessage.getParameters().add(XHelper.readObject(item, "."));
            }
            return l10nMessage;
        }

        @Override
        public Element write(Element elm, String path, L10nMessage l10nMessage) {
            if (l10nMessage == null) {
                return null;
            }
            Element valueElm = XmlUtil.addElement(elm, path);
            XHelper.writeString(valueElm, "key", l10nMessage.getKey());
            if (l10nMessage.getParameters().size() > 0) {
                Element elem = XmlUtil.addElement(valueElm, "parameters");
                for (Object item : l10nMessage.getParameters()) {
                    XHelper.writeObject(elem, "item", item);
                }
            }
            return valueElm;
        }
    };

    public static <T> void registerHandler(Class<T> cls, XHandler<? super T> handler) {
        handlers.put(cls.getName(), handler);
        log.debug(String.format("registered handler %s for %s", handler, cls));
    }

    public static boolean isSupportedObjectType(Class<?> cls) {
        return cls.isEnum() || XSerializable.class.isAssignableFrom(cls) || handlers.containsKey(cls.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObject(Element elm, String path) {
        Class<?> cls;
        XHandler<?> handler;
        Identity result;
        Element valueElm = XmlUtil.getElement(elm, path);
        if (valueElm == null) {
            return null;
        }
        String uid = XmlUtil.getValue(valueElm, "@uid");
        if (uid == null) {
            uid = XmlUtil.getValue(valueElm, "uid");
        }
        if (uid != null && (result = InvocationContext.get("entityDeserialize").getIdentity(uid)) != null) {
            return (T)result;
        }
        String className = XmlUtil.getValue(valueElm, "@class");
        if (className == null) {
            if (uid == null) {
                log.warn("no 'class' attribute found in element " + XmlUtil.getPath(valueElm));
                return null;
            }
            Element newValueElm = XHelper.lookupElement(elm.getOwnerDocument().getDocumentElement(), uid);
            if (newValueElm == null) {
                log.warn("no 'class' attribute found in element " + XmlUtil.getPath(valueElm));
                return null;
            }
            valueElm = newValueElm;
            className = XmlUtil.getValue(valueElm, "@class");
        }
        if ((handler = handlers.get(className)) != null) {
            return (T)handler.read(elm, path);
        }
        try {
            cls = XHelper.getClass(className);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
        if (cls == null) {
            log.error(String.format("failed loading class %s for element %s", className, XmlUtil.getPath(valueElm)));
            return null;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            try {
                AbstractCollection coll = List.class.isAssignableFrom(cls) ? new ArrayList() : new HashSet();
                Element[] elementArray = XmlUtil.getElements(valueElm, "item");
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element itemElm = elementArray[n2];
                    T obj = XHelper.readObject(itemElm, ".");
                    if (obj != null) {
                        coll.add(obj);
                    }
                    ++n2;
                }
                return (T)coll;
            }
            catch (Exception e) {
                log.error(String.format("failed create a collection %s for element %s", className, XmlUtil.getPath(valueElm)), (Throwable)e);
                return null;
            }
        }
        if (Map.class.isAssignableFrom(cls) && !XSerializable.class.isAssignableFrom(cls)) {
            try {
                LinkedHashMap<T, T> coll = new LinkedHashMap<T, T>();
                Element[] elementArray = XmlUtil.getElements(valueElm, "entry");
                int n = elementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Element itemElm = elementArray[n3];
                    T key = XHelper.readObject(itemElm, "key");
                    T value = XHelper.readObject(itemElm, "value");
                    if (key != null && value != null) {
                        coll.put(key, value);
                    }
                    ++n3;
                }
                return (T)coll;
            }
            catch (Exception e) {
                log.error(String.format("failed create a map %s for element %s", className, XmlUtil.getPath(valueElm)), (Throwable)e);
                return null;
            }
        }
        if (cls.isArray()) {
            try {
                Object[] objectArray;
                Object[] array = (Object[])Array.newInstance(cls.getComponentType(), Integer.parseInt(valueElm.getAttribute("size")));
                int n = 0;
                for (Element itemElm : XmlUtil.getElements(valueElm, "item")) {
                    T obj = XHelper.readObject(itemElm, ".");
                    if (obj == null) continue;
                    array[n] = obj;
                    ++n;
                }
                if (array.length == n) {
                    objectArray = array;
                    return (T)objectArray;
                }
                objectArray = Arrays.copyOf(array, n);
                return (T)objectArray;
            }
            catch (Exception e) {
                log.error(String.format("failed deserializing array of type %s from element %s", cls.getName(), XmlUtil.getPath(valueElm)), (Throwable)e);
                return null;
            }
        }
        if (cls.isEnum()) {
            return (T)XHelper.readEnum(elm, path, cls);
        }
        if (!XSerializable.class.isAssignableFrom(cls)) throw new IllegalArgumentException("no handler found for element " + XmlUtil.getPath(valueElm));
        try {
            XSerializable result2 = (XSerializable)cls.newInstance();
            result2.fromXML(valueElm);
            return (T)result2;
        }
        catch (Exception e) {
            log.error(String.format("failed deserializing object of type %s from element %s", cls.getName(), XmlUtil.getPath(valueElm)), (Throwable)e);
            return null;
        }
    }

    private static Element lookupElement(Element elm, String uid) {
        String className = XmlUtil.getValue(elm, "@class");
        String uidValue = XmlUtil.getValue(elm, "uid");
        if (className != null && uid.equals(uidValue)) {
            return elm;
        }
        NodeList children = elm.getChildNodes();
        int c = children.getLength();
        for (int i = 0; i < c; ++i) {
            Element result;
            Node child = XmlUtil.safeGetNode(children, i);
            assert (child != null);
            if (child.getNodeType() != 1 || (result = XHelper.lookupElement((Element)child, uid)) == null) continue;
            return result;
        }
        return null;
    }

    public static Element writeObject(Element elm, String path, Object value) {
        return XHelper.writeObject(elm, path, value, false);
    }

    public static Element writeObject(Element elm, String path, Object value, boolean noDuplicate) {
        Element result;
        if (value == null) {
            return null;
        }
        Class<Object> cls = value.getClass();
        XHandler<?> handler = handlers.get(cls.getName());
        if (handler != null) {
            result = handler.write(elm, path, value);
        } else if (Collection.class.isAssignableFrom(cls)) {
            result = XmlUtil.addElement(elm, path, noDuplicate);
            for (Object item : (Collection)value) {
                XHelper.writeObject(result, "item", item, noDuplicate);
            }
        } else if (Map.class.isAssignableFrom(cls) && !XSerializable.class.isAssignableFrom(cls)) {
            result = XmlUtil.addElement(elm, path, noDuplicate);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Element itemElm = XmlUtil.addElement(result, "entry", noDuplicate);
                XHelper.writeObject(itemElm, "key", entry.getKey(), noDuplicate);
                XHelper.writeObject(itemElm, "value", entry.getValue(), noDuplicate);
            }
        } else if (value instanceof Enum) {
            result = XHelper.writeEnum(elm, path, (Enum)value);
        } else if (cls.isArray()) {
            result = XmlUtil.addElement(elm, path, noDuplicate);
            Object[] values = (Object[])value;
            result.setAttribute("size", Integer.toString(values.length));
            for (Object item : values) {
                XHelper.writeObject(result, "item", item, noDuplicate);
            }
        } else if (value instanceof Identity && InvocationContext.get("entitySerialize").getIdentity(((Identity)value).getUid()) != null) {
            result = XmlUtil.addElement(elm, path, noDuplicate);
            result.setAttribute("uid", ((Identity)value).getUid());
        } else if (value instanceof XSerializable) {
            result = XmlUtil.addElement(elm, path, noDuplicate);
            try {
                ((XSerializable)value).toXML(result);
            }
            catch (Exception e) {
                log.warn(String.format("failed serializing value %s", value));
            }
        } else if (value instanceof Throwable) {
            result = XHelper.writeObject(elm, path, new NonSerializableObject(TextUtil.getExceptionStackTrace((Throwable)value)), noDuplicate);
            cls = NonSerializableObject.class;
        } else {
            log.warn(String.format("failed serializing value %s", value));
            StringBuilder builder = new StringBuilder(value + "\n");
            try {
                ObjectTrace.trace(builder, value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result = XHelper.writeObject(elm, path, new NonSerializableObject(builder.toString()), noDuplicate);
            cls = NonSerializableObject.class;
        }
        result.setAttribute("class", value instanceof Enum ? ((Enum)value).getDeclaringClass().getName() : cls.getName());
        return result;
    }

    public static <E extends Enum<E>> E readEnum(Element elm, String path, Class<E> cls) {
        if (elm == null) {
            return null;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return null;
        }
        if (Environment.isPublished(XmlEnumItemRenamer.class)) {
            value = Environment.getPublished(XmlEnumItemRenamer.class).rename(value, cls.getName());
        }
        return EnumUtil.fromNameSafe(cls, value, log);
    }

    public static <E extends Enum<E>> E readCaseInsensitiveEnum(Element elm, String path, Class<E> cls) {
        if (elm == null) {
            return null;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return null;
        }
        if (Environment.isPublished(XmlEnumItemRenamer.class)) {
            value = Environment.getPublished(XmlEnumItemRenamer.class).rename(value, cls.getName());
        }
        return EnumUtil.fromNameSafe(cls, value, CaseInsensitive.YES, log);
    }

    public static <E extends Enum<E>> Element writeEnum(Element elm, String path, E value) {
        if (value == null) {
            return null;
        }
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, value.name());
        return result;
    }

    public static String readString(Element elm, String path) {
        return HANDLER_TEXT.read(elm, path);
    }

    public static Element writeString(Element elm, String path, String value) {
        return XHelper.writeString(elm, path, value, "");
    }

    public static Element writeString(Element elm, String path, String value, String namespace) {
        if (value == null) {
            return null;
        }
        Element result = XmlUtil.addElement(elm, path, false, namespace);
        XmlUtil.setValue(result, value);
        return result;
    }

    public static Element writeStringOrEmpty(Element elm, String path, String value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, value);
        return result;
    }

    public static Element writeStringAttribute(Element elm, String path, String value) {
        if (value == null || TextUtil.isBlank(path) || !path.contains("@") || path.indexOf("@") == path.length() - 1) {
            return null;
        }
        String attrName = path.substring(path.indexOf(64) + 1);
        Element result = XmlUtil.addElementAttribute(elm, path);
        result.setAttribute(attrName, value);
        return result;
    }

    public static Element writeStringNoDuplicate(Element elm, String path, String value) {
        if (value == null) {
            return null;
        }
        Element result = XmlUtil.addElement(elm, path, true);
        XmlUtil.setValue(result, value);
        return result;
    }

    public static Element writeString(Element elm, String path, String value, boolean asCdata) {
        return asCdata ? HANDLER_TEXT.write(elm, path, value) : XHelper.writeString(elm, path, value);
    }

    public static boolean readBoolean(Element elm, String path, boolean def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        return def;
    }

    public static Element writeBoolean(Element elm, String path, boolean value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, value ? "true" : "false");
        return result;
    }

    public static Boolean readBoolean(Element elm, String path) {
        return HANDLER_BOOLEAN.read(elm, path);
    }

    public static Element writeBoolean(Element elm, String path, Boolean value) {
        return HANDLER_BOOLEAN.write(elm, path, value);
    }

    public static byte readByte(Element elm, String path, byte def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Byte.parseByte(value);
    }

    public static Element writeByte(Element elm, String path, byte value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, Byte.toString(value));
        return result;
    }

    public static Byte readByte(Element elm, String path) {
        return HANDLER_BYTE.read(elm, path);
    }

    public static Element writeByte(Element elm, String path, Byte value) {
        return HANDLER_BYTE.write(elm, path, value);
    }

    public static char readChar(Element elm, String path, char def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if (value == null || value.length() == 0) {
            return def;
        }
        return value.charAt(0);
    }

    public static Element writeChar(Element elm, String path, char value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, Character.toString(value), true);
        return result;
    }

    public static Character readChar(Element elm, String path) {
        return HANDLER_CHAR.read(elm, path);
    }

    public static Element writeChar(Element elm, String path, Character value) {
        return HANDLER_CHAR.write(elm, path, value);
    }

    public static short readShort(Element elm, String path, short def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Short.parseShort(value);
    }

    public static Element writeShort(Element elm, String path, short value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, Short.toString(value));
        return result;
    }

    public static Short readShort(Element elm, String path) {
        return HANDLER_SHORT.read(elm, path);
    }

    public static Element writeShort(Element elm, String path, Short value) {
        return HANDLER_SHORT.write(elm, path, value);
    }

    public static int readInt(Element elm, String path, int def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public static Element writeInt(Element elm, String path, int value) {
        return XHelper.writeInt(elm, path, value, "");
    }

    public static Element writeInt(Element elm, String path, int value, String namespace) {
        Element result = XmlUtil.addElement(elm, path, false, namespace);
        XmlUtil.setValue(result, Integer.toString(value));
        return result;
    }

    public static Integer readInt(Element elm, String path) {
        return HANDLER_INT.read(elm, path);
    }

    public static Element writeInt(Element elm, String path, Integer value) {
        return HANDLER_INT.write(elm, path, value);
    }

    public static Element writeIntOrEmpty(Element elm, String path, Integer value) {
        return value == null ? XmlUtil.addElement(elm, path) : XHelper.writeInt(elm, path, value);
    }

    public static long readLong(Element elm, String path, long def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Long.parseLong(value);
    }

    public static Element writeLong(Element elm, String path, long value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, Long.toString(value));
        return result;
    }

    public static Long readLong(Element elm, String path) {
        return HANDLER_LONG.read(elm, path);
    }

    public static Element writeLong(Element elm, String path, Long value) {
        return HANDLER_LONG.write(elm, path, value);
    }

    public static float readFloat(Element elm, String path, float def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Float.parseFloat(value);
    }

    public static Element writeFloat(Element elm, String path, float value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, Float.toString(value));
        return result;
    }

    public static Float readFloat(Element elm, String path) {
        return HANDLER_FLOAT.read(elm, path);
    }

    public static Element writeFloat(Element elm, String path, Float value) {
        return HANDLER_FLOAT.write(elm, path, value);
    }

    public static double readDouble(Element elm, String path, double def) {
        if (elm == null) {
            return def;
        }
        String value = XmlUtil.getValue(elm, path);
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Double.parseDouble(value);
    }

    public static Element writeDouble(Element elm, String path, double value) {
        Element result = XmlUtil.addElement(elm, path);
        XmlUtil.setValue(result, Double.toString(value));
        return result;
    }

    public static Double readDouble(Element elm, String path) {
        return HANDLER_DOUBLE.read(elm, path);
    }

    public static Element writeDouble(Element elm, String path, Double value) {
        return HANDLER_DOUBLE.write(elm, path, value);
    }

    public static BigDecimal readBigDecimal(Element elm, String path) {
        return HANDLER_BIG_DECIMAL.read(elm, path);
    }

    public static Element writeBigDecimal(Element elm, String path, BigDecimal value) {
        return HANDLER_BIG_DECIMAL.write(elm, path, value);
    }

    public static BigInteger readBigInteger(Element elm, String path) {
        return HANDLER_BIG_INTEGER.read(elm, path);
    }

    public static Element writeBigInteger(Element elm, String path, BigInteger value) {
        return HANDLER_BIG_INTEGER.write(elm, path, value);
    }

    public static java.util.Date readDate(Element elm, String path) {
        return HANDLER_DATE.read(elm, path);
    }

    public static Element writeDate(Element elm, String path, java.util.Date value) {
        return HANDLER_DATE.write(elm, path, value);
    }

    public static org.joda.time.LocalDate readJodaLocalDate(Element elm, String path) {
        return HANDLER_JODA_LOCAL_DATE.read(elm, path);
    }

    public static Element writeJodaLocalDate(Element elm, String path, org.joda.time.LocalDate value) {
        return HANDLER_JODA_LOCAL_DATE.write(elm, path, value);
    }

    public static LocalTime readJodaLocalTime(Element elm, String path) {
        return HANDLER_JODA_LOCAL_TIME.read(elm, path);
    }

    public static Element writeJodaLocalTime(Element elm, String path, LocalTime value) {
        return HANDLER_JODA_LOCAL_TIME.write(elm, path, value);
    }

    public static org.joda.time.LocalDateTime readJodaLocalDateTime(Element elm, String path) {
        return HANDLER_JODA_LOCAL_DATETIME.read(elm, path);
    }

    public static Element writeJodaLocalDateTime(Element elm, String path, org.joda.time.LocalDateTime value) {
        return HANDLER_JODA_LOCAL_DATETIME.write(elm, path, value);
    }

    public static DateTime readJodaDateTime(Element elm, String path) {
        return HANDLER_JODA_DATETIME.read(elm, path);
    }

    public static Element writeJodaDateTime(Element elm, String path, DateTime value) {
        return HANDLER_JODA_DATETIME.write(elm, path, value);
    }

    public static LocalDate readJavaLocalDate(Element elm, String path) {
        return HANDLER_JAVA_LOCAL_DATE.read(elm, path);
    }

    public static Element writeJavaLocalDate(Element elm, String path, LocalDate value) {
        return HANDLER_JAVA_LOCAL_DATE.write(elm, path, value);
    }

    public static java.time.LocalTime readJavaLocalTime(Element elm, String path) {
        return HANDLER_JAVA_LOCAL_TIME.read(elm, path);
    }

    public static Element writeJavaLocalTime(Element elm, String path, java.time.LocalTime value) {
        return HANDLER_JAVA_LOCAL_TIME.write(elm, path, value);
    }

    public static LocalDateTime readJavaLocalDateTime(Element elm, String path) {
        return HANDLER_JAVA_LOCAL_DATETIME.read(elm, path);
    }

    public static Element writeJavaLocalDateTime(Element elm, String path, LocalDateTime value) {
        return HANDLER_JAVA_LOCAL_DATETIME.write(elm, path, value);
    }

    public static OffsetDateTime readJavaOffsetDateTime(Element elm, String path) {
        return HANDLER_JAVA_OFFSET_DATETIME.read(elm, path);
    }

    public static Element writeOffsetDateTime(Element elm, String path, OffsetDateTime value) {
        return HANDLER_JAVA_OFFSET_DATETIME.write(elm, path, value);
    }

    public static Instant readJavaInstant(Element elm, String path) {
        return HANDLER_JAVA_INSTANT.read(elm, path);
    }

    public static DayOfWeek readJavaDayOfWeek(Element elm, String path) {
        return HANDLER_JAVA_DAY_OF_WEEK.read(elm, path);
    }

    public static Element writeJavaInstant(Element elm, String path, Instant value) {
        return HANDLER_JAVA_INSTANT.write(elm, path, value);
    }

    public static Element writeJavaDayOfWeek(Element elm, String path, DayOfWeek value) {
        return HANDLER_JAVA_DAY_OF_WEEK.write(elm, path, value);
    }

    public static Locale readLocale(Element elm, String path) {
        return HANDLER_LOCALE.read(elm, path);
    }

    public static Element writeLocale(Element elm, String path, Locale value) {
        return HANDLER_LOCALE.write(elm, path, value);
    }

    public static URL readURL(Element elm, String path) {
        return HANDLER_URL.read(elm, path);
    }

    public static Element writeURL(Element elm, String path, URL value) {
        return HANDLER_URL.write(elm, path, value);
    }

    public static URI readURI(Element elm, String path) {
        return HANDLER_URI.read(elm, path);
    }

    public static Element writeURI(Element elm, String path, URI value) {
        return HANDLER_URI.write(elm, path, value);
    }

    public static UUID readUUID(Element elm, String path) {
        return HANDLER_UUID.read(elm, path);
    }

    public static Element writeUUID(Element elm, String path, UUID value) {
        return HANDLER_UUID.write(elm, path, value);
    }

    public static L10nString readLocalizationString(Element elm, String path) {
        return HANDLER_LOCALIZATION_STRING.read(elm, path);
    }

    public static Element writeLocalizationString(Element elm, String path, L10nString value) {
        return HANDLER_LOCALIZATION_STRING.write(elm, path, value);
    }

    /*
     * Exception decompiling
     */
    public static byte[] readBytes(Element elm, String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Element writeBytes(Element elm, String path, byte[] value) {
        return XHelper.writeBytes(elm, path, value, "base64");
    }

    public static Element writeBytes(Element elm, String path, byte[] value, String format) {
        if (value == null) {
            return null;
        }
        if (value.length == 0) {
            return XHelper.writeString(elm, path, "", false);
        }
        try {
            Element result;
            if ("binhex".equalsIgnoreCase(format)) {
                result = XHelper.writeString(elm, path, BinHex.encode(value), false);
                result.setAttribute("format", "binhex");
            } else if ("base64".equalsIgnoreCase(format)) {
                result = XHelper.writeString(elm, path, Base64.encode(value), true);
                result.setAttribute("format", "base64");
            } else if ("base64compressed".equalsIgnoreCase(format)) {
                result = XHelper.writeString(elm, path, Base64.encode(GZIPUtil.gzip(value)), true);
                result.setAttribute("format", "base64compressed");
            } else {
                log.warn(String.format("unknown binary format %s specified for %s", format, path));
                result = null;
            }
            return result;
        }
        catch (IOException ioe) {
            log.warn("failed writing binary value for " + path, (Throwable)ioe);
            return null;
        }
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return XSHelper.getClass(className);
    }

    public static <E> Class<E> getClassForName(String className) throws ClassNotFoundException {
        return XSHelper.getClass(className);
    }

    public static <T> T getInstance(String className, Object ... parameters) {
        try {
            if (parameters == null || parameters.length == 0) {
                return (T)XSHelper.getClass(className).newInstance();
            }
            Class[] classes = new Class[parameters.length];
            for (int n = 0; n < parameters.length; ++n) {
                classes[n] = parameters[n].getClass();
            }
            return (T)XSHelper.getClass(className).getDeclaredConstructor(classes).newInstance(parameters);
        }
        catch (Exception e) {
            log.error("unable to create instance of " + className, (Throwable)e);
            throw new RuntimeException("unable to create instance of " + className, e);
        }
    }

    private XHelper() {
    }

    public static <T extends XSerializable> void addListElements(Element elm, String tag, List<T> list, Class<T> clazz) {
        NodeList nodes = elm.getElementsByTagName(tag);
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                Constructor<?>[] ctors = clazz.getDeclaredConstructors();
                if (ctors.length == 0) continue;
                Constructor<?> ctor = null;
                for (Constructor<?> c : ctors) {
                    if (c.getParameterTypes().length != 0) continue;
                    ctor = c;
                    break;
                }
                if (ctor == null) continue;
                ctor.setAccessible(true);
                XSerializable obj = (XSerializable)ctor.newInstance(new Object[0]);
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    obj.fromXML((Element)node);
                }
                list.add(obj);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T extends XSerializable> T addOneElement(Element elm, String tag, Class<T> clazz) {
        XSerializable res = null;
        NodeList nodes = elm.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            try {
                Constructor<?>[] ctors = clazz.getDeclaredConstructors();
                if (ctors.length == 0) {
                    return null;
                }
                Constructor<?> ctor = null;
                for (Constructor<?> c : ctors) {
                    if (c.getParameterTypes().length != 0) continue;
                    ctor = c;
                    break;
                }
                if (ctor != null) {
                    ctor.setAccessible(true);
                    XSerializable obj = (XSerializable)ctor.newInstance(new Object[0]);
                    Node node = nodes.item(0);
                    if (node instanceof Element) {
                        obj.fromXML((Element)node);
                    }
                    res = obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)res;
    }

    public static void writeElement(Element elm, String path, XSerializable obj) throws Exception {
        if (obj == null) {
            return;
        }
        Element elm2 = elm.getOwnerDocument().createElement("TEMP_ROOT");
        try {
            obj.toXML(elm2);
            elm2 = XUtil.removeRootNode(elm2);
            XmlUtil.addElement(elm, elm2, path, false);
        }
        catch (Exception e) {
            log.error("failed toXML() for object at path: " + path);
            throw e;
        }
    }

    public static void writeElements(Element elm, String path, List<? extends XSerializable> objects) throws Exception {
        try {
            int i = 0;
            for (XSerializable xSerializable : objects) {
                Element elm2 = elm.getOwnerDocument().createElement("TEMP_ROOT");
                xSerializable.toXML(elm2);
                elm2 = XUtil.removeRootNode(elm2);
                XmlUtil.addElement(elm, elm2, path, i == 0);
                ++i;
            }
        }
        catch (Exception e) {
            log.error("failed toXML() for object at path: " + path);
            throw e;
        }
    }

    public static <K, V> Element writeMap(Element elm, String path, Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Element entryElement = XmlUtil.addElement(elm, path);
            XHelper.writeObject(entryElement, "key", entry.getKey());
            XHelper.writeObject(entryElement, "value", entry.getValue());
        }
        Element firstElm = XmlUtil.getElement(elm, path);
        return firstElm != null ? (Element)firstElm.getParentNode() : null;
    }

    public static <K, V> Map<K, V> readMap(Element elm, String path) {
        HashMap result = new HashMap();
        XHelper.fillMap(elm, path, result);
        return result;
    }

    public static <K, V> void fillMap(Element elm, String path, Map<K, V> map) {
        for (Element itemElm : XmlUtil.getElements(elm, path)) {
            map.put(XHelper.readObject(itemElm, "key"), XHelper.readObject(itemElm, "value"));
        }
    }

    public static <E> Element writeCollection(Element elm, String path, Collection<E> collection) {
        return XHelper.writeObject(elm, path, collection);
    }

    public static <E> Collection<E> readCollection(Element elm, String path) {
        List result = (List)XHelper.readObject(elm, path);
        return result != null ? result : Collections.emptyList();
    }

    static {
        XHelper.registerHandler(String.class, HANDLER_TEXT);
        XHelper.registerHandler(Boolean.class, HANDLER_BOOLEAN);
        XHelper.registerHandler(Byte.class, HANDLER_BYTE);
        XHelper.registerHandler(Character.class, HANDLER_CHAR);
        XHelper.registerHandler(byte[].class, HANDLER_BYTES_ARRAY);
        XHelper.registerHandler(Short.class, HANDLER_SHORT);
        XHelper.registerHandler(Integer.class, HANDLER_INT);
        XHelper.registerHandler(Long.class, HANDLER_LONG);
        XHelper.registerHandler(Float.class, HANDLER_FLOAT);
        XHelper.registerHandler(Double.class, HANDLER_DOUBLE);
        XHelper.registerHandler(BigDecimal.class, HANDLER_BIG_DECIMAL);
        XHelper.registerHandler(BigInteger.class, HANDLER_BIG_INTEGER);
        XHelper.registerHandler(java.util.Date.class, HANDLER_DATE);
        XHelper.registerHandler(Locale.class, HANDLER_LOCALE);
        XHelper.registerHandler(URL.class, HANDLER_URL);
        XHelper.registerHandler(URI.class, HANDLER_URI);
        XHelper.registerHandler(UUID.class, HANDLER_UUID);
        XHelper.registerHandler(Pair.class, HANDLER_PAIR);
        XHelper.registerHandler(DateInterval.class, HANDLER_DATE_INTERVAL);
        XHelper.registerHandler(L10nMessage.class, HANDLER_L10N_MESSAGE);
        XHelper.registerHandler(L10nString.class, HANDLER_LOCALIZATION_STRING);
        XHelper.registerHandler(NonSerializableObject.class, HANDLER_NON_SERIALIZABLE_OBJECT);
        XHelper.registerHandler(Date.class, HANDLER_DATE);
        XHelper.registerHandler(Time.class, HANDLER_DATE);
        XHelper.registerHandler(Timestamp.class, HANDLER_DATE);
        XHelper.registerHandler(java.time.LocalTime.class, HANDLER_JAVA_LOCAL_TIME);
        XHelper.registerHandler(LocalDate.class, HANDLER_JAVA_LOCAL_DATE);
        XHelper.registerHandler(LocalDateTime.class, HANDLER_JAVA_LOCAL_DATETIME);
    }

    static class NonSerializableObject
    implements XCloneable {
        private final String value;

        public NonSerializableObject(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value != null ? this.value : "null";
        }

        @Override
        public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
            return new NonSerializableObject(this.value);
        }
    }
}

