/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.InvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XmlHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DOMFallbackException;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XMLObjectWatcher;
import com.gridnine.xtrip.common.xml.XSHandler;
import com.gridnine.xtrip.common.xml.XmlEnumItemRenamer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class XSHelper {
    static final Logger log = LoggerFactory.getLogger(XSHelper.class);
    private static final Map<String, Class<?>> clsCache = new ConcurrentHashMap();
    private static final XSHandler<String> HANDLER_TEXT = new XSHandler<String>(){

        @Override
        public String read(XMLStreamReader reader) throws Exception {
            String data = reader.getAttributeValue(null, "g9-escaped");
            String value = reader.getElementText();
            if (MiscUtil.isTrue(data)) {
                value = XmlHelper.unescapeString(value);
            }
            return value;
        }

        @Override
        public void write(XMLStreamWriter writer, String name, String value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            if (!TextUtil.isBlank(value, false)) {
                String _value = value;
                if (XmlHelper.containsInvalidCharacters(_value)) {
                    _value = XmlHelper.escapeString(_value);
                    writer.writeAttribute("g9-escaped", Boolean.toString(true));
                }
                writer.writeCData(_value);
            }
            writer.writeEndElement();
        }
    };
    private static final XSHandler<BigInteger> HANDLER_BIG_INTEGER = new XSHandler<BigInteger>(){

        @Override
        public BigInteger read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return new BigInteger(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, BigInteger value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<BigDecimal> HANDLER_BIG_DECIMAL = new XSHandler<BigDecimal>(){

        @Override
        public BigDecimal read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return new BigDecimal(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, BigDecimal value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toPlainString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Boolean> HANDLER_BOOLEAN = new XSHandler<Boolean>(){

        @Override
        public Boolean read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Boolean.valueOf(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Boolean value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Byte> HANDLER_BYTE = new XSHandler<Byte>(){

        @Override
        public Byte read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Byte.valueOf(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Byte value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<byte[]> HANDLER_BYTES_ARRAY = new XSHandler<byte[]>(){

        @Override
        public byte[] read(XMLStreamReader reader) throws Exception {
            return XSHelper.readBytes(reader);
        }

        @Override
        public void write(XMLStreamWriter writer, String name, byte[] value, Map<String, String> attributes) throws Exception {
            XSHelper.writeBytes(writer, name, value, attributes);
        }
    };
    private static final XSHandler<Character> HANDLER_CHAR = new XSHandler<Character>(){

        @Override
        public Character read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Character.valueOf(value.trim().charAt(0));
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Character value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCData(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Integer> HANDLER_INT = new XSHandler<Integer>(){

        @Override
        public Integer read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Integer.valueOf(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Integer value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Short> HANDLER_SHORT = new XSHandler<Short>(){

        @Override
        public Short read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Short.valueOf(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Short value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Locale> HANDLER_LOCALE = new XSHandler<Locale>(){

        @Override
        public Locale read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return TextUtil.str2locale(value);
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Locale value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Float> HANDLER_FLOAT = new XSHandler<Float>(){

        @Override
        public Float read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Float.valueOf(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Float value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Double> HANDLER_DOUBLE = new XSHandler<Double>(){

        @Override
        public Double read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Double.valueOf(value.trim());
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Double value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<URL> HANDLER_URL = new XSHandler<URL>(){

        @Override
        public URL read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return new URL(value.trim());
            }
            catch (MalformedURLException mue) {
                log.warn("failed reading URL value " + value, (Throwable)mue);
                return null;
            }
        }

        @Override
        public void write(XMLStreamWriter writer, String name, URL value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toExternalForm());
            writer.writeEndElement();
        }
    };
    static final DateTimeFormatter DTF_JODA_DATETIME = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    static final DateTimeFormatter DTF_JODA_DATE = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    static final DateTimeFormatter DTF_JODA_TIME = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
    static final DateTimeFormatter DTF_JODA_DATETIME_WITH_TZ = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZZ");
    private static final XSHandler<DateTime> HANDLER_JODA_DATETIME = new XSHandler<DateTime>(){

        @Override
        public void write(XMLStreamWriter writer, String name, DateTime value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JODA_DATETIME_WITH_TZ.print((ReadableInstant)value));
            writer.writeEndElement();
        }

        @Override
        public DateTime read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JODA_DATETIME_WITH_TZ.parseDateTime(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<LocalTime> HANDLER_JODA_LOCAL_TIME = new XSHandler<LocalTime>(){

        @Override
        public void write(XMLStreamWriter writer, String name, LocalTime value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JODA_TIME.print((ReadablePartial)value));
            writer.writeEndElement();
        }

        @Override
        public LocalTime read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JODA_TIME.parseLocalTime(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local time value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<org.joda.time.LocalDate> HANDLER_JODA_LOCAL_DATE = new XSHandler<org.joda.time.LocalDate>(){

        @Override
        public void write(XMLStreamWriter writer, String name, org.joda.time.LocalDate value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JODA_DATE.print((ReadablePartial)value));
            writer.writeEndElement();
        }

        @Override
        public org.joda.time.LocalDate read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return (value.indexOf(32) == -1 ? DTF_JODA_DATE : DTF_JODA_DATETIME).parseLocalDate(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local date value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<org.joda.time.LocalDateTime> HANDLER_JODA_LOCAL_DATETIME = new XSHandler<org.joda.time.LocalDateTime>(){

        @Override
        public void write(XMLStreamWriter writer, String name, org.joda.time.LocalDateTime value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JODA_DATETIME.print((ReadablePartial)value));
            writer.writeEndElement();
        }

        @Override
        public org.joda.time.LocalDateTime read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JODA_DATETIME.parseLocalDateTime(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    static final java.time.format.DateTimeFormatter DTF_JAVA_DATETIME = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    static final java.time.format.DateTimeFormatter DTF_JAVA_DATE = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd");
    static final java.time.format.DateTimeFormatter DTF_JAVA_TIME = java.time.format.DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    static final java.time.format.DateTimeFormatter DTF_JAVA_DATETIME_WITH_TZ = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZZ");
    private static final XSHandler<OffsetDateTime> HANDLER_JAVA_OFFSET_DATETIME = new XSHandler<OffsetDateTime>(){

        @Override
        public void write(XMLStreamWriter writer, String name, OffsetDateTime value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JAVA_DATETIME_WITH_TZ.format(value));
            writer.writeEndElement();
        }

        @Override
        public OffsetDateTime read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_DATETIME_WITH_TZ.parse((CharSequence)value, OffsetDateTime::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<Instant> HANDLER_JAVA_INSTANT = new XSHandler<Instant>(){

        @Override
        public void write(XMLStreamWriter writer, String name, Instant value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JAVA_DATETIME.format(value));
            writer.writeEndElement();
        }

        @Override
        public Instant read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_DATETIME.parse((CharSequence)value, Instant::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<DayOfWeek> HANDLER_JAVA_DAY_OF_WEEK = new XSHandler<DayOfWeek>(){

        @Override
        public void write(XMLStreamWriter writer, String name, DayOfWeek value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.name());
            writer.writeEndElement();
        }

        @Override
        public DayOfWeek read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DayOfWeek.valueOf(value);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<java.time.LocalTime> HANDLER_JAVA_LOCAL_TIME = new XSHandler<java.time.LocalTime>(){

        @Override
        public void write(XMLStreamWriter writer, String name, java.time.LocalTime value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JAVA_TIME.format(value));
            writer.writeEndElement();
        }

        @Override
        public java.time.LocalTime read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_TIME.parse((CharSequence)value, java.time.LocalTime::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local time value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<LocalDate> HANDLER_JAVA_LOCAL_DATE = new XSHandler<LocalDate>(){

        @Override
        public void write(XMLStreamWriter writer, String name, LocalDate value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JAVA_DATE.format(value));
            writer.writeEndElement();
        }

        @Override
        public LocalDate read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return (value.indexOf(32) == -1 ? DTF_JAVA_DATE : DTF_JAVA_DATETIME).parse((CharSequence)value, LocalDate::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local date value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<LocalDateTime> HANDLER_JAVA_LOCAL_DATETIME = new XSHandler<LocalDateTime>(){

        @Override
        public void write(XMLStreamWriter writer, String name, LocalDateTime value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(DTF_JAVA_DATETIME.format(value));
            writer.writeEndElement();
        }

        @Override
        public LocalDateTime read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return DTF_JAVA_DATETIME.parse((CharSequence)value, LocalDateTime::from);
            }
            catch (IllegalArgumentException iae) {
                log.warn("failed reading local datetime value " + value, (Throwable)iae);
                return null;
            }
        }
    };
    private static final XSHandler<URI> HANDLER_URI = new XSHandler<URI>(){

        @Override
        public URI read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return new URI(value);
            }
            catch (URISyntaxException use) {
                log.warn("failed reading URI value " + value, (Throwable)use);
                return null;
            }
        }

        @Override
        public void write(XMLStreamWriter writer, String name, URI value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<UUID> HANDLER_UUID = new XSHandler<UUID>(){

        @Override
        public UUID read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return UUID.fromString(value);
        }

        @Override
        public void write(XMLStreamWriter writer, String name, UUID value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Pair> HANDLER_PAIR = new XSHandler<Pair>(){

        @Override
        public Pair read(XMLStreamReader reader) throws Exception {
            Object first = null;
            Object last = null;
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("first".equals(tagName)) {
                    first = XSHelper.readObject(reader);
                    continue;
                }
                if ("last".equals(tagName)) {
                    last = XSHelper.readObject(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return new Pair<Object>(first, last);
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Pair value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            XSHelper.writeObject(writer, "first", value.getFirst(), attributes);
            XSHelper.writeObject(writer, "last", value.getLast(), attributes);
            writer.writeEndElement();
        }
    };
    private static final XSHandler<DateInterval> HANDLER_DATE_INTERVAL = new XSHandler<DateInterval>(){
        private final ThreadLocal<DateFormat> DATE_FORMATS = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
            }
        };
        private final ThreadLocal<DateFormat> DATETIME_FORMATS = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);
            }
        };

        @Override
        public DateInterval read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            int index = value.indexOf("|");
            String str = value.substring(0, index);
            java.util.Date date1 = null;
            if (!TextUtil.isBlank(str)) {
                try {
                    date1 = (str.indexOf(32) == -1 ? this.DATE_FORMATS.get() : this.DATETIME_FORMATS.get()).parse(str);
                }
                catch (Throwable e) {
                    log.error("unable to parse date " + str, e);
                }
            }
            str = value.substring(index + 1);
            java.util.Date date2 = null;
            if (!TextUtil.isBlank(str)) {
                try {
                    date2 = (str.indexOf(32) == -1 ? this.DATE_FORMATS.get() : this.DATETIME_FORMATS.get()).parse(str);
                }
                catch (Throwable e) {
                    log.error("unable to parse date " + str, e);
                }
            }
            return new DateInterval(date1, date2);
        }

        @Override
        public void write(XMLStreamWriter writer, String name, DateInterval value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(String.format("%s|%s", value.getBeginDate() != null ? this.DATETIME_FORMATS.get().format(value.getBeginDate()) : "", value.getEndDate() != null ? this.DATETIME_FORMATS.get().format(value.getEndDate()) : ""));
            writer.writeEndElement();
        }
    };
    private static final XSHandler<L10nMessage> HANDLER_L10N_MESSAGE = new XSHandler<L10nMessage>(){

        @Override
        public L10nMessage read(XMLStreamReader reader) throws Exception {
            L10nMessage l10nMessage = new L10nMessage();
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("key".equals(tagName)) {
                    l10nMessage.setKey(XSHelper.readString(reader));
                    continue;
                }
                if ("parameters".equals(tagName)) {
                    while (reader.nextTag() != 2) {
                        if ("item".equals(reader.getName().getLocalPart())) {
                            l10nMessage.getParameters().add(XSHelper.readObject(reader));
                            continue;
                        }
                        XSHelper.skipElement(reader);
                    }
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return l10nMessage;
        }

        @Override
        public void write(XMLStreamWriter writer, String name, L10nMessage value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            XSHelper.writeString(writer, "key", value.getKey());
            if (!value.getParameters().isEmpty()) {
                writer.writeStartElement("parameters");
                for (Object item : value.getParameters()) {
                    XSHelper.writeObject(writer, "item", item);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    };
    private static final XSHandler<XHelper.NonSerializableObject> HANDLER_NON_SERIALIZABLE_OBJECT = new XSHandler<XHelper.NonSerializableObject>(){

        @Override
        public void write(XMLStreamWriter writer, String name, XHelper.NonSerializableObject value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            XSHelper.writeString(writer, name, value.toString(), true, attributes);
        }

        @Override
        public XHelper.NonSerializableObject read(XMLStreamReader reader) throws Exception {
            return null;
        }
    };
    private static final XSHandler<L10nString> HANDLER_LOCALIZATION_STRING = new XSHandler<L10nString>(){

        @Override
        public L10nString read(XMLStreamReader reader) throws Exception {
            L10nString localizationString = new L10nString();
            localizationString.setStringValue(XSHelper.readString(reader));
            return localizationString;
        }

        @Override
        public void write(XMLStreamWriter writer, String name, L10nString value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            String stringValue = value.getStringValue();
            if (stringValue == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            if (!TextUtil.isBlank(stringValue, false)) {
                writer.writeCData(stringValue);
            }
            writer.writeEndElement();
        }
    };
    private static final XSHandler<Long> HANDLER_LONG = new XSHandler<Long>(){

        @Override
        public Long read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            return Long.valueOf(value);
        }

        @Override
        public void write(XMLStreamWriter writer, String name, Long value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    };
    private static final XSHandler<java.util.Date> HANDLER_DATE = new XSHandler<java.util.Date>(){
        private final ThreadLocal<DateFormat> DATE_FORMATS = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
            }
        };
        private final ThreadLocal<DateFormat> DATETIME_FORMATS = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);
            }
        };

        @Override
        public java.util.Date read(XMLStreamReader reader) throws Exception {
            String value = reader.getElementText();
            if (TextUtil.isBlank(value)) {
                return null;
            }
            try {
                return (value.indexOf(32) == -1 ? this.DATE_FORMATS.get() : this.DATETIME_FORMATS.get()).parse(value);
            }
            catch (ParseException pe) {
                log.warn("failed reading date value " + value, (Throwable)pe);
                return null;
            }
        }

        @Override
        public void write(XMLStreamWriter writer, String name, java.util.Date value, Map<String, String> attributes) throws Exception {
            if (value == null) {
                return;
            }
            writer.writeStartElement(name);
            XSHelper.writeAttributes(writer, attributes);
            writer.writeCharacters(this.DATETIME_FORMATS.get().format(value));
            writer.writeEndElement();
        }
    };
    private static final XSHandler<XMLGregorianCalendar> HANDLER_XML_GREGORIAN_CALENDAR = new XSHandler<XMLGregorianCalendar>(){

        @Override
        public XMLGregorianCalendar read(XMLStreamReader reader) throws Exception {
            return MiscUtil.toXmlDateTimeSafe((java.util.Date)HANDLER_DATE.read(reader));
        }

        @Override
        public void write(XMLStreamWriter writer, String name, XMLGregorianCalendar value, Map<String, String> attributes) throws Exception {
            if (value != null) {
                HANDLER_DATE.write(writer, name, value.toGregorianCalendar().getTime(), attributes);
            }
        }
    };
    private static final Map<String, XSHandler<?>> handlers = new HashMap();

    public static String readString(XMLStreamReader reader) throws Exception {
        return HANDLER_TEXT.read(reader);
    }

    public static L10nString readLocalizationString(XMLStreamReader reader) throws Exception {
        return HANDLER_LOCALIZATION_STRING.read(reader);
    }

    public static void writeString(XMLStreamWriter writer, String name, String value) throws Exception {
        XSHelper.writeString(writer, name, value, null);
    }

    public static void writeAttributes(XMLStreamWriter writer, Map<String, String> attributes) throws Exception {
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                writer.writeAttribute(entry.getKey(), entry.getValue() != null ? entry.getValue() : "");
            }
        }
    }

    public static void writeString(XMLStreamWriter writer, String name, String value, Map<String, String> attributes) throws Exception {
        if (value == null) {
            return;
        }
        writer.writeStartElement(name);
        XSHelper.writeAttributes(writer, attributes);
        if (!TextUtil.isBlank(value, false)) {
            String _value = value;
            if (XmlHelper.containsInvalidCharacters(_value)) {
                _value = XmlHelper.escapeString(_value);
                writer.writeAttribute("g9-escaped", Boolean.toString(true));
            }
            writer.writeCharacters(_value);
        }
        writer.writeEndElement();
    }

    public static void writeString(XMLStreamWriter writer, String name, String value, boolean asCdata) throws Exception {
        XSHelper.writeString(writer, name, value, asCdata, null);
    }

    static void writeString(XMLStreamWriter writer, String name, String value, boolean asCdata, Map<String, String> attributes) throws Exception {
        if (asCdata) {
            HANDLER_TEXT.write(writer, name, value, attributes);
        } else {
            XSHelper.writeString(writer, name, value, attributes);
        }
    }

    public static java.util.Date readDate(XMLStreamReader reader) throws Exception {
        return HANDLER_DATE.read(reader);
    }

    public static LocalDate readJavaLocalDate(XMLStreamReader reader) throws Exception {
        return HANDLER_JAVA_LOCAL_DATE.read(reader);
    }

    public static void writeDate(XMLStreamWriter writer, String name, java.util.Date value) throws Exception {
        HANDLER_DATE.write(writer, name, value, null);
    }

    public static XMLGregorianCalendar readXMLGregorianCalendar(XMLStreamReader reader) throws Exception {
        return HANDLER_XML_GREGORIAN_CALENDAR.read(reader);
    }

    public static void writeXMLGregorianCalendar(XMLStreamWriter writer, String name, XMLGregorianCalendar value) throws Exception {
        HANDLER_XML_GREGORIAN_CALENDAR.write(writer, name, value, null);
    }

    public static Long readLong(XMLStreamReader reader) throws Exception {
        return HANDLER_LONG.read(reader);
    }

    public static long readLong(XMLStreamReader reader, long def) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Long.parseLong(value);
    }

    public static void writeLong(XMLStreamWriter writer, String name, Long value) throws Exception {
        HANDLER_LONG.write(writer, name, value, null);
    }

    public static void writeLong(XMLStreamWriter writer, String name, long value) throws Exception {
        writer.writeStartElement(name);
        writer.writeCharacters(Long.toString(value));
        writer.writeEndElement();
    }

    public static int readInt(XMLStreamReader reader, int def) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public static Integer readInteger(XMLStreamReader reader) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public static short readShort(XMLStreamReader reader, short def) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Short.parseShort(value);
    }

    public static Short readShort(XMLStreamReader reader) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return null;
        }
        return Short.valueOf(value);
    }

    public static boolean readBoolean(XMLStreamReader reader, boolean def) throws Exception {
        String value = reader.getElementText();
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        return def;
    }

    public static Boolean readBoolean(XMLStreamReader reader) throws Exception {
        return HANDLER_BOOLEAN.read(reader);
    }

    public static void writeInt(XMLStreamWriter writer, String name, int value) throws Exception {
        writer.writeStartElement(name);
        writer.writeCharacters(Integer.toString(value));
        writer.writeEndElement();
    }

    public static void writeInt(XMLStreamWriter writer, String name, Integer value) throws Exception {
        HANDLER_INT.write(writer, name, value, null);
    }

    public static <E extends Enum<E>> E readEnum(XMLStreamReader reader, Class<E> cls) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return null;
        }
        if (Environment.isPublished(XmlEnumItemRenamer.class)) {
            value = Environment.getPublished(XmlEnumItemRenamer.class).rename(value, cls.getName());
        }
        return EnumUtil.fromNameSafe(cls, value, log);
    }

    public static <E extends Enum<E>> void writeEnum(XMLStreamWriter writer, String name, E value) throws Exception {
        XSHelper.writeEnum(writer, name, value, null);
    }

    public static <E extends Enum<E>> void writeEnum(XMLStreamWriter writer, String name, E value, Map<String, String> attributes) throws Exception {
        if (value == null) {
            return;
        }
        writer.writeStartElement(name);
        XSHelper.writeAttributes(writer, attributes);
        writer.writeCharacters(value.name());
        writer.writeEndElement();
    }

    public static void writeShort(XMLStreamWriter writer, String name, short value) throws Exception {
        writer.writeStartElement(name);
        writer.writeCharacters(Short.toString(value));
        writer.writeEndElement();
    }

    public static void writeShort(XMLStreamWriter writer, String name, Short value) throws Exception {
        if (value == null) {
            return;
        }
        writer.writeStartElement(name);
        writer.writeCharacters(Short.toString(value));
        writer.writeEndElement();
    }

    public static byte readByte(XMLStreamReader reader, byte def) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Byte.parseByte(value);
    }

    public static Byte readByte(XMLStreamReader reader) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return null;
        }
        return Byte.parseByte(value);
    }

    public static void skipElement(XMLStreamReader reader) throws Exception {
        int count = 0;
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 2: {
                    if (count == 0) {
                        return;
                    }
                    --count;
                    continue block5;
                }
                case 1: {
                    ++count;
                    continue block5;
                }
            }
        }
    }

    public static BigDecimal readBigDecimal(XMLStreamReader reader) throws Exception {
        return HANDLER_BIG_DECIMAL.read(reader);
    }

    public static void writeBigDecimal(XMLStreamWriter writer, String name, BigDecimal value) throws Exception {
        HANDLER_BIG_DECIMAL.write(writer, name, value, null);
    }

    public static byte[] readBytes(XMLStreamReader reader) throws Exception {
        String format = reader.getAttributeValue(null, "format");
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return new byte[0];
        }
        if ("binhex".equalsIgnoreCase(format)) {
            try {
                return BinHex.decode(value);
            }
            catch (IOException ioe) {
                log.warn("failed reading binary value " + value, (Throwable)ioe);
                return new byte[0];
            }
        }
        if ("base64".equalsIgnoreCase(format)) {
            try {
                return Base64.decode(value);
            }
            catch (IOException ioe) {
                log.warn("failed reading binary value " + value, (Throwable)ioe);
                return new byte[0];
            }
        }
        if ("base64compressed".equalsIgnoreCase(format)) {
            try {
                return GZIPUtil.gunzip(Base64.decode(value));
            }
            catch (IOException ioe) {
                log.warn("failed reading binary value " + value, (Throwable)ioe);
                return new byte[0];
            }
        }
        log.warn(String.format("unknown binary format %s found for %s", format, reader.getName().getLocalPart()));
        return null;
    }

    public static void writeBytes(XMLStreamWriter writer, String name, byte[] value) throws Exception {
        XSHelper.writeBytes(writer, name, value, "base64", null);
    }

    static void writeBytes(XMLStreamWriter writer, String name, byte[] value, Map<String, String> attributes) throws Exception {
        XSHelper.writeBytes(writer, name, value, "base64", attributes);
    }

    public static void writeBytes(XMLStreamWriter writer, String name, byte[] value, String format) throws Exception {
        XSHelper.writeBytes(writer, name, value, format, null);
    }

    private static void writeBytes(XMLStreamWriter writer, String name, byte[] value, String format, Map<String, String> attributes) throws Exception {
        if (value == null) {
            return;
        }
        if (value.length == 0) {
            XSHelper.writeString(writer, name, "", false, attributes);
            return;
        }
        HashMap<String, String> _attributes = new HashMap<String, String>();
        if (attributes != null) {
            _attributes.putAll(attributes);
        }
        _attributes.put("format", format);
        if ("binhex".equalsIgnoreCase(format)) {
            XSHelper.writeString(writer, name, BinHex.encode(value), false, _attributes);
        } else if ("base64".equalsIgnoreCase(format)) {
            XSHelper.writeString(writer, name, Base64.encode(value), true, _attributes);
        } else if ("base64compressed".equalsIgnoreCase(format)) {
            XSHelper.writeString(writer, name, Base64.encode(GZIPUtil.gzip(value)), true, _attributes);
        } else {
            log.warn(String.format("unknown binary format %s specified for %s", format, name));
        }
    }

    public static <T> void registerHandler(Class<T> cls, XSHandler<? super T> handler) {
        handlers.put(cls.getName(), handler);
        log.debug(String.format("registered handler %s for %s", handler, cls));
    }

    protected static <T> XSHandler<T> getHandler(String className) {
        XSHandler<?> handler = handlers.get(className);
        if (handler != null) {
            return handler;
        }
        if (className.endsWith(".XMLGregorianCalendarImpl")) {
            return handlers.get(XMLGregorianCalendar.class.getName());
        }
        return null;
    }

    public static boolean isSupportedObjectType(Class<?> cls) {
        return cls.isEnum() || XSSerializable.class.isAssignableFrom(cls) || XSHelper.getHandler(cls.getName()) != null;
    }

    public static boolean isSimpleObject(Class<?> cls) {
        return XSHelper.getHandler(cls.getName()) != null;
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return XSHelper.getClass(className, true);
    }

    public static Class<?> getClass(String className, boolean initialize) throws ClassNotFoundException {
        Class<?> cls;
        if (TextUtil.isBlank(className)) {
            return null;
        }
        if (!clsCache.containsKey(className)) {
            try {
                cls = Class.forName(className, initialize, XSHelper.class.getClassLoader());
                clsCache.put(className, cls);
            }
            catch (ClassNotFoundException e) {
                log.error(String.format("failed loading class %s", className), (Throwable)e);
                clsCache.put(className, XSHelper.class);
                throw e;
            }
        }
        if (XSHelper.class.equals(cls = clsCache.get(className))) {
            throw new ClassNotFoundException(className);
        }
        return cls;
    }

    public static <E> Class<E> getClassForName(String className) throws ClassNotFoundException {
        return XSHelper.getClass(className);
    }

    public static <T> T readSimpleObject(XMLStreamReader reader, Class<T> cls) throws Exception {
        XSHandler<T> handler = XSHelper.getHandler(cls.getName());
        if (handler != null) {
            return handler.read(reader);
        }
        return null;
    }

    public static <T> T readObject(XMLStreamReader reader) throws Exception {
        Object result;
        Class<?> cls;
        String className = reader.getAttributeValue(null, "class");
        if (className == null) {
            throw new DOMFallbackException();
        }
        XSHandler<T> handler = XSHelper.getHandler(className);
        if (handler != null) {
            return handler.read(reader);
        }
        try {
            cls = XSHelper.getClass(className);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
        if (cls == null) {
            log.error(String.format("failed loading class %s for element %s", className, reader.getName().getLocalPart()));
            return null;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            try {
                AbstractCollection coll;
                AbstractCollection abstractCollection = coll = List.class.isAssignableFrom(cls) ? new LinkedList() : new HashSet();
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        T obj = XSHelper.readObject(reader);
                        if (obj == null) continue;
                        coll.add(obj);
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                return (T)coll;
            }
            catch (Exception e) {
                log.error(String.format("failed create a collection %s for element %s", className, reader.getName().getLocalPart()), (Throwable)e);
                return null;
            }
        }
        if (Map.class.isAssignableFrom(cls) && !XSSerializable.class.isAssignableFrom(cls)) {
            try {
                LinkedHashMap<Object, Object> coll = new LinkedHashMap<Object, Object>();
                while (reader.nextTag() != 2) {
                    if ("entry".equals(reader.getName().getLocalPart())) {
                        Object key = null;
                        Object value = null;
                        while (reader.nextTag() != 2) {
                            if ("key".equals(reader.getName().getLocalPart())) {
                                key = XSHelper.readObject(reader);
                                continue;
                            }
                            if ("value".equals(reader.getName().getLocalPart())) {
                                value = XSHelper.readObject(reader);
                                continue;
                            }
                            XSHelper.skipElement(reader);
                        }
                        if (key == null || value == null) continue;
                        coll.put(key, value);
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                return (T)coll;
            }
            catch (Exception e) {
                log.error(String.format("failed create a map %s for element %s", className, reader.getName().getLocalPart()), (Throwable)e);
                return null;
            }
        }
        if (cls.isArray()) {
            try {
                Object[] array = (Object[])Array.newInstance(cls.getComponentType(), Integer.parseInt(reader.getAttributeValue(null, "size")));
                int n = 0;
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        T obj = XSHelper.readObject(reader);
                        if (obj == null) continue;
                        array[n] = obj;
                        ++n;
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                return (T)(array.length == n ? array : Arrays.copyOf(array, n));
            }
            catch (Exception e) {
                log.error(String.format("failed deserializing array of type %s from element %s", cls.getName(), reader.getName().getLocalPart()), (Throwable)e);
                return null;
            }
        }
        if (cls.isEnum()) {
            return (T)XSHelper.readEnum(reader, cls);
        }
        String uid = reader.getAttributeValue(null, "uid");
        if (uid != null && (result = InvocationContext.get("entityDeserialize").getIdentity(uid)) != null) {
            return (T)result;
        }
        if (XSSerializable.class.isAssignableFrom(cls)) {
            try {
                result = (XSSerializable)cls.newInstance();
                result.fromXML(reader);
                if (result instanceof Identity) {
                    Identity idt = (Identity)result;
                    if (idt.getUid() == null) {
                        idt.setUid(uid);
                    }
                    if (idt.getUid() == null) {
                        throw new DOMFallbackException();
                    }
                }
                return (T)result;
            }
            catch (DOMFallbackException dfe) {
                throw dfe;
            }
            catch (Exception e) {
                log.error(String.format("failed deserializing object of type %s from element %s", cls.getName(), reader.getName().getLocalPart()), (Throwable)e);
                return null;
            }
        }
        throw new IllegalArgumentException("no handler found for element " + reader.getName().getLocalPart());
    }

    public static void writeSimpleObject(XMLStreamWriter writer, String name, Object value, Map<String, String> attributes) throws Exception {
        XSHandler<Object> handler = XSHelper.getHandler(value.getClass().getName());
        if (handler != null) {
            handler.write(writer, name, value, attributes);
        }
    }

    public static void writeObject(XMLStreamWriter writer, String name, Object value) throws Exception {
        XSHelper.writeObject(writer, name, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(XMLStreamWriter writer, String name, Object value, Map<String, String> attributes) throws Exception {
        block24: {
            if (value == null) {
                return;
            }
            boolean hasWatcher = writer instanceof XMLObjectWatcher;
            Object id = hasWatcher ? ((XMLObjectWatcher)((Object)writer)).beginObject(name, value) : null;
            try {
                Class<?> cls = value.getClass();
                XSHandler<Object> handler = XSHelper.getHandler(cls.getName());
                if (handler != null) {
                    HashMap<String, String> _attributes = new HashMap<String, String>();
                    if (attributes != null) {
                        _attributes.putAll(attributes);
                    }
                    _attributes.put("class", cls.getName());
                    handler.write(writer, name, value, _attributes);
                    break block24;
                }
                if (Collection.class.isAssignableFrom(cls)) {
                    writer.writeStartElement(name);
                    writer.writeAttribute("class", cls.getName());
                    XSHelper.writeAttributes(writer, attributes);
                    for (Object item : (Collection)value) {
                        XSHelper.writeObject(writer, "item", item);
                    }
                    writer.writeEndElement();
                    break block24;
                }
                if (Map.class.isAssignableFrom(cls) && !XSSerializable.class.isAssignableFrom(cls)) {
                    writer.writeStartElement(name);
                    writer.writeAttribute("class", cls.getName());
                    XSHelper.writeAttributes(writer, attributes);
                    for (Map.Entry item : ((Map)value).entrySet()) {
                        writer.writeStartElement("entry");
                        XSHelper.writeObject(writer, "key", item.getKey());
                        XSHelper.writeObject(writer, "value", item.getValue());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    break block24;
                }
                if (value instanceof Enum) {
                    HashMap<String, String> _attributes = new HashMap<String, String>();
                    if (attributes != null) {
                        _attributes.putAll(attributes);
                    }
                    _attributes.put("class", ((Enum)value).getDeclaringClass().getName());
                    XSHelper.writeEnum(writer, name, (Enum)value, _attributes);
                    break block24;
                }
                if (cls.isArray()) {
                    writer.writeStartElement(name);
                    writer.writeAttribute("class", cls.getName());
                    Object[] values = (Object[])value;
                    writer.writeAttribute("size", Integer.toString(values.length));
                    XSHelper.writeAttributes(writer, attributes);
                    for (Object item : values) {
                        XSHelper.writeObject(writer, "item", item);
                    }
                    writer.writeEndElement();
                    break block24;
                }
                if (value instanceof Identity && InvocationContext.get("entitySerialize").getIdentity(((Identity)value).getUid()) != null) {
                    writer.writeStartElement(name);
                    writer.writeAttribute("class", cls.getName());
                    writer.writeAttribute("uid", ((Identity)value).getUid());
                    XSHelper.writeAttributes(writer, attributes);
                    writer.writeEndElement();
                    break block24;
                }
                if (value instanceof XSSerializable) {
                    writer.writeStartElement(name);
                    writer.writeAttribute("class", cls.getName());
                    XSHelper.writeAttributes(writer, attributes);
                    try {
                        ((XSSerializable)value).toXML(writer);
                    }
                    catch (Exception e) {
                        log.warn(String.format("failed serializing value %s", value));
                    }
                    writer.writeEndElement();
                    break block24;
                }
                if (value instanceof Throwable) {
                    HashMap<String, String> _attributes = new HashMap<String, String>();
                    if (attributes != null) {
                        _attributes.putAll(attributes);
                    }
                    _attributes.put("class", XHelper.NonSerializableObject.class.getName());
                    HANDLER_NON_SERIALIZABLE_OBJECT.write(writer, name, new XHelper.NonSerializableObject(TextUtil.getExceptionStackTrace((Throwable)value)), _attributes);
                    break block24;
                }
                log.warn(String.format("failed serializing value %s", value));
                StringBuilder sb = new StringBuilder(value.toString() + "\n");
                try {
                    ObjectTrace.trace(sb, value);
                }
                catch (IOException item) {
                    // empty catch block
                }
                HashMap<String, String> _attributes = new HashMap<String, String>();
                if (attributes != null) {
                    _attributes.putAll(attributes);
                }
                _attributes.put("class", XHelper.NonSerializableObject.class.getName());
                HANDLER_NON_SERIALIZABLE_OBJECT.write(writer, name, new XHelper.NonSerializableObject(sb.toString()), _attributes);
            }
            finally {
                if (hasWatcher) {
                    ((XMLObjectWatcher)((Object)writer)).endObject(id);
                }
            }
        }
    }

    public static void writeBoolean(XMLStreamWriter writer, String name, boolean value) throws XMLStreamException {
        writer.writeStartElement(name);
        writer.writeCharacters(value ? "true" : "false");
        writer.writeEndElement();
    }

    public static void writeBoolean(XMLStreamWriter writer, String name, Boolean value) throws Exception {
        HANDLER_BOOLEAN.write(writer, name, value, null);
    }

    public static void writeDouble(XMLStreamWriter writer, String name, double value) throws XMLStreamException {
        writer.writeStartElement(name);
        writer.writeCharacters(Double.toString(value));
        writer.writeEndElement();
    }

    public static void writeDouble(XMLStreamWriter writer, String name, Double value) throws Exception {
        HANDLER_DOUBLE.write(writer, name, value, null);
    }

    public static Double readDouble(XMLStreamReader reader) throws Exception {
        return HANDLER_DOUBLE.read(reader);
    }

    public static double readDouble(XMLStreamReader reader, double def) throws Exception {
        String value = reader.getElementText();
        if (TextUtil.isBlank(value)) {
            return def;
        }
        return Double.parseDouble(value);
    }

    public static void writeLocalizationString(XMLStreamWriter writer, String name, L10nString value) throws Exception {
        HANDLER_LOCALIZATION_STRING.write(writer, name, value, null);
    }

    public static void writeLocale(XMLStreamWriter writer, String name, Locale value) throws Exception {
        HANDLER_LOCALE.write(writer, name, value, null);
    }

    public static void writeByte(XMLStreamWriter writer, String name, byte value) throws Exception {
        writer.writeStartElement(name);
        writer.writeCharacters(Byte.toString(value));
        writer.writeEndElement();
    }

    public static void writeByte(XMLStreamWriter writer, String name, Byte value) throws Exception {
        if (value == null) {
            return;
        }
        writer.writeStartElement(name);
        writer.writeCharacters(Byte.toString(value));
        writer.writeEndElement();
    }

    public static void writeJodaLocalDateTime(XMLStreamWriter writer, String name, org.joda.time.LocalDateTime value) throws Exception {
        HANDLER_JODA_LOCAL_DATETIME.write(writer, name, value, null);
    }

    public static void writeJodaLocalDate(XMLStreamWriter writer, String name, org.joda.time.LocalDate value) throws Exception {
        HANDLER_JODA_LOCAL_DATE.write(writer, name, value, null);
    }

    public static void writeJavaLocalDateTime(XMLStreamWriter writer, String name, LocalDateTime value) throws Exception {
        HANDLER_JAVA_LOCAL_DATETIME.write(writer, name, value, null);
    }

    public static void writeJavaLocalDate(XMLStreamWriter writer, String name, LocalDate value) throws Exception {
        HANDLER_JAVA_LOCAL_DATE.write(writer, name, value, null);
    }

    public static void writeURL(XMLStreamWriter writer, String name, URL value) throws Exception {
        HANDLER_URL.write(writer, name, value, null);
    }

    public static void writeJodaLocalTime(XMLStreamWriter writer, String name, LocalTime value) throws Exception {
        HANDLER_JODA_LOCAL_TIME.write(writer, name, value, null);
    }

    public static void writeJavaLocalTime(XMLStreamWriter writer, String name, java.time.LocalTime value) throws Exception {
        HANDLER_JAVA_LOCAL_TIME.write(writer, name, value, null);
    }

    public static void writeChar(XMLStreamWriter writer, String name, char value) throws Exception {
        writer.writeStartElement(name);
        writer.writeCData(Character.toString(value));
        writer.writeEndElement();
    }

    public static void writeChar(XMLStreamWriter writer, String name, Character value) throws Exception {
        HANDLER_CHAR.write(writer, name, value, null);
    }

    public static void writeFloat(XMLStreamWriter writer, String name, float value) throws Exception {
        writer.writeStartElement(name);
        writer.writeCharacters(Float.toString(value));
        writer.writeEndElement();
    }

    public static void writeFloat(XMLStreamWriter writer, String name, Float value) throws Exception {
        HANDLER_FLOAT.write(writer, name, value, null);
    }

    public static void writeBigInteger(XMLStreamWriter writer, String name, BigInteger value) throws Exception {
        HANDLER_BIG_INTEGER.write(writer, name, value, null);
    }

    public static void writeURI(XMLStreamWriter writer, String name, URI value) throws Exception {
        HANDLER_URI.write(writer, name, value, null);
    }

    public static void writeUUID(XMLStreamWriter writer, String name, UUID value) throws Exception {
        HANDLER_UUID.write(writer, name, value, null);
    }

    public static void writeJodaDateTime(XMLStreamWriter writer, String name, DateTime value) throws Exception {
        HANDLER_JODA_DATETIME.write(writer, name, value, null);
    }

    public static void writeJavaOffsetDateTime(XMLStreamWriter writer, String name, OffsetDateTime value) throws Exception {
        HANDLER_JAVA_OFFSET_DATETIME.write(writer, name, value, null);
    }

    public static void writeJavaInstant(XMLStreamWriter writer, String name, Instant value) throws Exception {
        HANDLER_JAVA_INSTANT.write(writer, name, value, null);
    }

    public static void writeJavaDayOfWeek(XMLStreamWriter writer, String name, DayOfWeek value) throws Exception {
        HANDLER_JAVA_DAY_OF_WEEK.write(writer, name, value, null);
    }

    public static <E> void writeCollection(XMLStreamWriter writer, String name, Collection<E> collection) throws Exception {
        XSHelper.writeObject(writer, name, collection);
    }

    public static <E> Collection<E> readCollection(XMLStreamReader reader) throws Exception {
        List result = (List)XSHelper.readObject(reader);
        return result != null ? result : Collections.emptyList();
    }

    public static void writeDomElement(XMLStreamWriter writer, Element elm) throws Exception {
        writer.writeStartElement(elm.getTagName());
        for (Map.Entry<String, String> attr : XmlUtil.getAttributes(elm).entrySet()) {
            writer.writeAttribute(attr.getKey(), attr.getValue());
        }
        String val = XmlUtil.getValue(elm);
        if (!StringUtils.isBlank((String)val)) {
            writer.writeCharacters(val);
        } else {
            for (Element child : XmlUtil.getChildren(elm)) {
                XSHelper.writeDomElement(writer, child);
            }
        }
        writer.writeEndElement();
    }

    static {
        XSHelper.registerHandler(String.class, HANDLER_TEXT);
        XSHelper.registerHandler(Boolean.class, HANDLER_BOOLEAN);
        XSHelper.registerHandler(Boolean.TYPE, HANDLER_BOOLEAN);
        XSHelper.registerHandler(Byte.class, HANDLER_BYTE);
        XSHelper.registerHandler(Byte.TYPE, HANDLER_BYTE);
        XSHelper.registerHandler(Character.class, HANDLER_CHAR);
        XSHelper.registerHandler(Character.TYPE, HANDLER_CHAR);
        XSHelper.registerHandler(byte[].class, HANDLER_BYTES_ARRAY);
        XSHelper.registerHandler(Short.class, HANDLER_SHORT);
        XSHelper.registerHandler(Short.TYPE, HANDLER_SHORT);
        XSHelper.registerHandler(Integer.class, HANDLER_INT);
        XSHelper.registerHandler(Integer.TYPE, HANDLER_INT);
        XSHelper.registerHandler(Long.class, HANDLER_LONG);
        XSHelper.registerHandler(Long.TYPE, HANDLER_LONG);
        XSHelper.registerHandler(Float.class, HANDLER_FLOAT);
        XSHelper.registerHandler(Float.TYPE, HANDLER_FLOAT);
        XSHelper.registerHandler(Double.class, HANDLER_DOUBLE);
        XSHelper.registerHandler(Double.TYPE, HANDLER_DOUBLE);
        XSHelper.registerHandler(BigDecimal.class, HANDLER_BIG_DECIMAL);
        XSHelper.registerHandler(BigInteger.class, HANDLER_BIG_INTEGER);
        XSHelper.registerHandler(java.util.Date.class, HANDLER_DATE);
        XSHelper.registerHandler(Locale.class, HANDLER_LOCALE);
        XSHelper.registerHandler(URL.class, HANDLER_URL);
        XSHelper.registerHandler(URI.class, HANDLER_URI);
        XSHelper.registerHandler(UUID.class, HANDLER_UUID);
        XSHelper.registerHandler(Pair.class, HANDLER_PAIR);
        XSHelper.registerHandler(DateInterval.class, HANDLER_DATE_INTERVAL);
        XSHelper.registerHandler(L10nMessage.class, HANDLER_L10N_MESSAGE);
        XSHelper.registerHandler(L10nString.class, HANDLER_LOCALIZATION_STRING);
        XSHelper.registerHandler(XHelper.NonSerializableObject.class, HANDLER_NON_SERIALIZABLE_OBJECT);
        XSHelper.registerHandler(Date.class, HANDLER_DATE);
        XSHelper.registerHandler(Time.class, HANDLER_DATE);
        XSHelper.registerHandler(Timestamp.class, HANDLER_DATE);
        XSHelper.registerHandler(java.time.LocalTime.class, HANDLER_JAVA_LOCAL_TIME);
        XSHelper.registerHandler(LocalDate.class, HANDLER_JAVA_LOCAL_DATE);
        XSHelper.registerHandler(LocalDateTime.class, HANDLER_JAVA_LOCAL_DATETIME);
        XSHelper.registerHandler(XMLGregorianCalendar.class, HANDLER_XML_GREGORIAN_CALENDAR);
        XSHelper.registerHandler(XMLGregorianCalendar.class, HANDLER_XML_GREGORIAN_CALENDAR);
    }
}

