/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml;

import com.gridnine.xtrip.common.util.XSSerializable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.zip.GZIPOutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;

public class XSUtil {
    private static final ThreadLocal<XMLInputFactory> INPUT_FACTORIES = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                return xMLInputFactory;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(XSUtil.class).error("failed creating XML builder", (Throwable)e);
                throw new Error("failed creating XML builder", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    };
    private static final ThreadLocal<XMLOutputFactory> OUTPUT_FACTORIES = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
                return xMLOutputFactory;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(XSUtil.class).error("failed creating XML builder", (Throwable)e);
                throw new Error("failed creating XML builder", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    };

    public static XMLInputFactory getXMLInputFactory() {
        return INPUT_FACTORIES.get();
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        return OUTPUT_FACTORIES.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(XSSerializable xsobj) throws Exception {
        try (StringWriter sw = new StringWriter();){
            try (XMLStreamWriter xsw = XSUtil.wrapForPrettyPrinting(XSUtil.getXMLOutputFactory().createXMLStreamWriter(sw));){
                xsw.writeStartElement("object");
                xsw.writeAttribute("class", xsobj.getClass().getName());
                xsobj.toXML(xsw);
                xsw.writeEndElement();
            }
            sw.flush();
            String string = sw.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Collection<? extends XSSerializable> xsobjs) throws Exception {
        try (StringWriter sw = new StringWriter();){
            try (XMLStreamWriter xsw = XSUtil.wrapForPrettyPrinting(XSUtil.getXMLOutputFactory().createXMLStreamWriter(sw));){
                xsw.writeStartElement("objects");
                for (XSSerializable xSSerializable : xsobjs) {
                    xsw.writeStartElement("object");
                    xsw.writeAttribute("class", xSSerializable.getClass().getName());
                    xSSerializable.toXML(xsw);
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
            }
            sw.flush();
            String string = sw.toString();
            return string;
        }
    }

    public static byte[] toByteArray(XSSerializable xsobj) throws Exception {
        return XSUtil.toByteArray(xsobj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(XSSerializable xsobj, boolean gzip) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            GZIPOutputStream gzos = gzip ? new GZIPOutputStream(baos) : null;
            try {
                XSUtil.serialize(xsobj, gzip ? gzos : baos);
            }
            finally {
                if (gzip) {
                    gzos.close();
                }
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void serialize(XSSerializable xsobj, OutputStream os) throws Exception {
        try (XMLStreamWriter xsw = XSUtil.wrapForPrettyPrinting(XSUtil.getXMLOutputFactory().createXMLStreamWriter(os));){
            xsw.writeStartElement("object");
            xsw.writeAttribute("class", xsobj.getClass().getName());
            xsobj.toXML(xsw);
            xsw.writeEndElement();
        }
    }

    public static XMLStreamWriter wrapForPrettyPrinting(final XMLStreamWriter writer) {
        return new XMLStreamWriter(){
            private int level = 0;
            private boolean lastWasStart = false;

            private void indent() throws XMLStreamException {
                for (int i = 0; i < this.level; ++i) {
                    writer.writeCharacters("    ");
                }
            }

            @Override
            public void writeStartElement(String localName) throws XMLStreamException {
                if (this.level > 0) {
                    writer.writeCharacters("\n");
                }
                this.lastWasStart = true;
                this.indent();
                ++this.level;
                writer.writeStartElement(localName);
            }

            @Override
            public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
                writer.writeCharacters("\n");
                this.lastWasStart = true;
                this.indent();
                ++this.level;
                writer.writeStartElement(namespaceURI, localName);
            }

            @Override
            public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                writer.writeCharacters("\n");
                this.lastWasStart = true;
                ++this.level;
                writer.writeStartElement(prefix, localName, namespaceURI);
            }

            @Override
            public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
                writer.writeCharacters("\n");
                this.lastWasStart = false;
                this.indent();
                writer.writeEmptyElement(namespaceURI, localName);
            }

            @Override
            public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                writer.writeCharacters("\n");
                this.lastWasStart = false;
                this.indent();
                writer.writeEmptyElement(prefix, localName, namespaceURI);
            }

            @Override
            public void writeEmptyElement(String localName) throws XMLStreamException {
                writer.writeCharacters("\n");
                this.lastWasStart = false;
                this.indent();
                writer.writeEmptyElement(localName);
            }

            @Override
            public void writeEndElement() throws XMLStreamException {
                --this.level;
                if (!this.lastWasStart) {
                    writer.writeCharacters("\n");
                    this.indent();
                } else {
                    this.lastWasStart = false;
                }
                writer.writeEndElement();
            }

            @Override
            public void writeEndDocument() throws XMLStreamException {
                if (!this.lastWasStart) {
                    writer.writeCharacters("\n");
                    this.indent();
                } else {
                    this.lastWasStart = false;
                }
                writer.writeEndDocument();
            }

            @Override
            public void close() throws XMLStreamException {
                this.level = 0;
                this.lastWasStart = false;
                writer.close();
            }

            @Override
            public void flush() throws XMLStreamException {
                writer.flush();
            }

            @Override
            public void writeAttribute(String localName, String value) throws XMLStreamException {
                writer.writeAttribute(localName, value);
            }

            @Override
            public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
                writer.writeAttribute(prefix, namespaceURI, localName, value);
            }

            @Override
            public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
                writer.writeAttribute(namespaceURI, localName, value);
            }

            @Override
            public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
                writer.writeNamespace(prefix, namespaceURI);
            }

            @Override
            public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
                writer.writeDefaultNamespace(namespaceURI);
            }

            @Override
            public void writeComment(String data) throws XMLStreamException {
                writer.writeCharacters("\n");
                this.lastWasStart = false;
                this.indent();
                writer.writeComment(data);
            }

            @Override
            public void writeProcessingInstruction(String target) throws XMLStreamException {
                writer.writeProcessingInstruction(target);
            }

            @Override
            public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
                writer.writeProcessingInstruction(target, data);
            }

            @Override
            public void writeCData(String data) throws XMLStreamException {
                if (data == null) {
                    writer.writeCData(data);
                } else {
                    String[] parts = data.split("]]>");
                    if (parts.length == 1) {
                        writer.writeCData(data);
                    } else {
                        for (int i = 0; i < parts.length; ++i) {
                            StringBuilder sb = new StringBuilder();
                            if (i > 0) {
                                sb.append(">");
                            }
                            sb.append(parts[i]);
                            if (i + 1 < parts.length) {
                                sb.append("]]");
                            }
                            writer.writeCData(sb.toString());
                        }
                    }
                }
            }

            @Override
            public void writeDTD(String dtd) throws XMLStreamException {
                writer.writeDTD(dtd);
            }

            @Override
            public void writeEntityRef(String name) throws XMLStreamException {
                writer.writeEntityRef(name);
            }

            @Override
            public void writeStartDocument() throws XMLStreamException {
                writer.writeStartDocument();
                writer.writeCharacters("\n");
            }

            @Override
            public void writeStartDocument(String version) throws XMLStreamException {
                writer.writeStartDocument(version);
                writer.writeCharacters("\n");
            }

            @Override
            public void writeStartDocument(String encoding, String version) throws XMLStreamException {
                writer.writeStartDocument(encoding, version);
                writer.writeCharacters("\n");
            }

            @Override
            public void writeCharacters(String text) throws XMLStreamException {
                writer.writeCharacters(text);
            }

            @Override
            public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
                writer.writeCharacters(text, start, len);
            }

            @Override
            public String getPrefix(String uri) throws XMLStreamException {
                return writer.getPrefix(uri);
            }

            @Override
            public void setPrefix(String prefix, String uri) throws XMLStreamException {
                writer.setPrefix(prefix, uri);
            }

            @Override
            public void setDefaultNamespace(String uri) throws XMLStreamException {
                writer.setDefaultNamespace(uri);
            }

            @Override
            public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
                writer.setNamespaceContext(context);
            }

            @Override
            public NamespaceContext getNamespaceContext() {
                return writer.getNamespaceContext();
            }

            @Override
            public Object getProperty(String name) throws IllegalArgumentException {
                return writer.getProperty(name);
            }
        };
    }
}

