/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Deprecated
public class XUtil {
    private static final TransformerFactory TF = TransformerFactory.newInstance();

    public static Element newDocument(String rootElmName) throws Exception {
        Document result = DocumentBuilderHelper.newDocument();
        Element rootElm = result.createElement(rootElmName);
        result.appendChild(rootElm);
        return rootElm;
    }

    public static Transformer getTransformer() throws Exception {
        return XUtil.newTransformer();
    }

    public static InputSource createSource(InputStream stream, boolean useDefaultEncoding) {
        if (useDefaultEncoding) {
            return new InputSource(stream);
        }
        return XUtil.createSource(stream);
    }

    public static InputSource createSource(InputStream stream) {
        return XUtil.createSource(stream, "utf-8");
    }

    public static InputSource createSource(InputStream stream, String encoding) {
        InputSource result = new InputSource(stream);
        result.setEncoding(encoding);
        return result;
    }

    public static Transformer newTransformer() throws Exception {
        Transformer result = TF.newTransformer();
        result.setOutputProperty("omit-xml-declaration", "yes");
        result.setOutputProperty("indent", "yes");
        result.setOutputProperty("method", "xml");
        result.setOutputProperty("standalone", "yes");
        result.setOutputProperty("encoding", "utf-8");
        result.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        return result;
    }

    public static void serialize(XSerializable xobj, OutputStream strm) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("object");
        root.setAttribute("class", xobj.getClass().getName());
        xobj.toXML(root);
        doc.appendChild(root);
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(strm));
    }

    public static void serializeWithoutRoot(XSerializable xobj, OutputStream strm, boolean includeXmlDeclaration) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("object");
        xobj.toXML(root);
        root = XUtil.removeRootNode(root);
        doc.appendChild(root);
        if (includeXmlDeclaration) {
            XUtil.newTransformer().setOutputProperty("omit-xml-declaration", "no");
        }
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(strm));
    }

    public static Element removeRootNode(Element root) {
        if (root.getChildNodes() != null && root.getChildNodes().getLength() > 0) {
            root = (Element)root.getChildNodes().item(0);
        }
        return root;
    }

    public static void serialize(Iterable<? extends XSerializable> it, OutputStream strm) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("objects");
        doc.appendChild(root);
        for (XSerializable xSerializable : it) {
            Element elm = doc.createElement("object");
            elm.setAttribute("class", xSerializable.getClass().getName());
            xSerializable.toXML(elm);
            root.appendChild(elm);
        }
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(strm));
    }

    public static void writeToStream(XSerializable xobj, OutputStream os) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("object");
        root.setAttribute("class", xobj.getClass().getName());
        xobj.toXML(root);
        doc.appendChild(root);
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(os));
    }

    public static String toString(Document doc) throws Exception {
        return XUtil.toString(doc, "utf-8");
    }

    public static String toString(Document doc, String encoding) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(baos));
        return baos.toString(encoding);
    }

    public static void toFile(Document doc, String path) throws Exception {
        try (FileWriter fw = new FileWriter(path);){
            fw.write(XUtil.toString(doc));
        }
    }

    public static String toString(Element el) throws Exception {
        return XUtil.toString(el, "utf-8");
    }

    public static String toString(Element el, String encoding) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XUtil.newTransformer().transform(new DOMSource(el), new StreamResult(baos));
        return baos.toString(encoding);
    }

    public static String toStructure(Node node) {
        return XUtil.toStructure(node, 0);
    }

    public static String toStructure(Node node, int depth) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextUtil.repeat("    ", depth));
        stringBuilder.append(node.getNodeName());
        stringBuilder.append("\n");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            stringBuilder.append(XUtil.toStructure(children.item(i), depth + 1));
        }
        return stringBuilder.toString();
    }

    public static void fromBytes(byte[] bytes, XSerializable xobj) throws Exception {
        xobj.fromXML(XUtil.fromBytes(bytes));
    }

    public static void fromStream(InputStream is, XSerializable xobj) throws Exception {
        xobj.fromXML(XUtil.fromStream(is));
    }

    public static void fromString(String str, XSerializable xobj) throws Exception {
        xobj.fromXML(DocumentBuilderHelper.parse(new InputSource(new StringReader(str))).getDocumentElement());
    }

    public static Element fromBytes(byte[] bytes) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Element element = XUtil.fromStream(bais);
            return element;
        }
    }

    public static Element fromStream(InputStream is) throws Exception {
        return DocumentBuilderHelper.parse(is).getDocumentElement();
    }

    private XUtil() {
    }

    public static Element createElement(String name) {
        Document doc = DocumentBuilderHelper.newDocument();
        doc.appendChild(doc.createElement(name));
        return doc.getDocumentElement();
    }

    public static <E extends XSerializable> E deserialize(byte[] bytes) throws Exception {
        Element elm = XUtil.fromBytes(bytes);
        Class clazz = XHelper.getClassForName(elm.getAttribute("class"));
        XSerializable xobj = (XSerializable)clazz.newInstance();
        xobj.fromXML(elm);
        return (E)xobj;
    }

    public static <E extends XSerializable> void deserialize(String content, E object) throws Exception {
        XUtil.deserialize((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), object);
    }

    public static <E extends XSerializable> void deserialize(InputStream is, E object) throws Exception {
        Element element = DocumentBuilderHelper.parse(is).getDocumentElement();
        Class type = XHelper.getClassForName(element.getAttribute("class"));
        if (type == null) {
            throw new IllegalStateException("class is not defined");
        }
        object.fromXML(element);
    }

    public static <E extends XSerializable> void deserialize(String content, Collection<E> objects) throws Exception {
        XUtil.deserialize((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), objects);
    }

    public static <E extends XSerializable> void deserialize(InputStream is, Collection<E> objects) throws Exception {
        Element[] elements;
        Element root = DocumentBuilderHelper.parse(is).getDocumentElement();
        for (Element element : elements = XmlUtil.getElements(root, "object")) {
            Class type = XHelper.getClassForName(element.getAttribute("class"));
            if (type == null) {
                throw new IllegalStateException("class is not defined");
            }
            XSerializable object = (XSerializable)type.newInstance();
            object.fromXML(element);
            objects.add(object);
        }
    }

    static {
        TF.setAttribute("indent-number", 2);
    }
}

