/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.converters;

import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticUdidsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeDisplayType;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StatisticGeneralProductFXHelper {
    public static void toVMProductStatistic(BaseProduct product, BaseProductUIData supplement, BookingFileProductStatisticVM statistic) {
        StatisticalData statisticalData;
        if (!ProductHandler.of((BaseProduct)product).isStatisticalDataAvailable(product)) {
            return;
        }
        ProductFXHandler handler = ProductFXHandler.forProduct((BaseProduct)product);
        if (handler != null && (statisticalData = handler.getStatisticalData(product)) != null) {
            statistic.getStatistic().getAfs().getParameters().setSalesDeepLimit(statisticalData.getSalesDeeps());
            statistic.getStatistic().getAfs().getParameters().setMinPricePerRoom(statisticalData.getMinPricePerRoom());
            statistic.getStatistic().getAfs().getParameters().setFlightDuration(statisticalData.getFlightDuration());
            statistic.getStatistic().getAfs().getParameters().setRackRatePrice(statisticalData.getRackRatePrice());
            statistic.getStatistic().getAfs().getParameters().setViolation(statisticalData.getTravelPolicyViolation());
            statistic.getStatistic().getAfs().getParameters().setAuthorization(statisticalData.getTravelPolicyAuthorization());
            statistic.getStatistic().getAfs().getParameters().setLimit(statisticalData.getTravelPolicyLimit());
            statistic.getStatistic().getAfs().getParameters().setSalesDeepsLimit(statisticalData.getTravelPolicySalesDeepsLimit());
            statistic.getStatistic().getAfs().getParameters().setMinPriceHotel(statisticalData.getMinPriceHotel());
            statistic.getStatistic().getAfs().getParameters().setMinPriceRailway(statisticalData.getMinPriceRailway());
            statistic.getTravellersIbe().addAll(handler.getTravellers(product));
            statistic.getStatistic().getUdids().clear();
            if (CollectionUtil.isNotEmpty((Collection)statisticalData.getTravellerCostCodes())) {
                int travellerNumber = 0;
                for (TravellerCostCodes travellerCostCodes : statisticalData.getTravellerCostCodes()) {
                    for (CostCode costCode : travellerCostCodes.getCostCodes()) {
                        BookingFileProductStatisticUdidsVM udidVM = new BookingFileProductStatisticUdidsVM();
                        udidVM.setName(costCode.getCostCodeProperties());
                        udidVM.setValue(costCode.getValue());
                        udidVM.setLocalValue(costCode.getLocalValue());
                        udidVM.setEnglishValue(costCode.getEnglishValue());
                        udidVM.setTravellerIbe(travellerCostCodes.getTraveller());
                        udidVM.setTravellerNumber(travellerNumber);
                        statistic.getStatistic().getUdids().add(udidVM);
                    }
                    ++travellerNumber;
                }
            }
        }
    }

    public static void fromVMProductStatistic(BookingFileProductStatisticVM statistic, BaseProduct product) {
        StatisticalData statisticalData;
        if (!ProductHandler.of((BaseProduct)product).isStatisticalDataAvailable(product)) {
            return;
        }
        ProductFXHandler handler = ProductFXHandler.forProduct((BaseProduct)product);
        if (handler != null && (statisticalData = handler.getStatisticalData(product)) != null) {
            statisticalData.setSalesDeeps(statistic.getStatistic().getAfs().getParameters().getSalesDeepLimit());
            statisticalData.setMinPricePerRoom(statistic.getStatistic().getAfs().getParameters().getMinPricePerRoom());
            statisticalData.setFlightDuration(statistic.getStatistic().getAfs().getParameters().getFlightDuration());
            statisticalData.setRackRatePrice(statistic.getStatistic().getAfs().getParameters().getRackRatePrice());
            statisticalData.setTravelPolicyViolation(statistic.getStatistic().getAfs().getParameters().getViolation());
            statisticalData.setTravelPolicyAuthorization(statistic.getStatistic().getAfs().getParameters().getAuthorization());
            statisticalData.setTravelPolicyLimit(statistic.getStatistic().getAfs().getParameters().getLimit());
            statisticalData.setTravelPolicySalesDeepsLimit(statistic.getStatistic().getAfs().getParameters().getSalesDeepsLimit());
            statisticalData.setMinPriceHotel(statistic.getStatistic().getAfs().getParameters().getMinPriceHotel());
            statisticalData.setMinPriceRailway(statistic.getStatistic().getAfs().getParameters().getMinPriceRailway());
            statisticalData.getTravellerCostCodes().clear();
            HashSet travellers = new HashSet(handler.getTravellers(product));
            travellers.stream().filter(Objects::nonNull).forEach(traveller -> {
                TravellerCostCodes costCodes = new TravellerCostCodes();
                costCodes.setTraveller(traveller);
                statistic.getStatistic().getUdids().stream().filter(udid -> traveller.equals((Object)udid.getTravellerIbe())).forEach(udid -> {
                    CostCode costCode = new CostCode();
                    costCode.setCostCodeProperties(udid.getName());
                    costCode.setValue(udid.getValue());
                    costCode.setLocalValue(udid.getLocalValue());
                    costCode.setEnglishValue(udid.getEnglishValue());
                    costCodes.getCostCodes().add(costCode);
                });
                statisticalData.getTravellerCostCodes().add(costCodes);
            });
            for (TravellerCostCodes travellerCostCodes2 : statisticalData.getTravellerCostCodes()) {
                travellerCostCodes2.getCostCodes().removeIf(costCode -> TextUtil.isBlank((String)costCode.getValue()));
            }
            statisticalData.getTravellerCostCodes().removeIf(travellerCostCodes -> travellerCostCodes.getCostCodes().isEmpty());
        }
    }

    public static void updateRelatedCostCodes(boolean isMultiTraveller, List<Traveller> travellers, List<CostCodeProperties> costCodeProperties, List<CostCode> costCodes, Collection<BookingFileProductStatisticUdidsVM> udidVMs) {
        udidVMs.removeIf(udidVm -> udidVm.isAutoAdded() && TextUtil.isBlank((String)udidVm.getValue()));
        Map<Traveller, List<CostCodeProperties>> notSelectedCostCodeProperties = StatisticGeneralProductFXHelper.getNotSelectedCostCodeProperties(isMultiTraveller, travellers, costCodeProperties, costCodes, udidVMs);
        notSelectedCostCodeProperties.forEach((traveller, propertiesList) -> propertiesList.forEach(properties -> {
            BookingFileProductStatisticUdidsVM emptyUdidVM = new BookingFileProductStatisticUdidsVM();
            emptyUdidVM.setName(properties);
            emptyUdidVM.setTravellerIbe(traveller);
            emptyUdidVM.setAutoAdded(true);
            emptyUdidVM.setTravellerNumber(travellers.indexOf(traveller));
            udidVMs.add(emptyUdidVM);
        }));
    }

    private static Map<Traveller, List<CostCodeProperties>> getNotSelectedCostCodeProperties(boolean isMultiTraveller, List<Traveller> travellers, List<CostCodeProperties> costCodeProperties, List<CostCode> costCodes, Collection<BookingFileProductStatisticUdidsVM> udidVMs) {
        HashMap<Traveller, List<CostCodeProperties>> result = new HashMap<Traveller, List<CostCodeProperties>>();
        for (CostCodeProperties properties : costCodeProperties) {
            Traveller traveller;
            List costCodesWithRelation = costCodes.stream().filter(costCode -> costCode.getRelatedCostCodeProperties().contains(properties)).collect(Collectors.toList());
            if (isMultiTraveller) {
                for (Traveller traveller2 : travellers) {
                    if (StatisticGeneralProductFXHelper.isSelected(properties, traveller2, udidVMs)) continue;
                    boolean costCodeSelected = costCodesWithRelation.stream().anyMatch(costCode -> StatisticGeneralProductFXHelper.isSelected(costCode, traveller2, udidVMs));
                    if (!costCodesWithRelation.isEmpty() && !costCodeSelected) continue;
                    result.computeIfAbsent(traveller2, t -> new ArrayList()).add(properties);
                }
                continue;
            }
            Traveller traveller3 = traveller = travellers.isEmpty() ? null : travellers.get(0);
            if (StatisticGeneralProductFXHelper.isSelected(properties, traveller, udidVMs)) continue;
            boolean costCodeSelected = costCodesWithRelation.stream().anyMatch(costCode -> StatisticGeneralProductFXHelper.isSelected(costCode, traveller, udidVMs));
            if (!costCodesWithRelation.isEmpty() && !costCodeSelected) continue;
            result.computeIfAbsent(traveller, t -> new ArrayList()).add(properties);
        }
        return result;
    }

    private static boolean isSelected(CostCodeProperties properties, Traveller traveller, Collection<BookingFileProductStatisticUdidsVM> udidVMs) {
        if (properties == null || properties.getCategory() == null) {
            return false;
        }
        return udidVMs.stream().anyMatch(udidVM -> (traveller == null || traveller.equals((Object)udidVM.getTravellerIbe())) && StatisticsHelper.equalsCostCodeProperties((CostCodeProperties)udidVM.getName(), (CostCodeProperties)properties));
    }

    private static boolean isSelected(CostCode costCode, Traveller traveller, Collection<BookingFileProductStatisticUdidsVM> udidVMs) {
        if (costCode.getCostCodeProperties() == null) {
            return false;
        }
        String costCodeValue = ProfileHelper.getCostCodeValue((CostCode)costCode, (CostCodeDisplayType)CostCodeDisplayType.LOCAL_VALUE);
        String costCodeDefaultValue = ProfileHelper.getCostCodeValue((CostCode)costCode, (CostCodeDisplayType)CostCodeDisplayType.SABRE_VALUE);
        return udidVMs.stream().anyMatch(udidVM -> !(traveller != null && !traveller.equals((Object)udidVM.getTravellerIbe()) || !costCode.getCostCodeProperties().equals((Object)udidVM.getName()) || !TextUtil.nonBlank((String)udidVM.getValue()) || !TextUtil.isSame((String)udidVM.getValue(), (String)costCodeValue) && !TextUtil.isSame((String)udidVM.getValue(), (String)costCodeDefaultValue)));
    }
}

