/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.statistic.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationRelatedCostCodePropertiesVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidValueVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public final class OrganizationUdidsTileIbeHelper {
    private OrganizationUdidsTileIbeHelper() {
    }

    static void toVM(Organization model, OrganizationUdidsPanelVM udidsVM) {
        for (OrganizationUdidVM udidVM : udidsVM.getGeneral()) {
            CostCodeProperties requiredCostCodeProp = model.getCostCodeProperties().stream().filter(codeProperties -> udidVM.getUid().equals(codeProperties.getUid())).findFirst().orElse(null);
            if (requiredCostCodeProp == null) continue;
            udidVM.setDesignatorType(requiredCostCodeProp.getDesignatorType());
            udidVM.setCommon(requiredCostCodeProp.isCommon());
            udidVM.setPassengerUdid(requiredCostCodeProp.isPassengerUdid());
            udidVM.setShipmentCategory(requiredCostCodeProp.isShipmentCategory());
            udidVM.setDependant(requiredCostCodeProp.isDependant());
            String relatedCostCodeProperties = model.getCostCodes().stream().filter(costCode -> requiredCostCodeProp.equals((Object)costCode.getCostCodeProperties())).flatMap(cc -> cc.getRelatedCostCodeProperties().stream()).filter(Objects::nonNull).distinct().map(properties -> (properties.getType() != null ? properties.getType().toString() : "") + (TextUtil.nonBlank((String)properties.getName()) ? " (" + properties.getName() + ")" : "")).collect(Collectors.joining(", "));
            if (TextUtil.nonBlank((String)relatedCostCodeProperties)) {
                udidVM.setRelatedCostCodeProperties(relatedCostCodeProperties);
                continue;
            }
            udidVM.setRelatedCostCodeProperties(null);
        }
    }

    public static void fromVM(OrganizationUdidsPanelVM udidsVM, EntityContainer<Organization> modelCtr) {
        Organization model = (Organization)modelCtr.getEntity();
        List properties = model.getCostCodeProperties().stream().filter(CostCodeProperties::isShipmentCategory).collect(Collectors.toList());
        for (CostCodeProperties costCodeProperties : model.getCostCodeProperties()) {
            OrganizationUdidVM udidVM = udidsVM.getGeneral().stream().filter(vm -> vm.getUid().equals(costCodeProperties.getUid())).findFirst().orElse(null);
            if (udidVM == null) continue;
            costCodeProperties.setDesignatorType(udidVM.getDesignatorType());
            costCodeProperties.setCommon(udidVM.isCommon());
            costCodeProperties.setPassengerUdid(udidVM.isPassengerUdid());
            costCodeProperties.setShipmentCategory(udidVM.isShipmentCategory());
            costCodeProperties.setDependant(udidVM.isDependant());
        }
        if (!properties.isEmpty() && (properties.stream().anyMatch(p -> !p.isShipmentCategory()) || properties.stream().anyMatch(p -> !model.getCostCodeProperties().contains(p)))) {
            properties.stream().filter(p -> !p.isShipmentCategory() || !model.getCostCodeProperties().contains(p)).forEach(p -> {
                ConcurrentLinkedQueue searchResult = new ConcurrentLinkedQueue();
                Thread nonFXThread = new Thread(() -> {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.customer.name(), (Object)modelCtr.getUid()));
                    query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)ShipmentIndex.Property.costCodeProperties.name(), (String)("%" + p.getUid() + "%")));
                    try {
                        searchResult.addAll(((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), ShipmentIndex.class, query));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                nonFXThread.start();
                try {
                    nonFXThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!searchResult.isEmpty()) {
                    Notifications.get().showMessages(new Message[]{Messages.getShipmentCostCodePresent((String)p.getName())});
                }
            });
        }
    }

    static void toVM(Organization model, OrganizationUdidsDetailsPanelVM udidsVM) {
        Map<String, OrganizationRelatedCostCodePropertiesVM> uidToRelatedCostCodesProperties = OrganizationUdidsTileIbeHelper.getRelatedCostCodesPropertiesVM(udidsVM).stream().collect(Collectors.toMap(OrganizationRelatedCostCodePropertiesVM::getUid, vm -> vm, (first, second) -> first));
        VMHelper.transfer((Collection)model.getCostCodeProperties(), (Collection)udidsVM.getExtraParameters(), vm -> new OrganizationUdidDetailsVM(), (modelCostCodeProperties, vm) -> {
            List modelCostCodes = model.getCostCodes().stream().filter(modelCostCode -> modelCostCodeProperties.equals((Object)modelCostCode.getCostCodeProperties())).collect(Collectors.toList());
            VMHelper.transfer(modelCostCodes, (Collection)vm.getUdidValues(), modelCostCode -> new OrganizationUdidValueVM(), (modelCostCode, vmCostCode) -> {
                vmCostCode.getRelatedCostCodeProperties().clear();
                modelCostCode.getRelatedCostCodeProperties().stream().map(ccp -> (OrganizationRelatedCostCodePropertiesVM)uidToRelatedCostCodesProperties.get(ccp.getUid())).forEach(vmCostCode.getRelatedCostCodeProperties()::add);
            });
        });
    }

    static void fromVM(OrganizationUdidsDetailsPanelVM udidsVM, Organization model) {
        VMHelper.transfer((Collection)udidsVM.getExtraParameters(), (Collection)model.getCostCodeProperties(), vm -> new CostCodeProperties(), (vm, modelCostCodeProperties) -> {});
        model.getCostCodeProperties().forEach(properties -> {
            List modelCostCodes = model.getCostCodes().stream().filter(modelCostCode -> properties.equals((Object)modelCostCode.getCostCodeProperties())).collect(Collectors.toList());
            OrganizationUdidDetailsVM udidDetailsVM = udidsVM.getExtraParameters().stream().filter(vm -> TextUtil.equals((String)vm.getUid(), (String)properties.getUid(), (boolean)false)).findFirst().orElse(null);
            if (udidDetailsVM == null) {
                return;
            }
            VMHelper.transfer((Collection)udidDetailsVM.getUdidValues(), modelCostCodes, vmCostCode -> new CostCode(), (vmCostCode, modelCostCode) -> {
                modelCostCode.getRelatedCostCodeProperties().clear();
                vmCostCode.getRelatedCostCodeProperties().stream().filter(Objects::nonNull).map(rvm -> model.getCostCodeProperties().stream().filter(ccp -> TextUtil.equals((String)ccp.getUid(), (String)rvm.getUid(), (boolean)false)).findFirst().orElse(null)).filter(Objects::nonNull).forEach(modelCostCode.getRelatedCostCodeProperties()::add);
            });
        });
    }

    static List<OrganizationRelatedCostCodePropertiesVM> getRelatedCostCodesPropertiesVM(OrganizationUdidsDetailsPanelVM udidsVM) {
        return udidsVM.getExtraParameters().stream().map(vm -> {
            String number = MiscUtil.toString((Object)vm.getUdidType().getNumberHidden());
            String categoryName = MiscUtil.toString((Object)vm.getUdidType().getCategoryHidden());
            String caption = TextUtil.nonBlankStr((String)number) + (TextUtil.nonBlank((String)categoryName) ? " (" + categoryName + ")" : "");
            OrganizationRelatedCostCodePropertiesVM result = new OrganizationRelatedCostCodePropertiesVM();
            result.setUid(vm.getUid());
            result.setCaption(caption);
            return result;
        }).collect(Collectors.toList());
    }
}

