/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccPanelController;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccsTableItemVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.RulesWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.gds.rules.FilteringCategories;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;

public class GdsSalesPointHandlerConfigurator
implements SalesPointHandlerConfigurator {
    private final Collection<RuleFilteringCategory> ruleFilteringCategoriesRegular = new ArrayList<RuleFilteringCategory>();
    private final Collection<RuleFilteringCategory> ruleFilteringCategoriesPrivileged = new ArrayList<RuleFilteringCategory>();

    public GdsSalesPointHandlerConfigurator() {
        block6: for (FilteringCategories filteringCategories : FilteringCategories.values()) {
            switch (filteringCategories) {
                case INTERNAL_GDS: 
                case SUBSIDIZED_TARIFFS: 
                case ADDITIONAL_PARAMETERS: 
                case SEARCH_PCC_SETTINGS: 
                case BOOKING_PCC_SETTINGS: {
                    this.ruleFilteringCategoriesPrivileged.add((RuleFilteringCategory)filteringCategories);
                    continue block6;
                }
                default: {
                    this.ruleFilteringCategoriesRegular.add((RuleFilteringCategory)filteringCategories);
                }
            }
        }
        block7: for (FilteringCategories filteringCategories : com.gridnine.xtrip.common.pg.rules.FilteringCategories.values()) {
            switch (3.$SwitchMap$com$gridnine$xtrip$common$pg$rules$FilteringCategories[filteringCategories.ordinal()]) {
                case 1: {
                    this.ruleFilteringCategoriesPrivileged.add((RuleFilteringCategory)filteringCategories);
                    continue block7;
                }
                default: {
                    this.ruleFilteringCategoriesRegular.add((RuleFilteringCategory)filteringCategories);
                }
            }
        }
    }

    public void configureController(List<BiConsumer<DataTransferPackage<SalesPoint, Void>, SalesPointSpaceVM>> toVM, List<BiConsumer<SalesPointSpaceVM, DataTransferPackage<SalesPoint, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<SalesPointPccPanelVM, SalesPointPccPanelController>(){

            protected Class<SalesPointPccPanelController> getControllerClass() {
                return SalesPointPccPanelController.class;
            }

            protected void onCreate(SalesPointPccPanelController controller) {
                controller.getView().getGdsAccountNode().setListParametersSupplier(() -> {
                    IndexListParameters result = new IndexListParameters();
                    result.setIndexType(GdsAccountIndex.class);
                    ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.gds.name()});
                    ListParametersHelper.setFilters((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.gds.name()});
                    return result;
                });
            }
        });
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<SalesPointSpaceVM, SalesPointSpaceController>(){

            protected Class<SalesPointSpaceController> getControllerClass() {
                return SalesPointSpaceController.class;
            }

            protected void onCreate(SalesPointSpaceController controller) {
                boolean privilegedGroup = Prefetched.getData().getCurrentAgentData().isPrivilegedGroup();
                RulesViewConfiguration config = new RulesViewConfiguration();
                config.getFilters().addAll(Arrays.asList(StandardFilters.TEXT, StandardFilters.ACTUAL_ONLY));
                for (SalesPointHandlerConfigurator configurator : ClientRegistry.get().allOf(SalesPointHandlerConfigurator.TYPE).values()) {
                    config.getCategories().addAll(configurator.getRuleFilteringCategoriesRegular());
                    if (!privilegedGroup) continue;
                    config.getCategories().addAll(configurator.getRuleFilteringCategoriesPrivileged());
                }
                RulesWidgetHelper.initTile((Tile)controller.getView().getRulesTile(), (RulesViewConfiguration)config);
            }
        });
        toVM.add((dtp, vm) -> {
            SalesPoint model = (SalesPoint)dtp.getContainer().getEntity();
            VMHelper.transfer((Collection)model.getPccs(), (Collection)vm.getPccsFull(), pcc -> new SalesPointPccsTableItemVM(), (pcc, pccVm) -> pccVm.getFullData().setGdsAccount(pcc.getGdsAccount()));
            VMHelper.copy((BaseEntity)model.getRuleSet(), (BaseEntity)vm.getRulesFull());
            vm.getOverview().setRulesCount(vm.getRulesFull() == null ? 0 : vm.getRulesFull().getRules().size());
        });
        fromVM.add((vm, dtp) -> {
            SalesPoint model = (SalesPoint)dtp.getContainer().getEntity();
            VMHelper.transfer((Collection)vm.getPccsFull(), (Collection)model.getPccs(), pccVm -> new Pcc(), (pccVm, pcc) -> pcc.setGdsAccount(pccVm.getFullData().getGdsAccount()));
            if (model.getRuleSet() == null) {
                model.setRuleSet(new RuleSet());
            }
            VMHelper.copy((BaseEntity)vm.getRulesFull(), (BaseEntity)model.getRuleSet());
        });
    }

    public Collection<RuleFilteringCategory> getRuleFilteringCategoriesRegular() {
        return this.ruleFilteringCategoriesRegular;
    }

    public Collection<RuleFilteringCategory> getRuleFilteringCategoriesPrivileged() {
        return this.ruleFilteringCategoriesPrivileged;
    }
}

