/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.gds.entity.handlers.controllerinterceptors.SpecialTariffControllerInterceptor;
import com.gridnine.xtrip.client.fx.gds.model.SpecialTariffContainer;
import com.gridnine.xtrip.client.fx.gds.model.SpecialTariffContainerController;
import com.gridnine.xtrip.client.fx.gds.model.SpecialTariffContainerVM;
import com.gridnine.xtrip.client.fx.gds.model.SpecialTariffGDSAccountsVM;
import com.gridnine.xtrip.client.fx.gds.model.SpecialTariffPassengerTypesVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.gds.SpecialTariffIndex;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class SpecialTariffHandler
extends BaseRootEntityHandler<SpecialTariff, Void, SpecialTariffContainerVM, SpecialTariffContainer> {
    protected void configureController(List<BiConsumer<DataTransferPackage<SpecialTariff, Void>, SpecialTariffContainerVM>> toVM, List<BiConsumer<SpecialTariffContainerVM, DataTransferPackage<SpecialTariff, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new SpecialTariffControllerInterceptor());
        toVM.add((dtp, vm) -> {
            SpecialTariff model = (SpecialTariff)dtp.getContainer().getEntity();
            vm.setAirline(model.getAirline());
            vm.setBeginDate(DateUtils.asLocalDateTime((Date)model.getStartDate()));
            vm.setEndDate(DateUtils.asLocalDateTime((Date)model.getEndDate()));
            vm.setDescription(model.getDescription());
            vm.setEndorsement(model.getEndorsement());
            vm.setExcludeTaxes(model.isExcludeTaxes());
            vm.setName(model.getName());
            vm.setRoute(model.getRoute());
            vm.setResidentCountry(model.getResidentCountry());
            vm.setOnlyForResidents(model.getResidentCountry() != null);
            vm.getGdsAccounts().clear();
            model.getGdsAccounts().forEach(acc -> {
                SpecialTariffGDSAccountsVM gdsVM = new SpecialTariffGDSAccountsVM();
                gdsVM.setGdsAccount(acc);
                vm.getGdsAccounts().add(gdsVM);
            });
            vm.getPassengerTypes().clear();
            model.getPassengerTypes().forEach(type -> {
                SpecialTariffPassengerTypesVM passVM = new SpecialTariffPassengerTypesVM();
                passVM.setPassengerType(type);
                vm.getPassengerTypes().add(passVM);
            });
        });
        fromVM.add((vm, dtp) -> {
            SpecialTariff model = (SpecialTariff)dtp.getContainer().getEntity();
            model.setAirline(vm.getAirline());
            model.setStartDate(DateUtils.asDate((LocalDateTime)vm.getBeginDate()));
            model.setEndDate(DateUtils.asDate((LocalDateTime)vm.getEndDate()));
            model.setDescription(vm.getDescription());
            model.setEndorsement(vm.getEndorsement());
            model.setExcludeTaxes(vm.isExcludeTaxes());
            model.setName(vm.getName());
            model.setRoute(vm.getRoute());
            model.setResidentCountry(vm.getResidentCountry());
            model.getGdsAccounts().clear();
            vm.getGdsAccounts().forEach(acc -> model.getGdsAccounts().add(acc.getGdsAccount()));
            model.getPassengerTypes().clear();
            vm.getPassengerTypes().forEach(passenger -> model.getPassengerTypes().add(passenger.getPassengerType()));
        });
    }

    protected ViewController<SpecialTariffContainer, SpecialTariffContainerVM> createSpaceController(boolean readonly) {
        return new SpecialTariffContainerController(readonly);
    }

    protected SpecialTariffContainerVM createVM() {
        return new SpecialTariffContainerVM();
    }

    public Class<SpecialTariff> getEntityClass() {
        return SpecialTariff.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return SpecialTariffIndex.class;
    }
}

