/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers.gdsbookabilityitem;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.gds.model.GdsBookabilityItemContainerController;
import com.gridnine.xtrip.client.fx.gds.model.GdsBookabilityItemContainerVM;
import com.gridnine.xtrip.client.fx.gds.model.GdsBookabilityItemMain;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.scene.Node;
import javafx.util.StringConverter;

class GdsBookabilityItemControllerInterceptor
extends ControllerInterceptor<GdsBookabilityItemContainerVM, GdsBookabilityItemContainerController> {
    private static final StringConverter<FlightSegment> FLIGHT_CONVERTER = new StringConverter<FlightSegment>(){

        public String toString(FlightSegment object) {
            ArrayList<String> result = new ArrayList<String>();
            if (object.getFlightNumber() != null) {
                result.add(object.getFlightNumber());
            }
            if (object.getLocationBegin() != null && object.getLocationBegin().getCode() != null) {
                result.add(object.getLocationBegin().getCode());
            }
            if (object.getLocationEnd() != null && object.getLocationEnd().getCode() != null) {
                result.add(object.getLocationEnd().getCode());
            }
            if (object.getOperatingAirline() != null && object.getOperatingAirline().getCode() != null) {
                result.add(object.getOperatingAirline().getCode());
            }
            return String.join((CharSequence)" - ", result);
        }

        public FlightSegment fromString(String string) {
            return null;
        }
    };

    GdsBookabilityItemControllerInterceptor() {
    }

    protected Class<GdsBookabilityItemContainerController> getControllerClass() {
        return GdsBookabilityItemContainerController.class;
    }

    protected void onCreate(final GdsBookabilityItemContainerController controller) {
        super.onCreate((ViewController)controller);
        Card mainCard = controller.getView().getMainCard();
        final TextFieldWidget readonlyNode = ((GdsBookabilityItemMain)mainCard.getContent()).getReadonlyNode();
        mainCard.getActions().add((Object)new CardAction<GdsBookabilityItemMain>(){

            public String getName(Card<GdsBookabilityItemMain> card) {
                return "\u0412\u044b\u0431\u043e\u0440 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430";
            }

            public String getDescription(Card<GdsBookabilityItemMain> card) {
                return "\u0412\u044b\u0431\u043e\u0440 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430";
            }

            public double getWeight() {
                return 0.0;
            }

            public boolean isEnabled(Card<GdsBookabilityItemMain> card) {
                return !readonlyNode.getViewState().isReadonly();
            }

            public void execute(Card<GdsBookabilityItemMain> card, boolean alt) {
                ComboBoxWidget widget = new ComboBoxWidget(false);
                widget.setNoNulls(true);
                widget.setConverter(FLIGHT_CONVERTER);
                List segments = GdsBookabilityItemControllerInterceptor.this.getSegments(controller.getData().getFlight());
                if (!segments.isEmpty()) {
                    widget.setValue(segments.get(0));
                }
                widget.setItemsSupplier(() -> segments);
                new Dialog().setTitle("\u0412\u044b\u0431\u043e\u0440 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430").setBody((Node)widget).setExpandToParent(false).addButton(DialogButtonStyle.DECLINE, "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c").addButton(DialogButtonStyle.ACCEPT_CONTINUE, "\u0412\u044b\u0431\u0440\u0430\u0442\u044c", () -> {
                    FlightSegment segment = (FlightSegment)widget.getValue();
                    if (segment != null) {
                        GdsBookabilityItemMain container = (GdsBookabilityItemMain)controller.getView().getMainCard().getContent();
                        container.getDepartureLocationNode().setValue(segment.getLocationBegin());
                        container.getArrivalLocationNode().setValue(segment.getLocationEnd());
                        container.getAirlineNode().setValue(segment.getAirline());
                        container.getDateBeginNode().setValue(DateUtils.asLocalDateTime((Date)segment.getDateBegin()));
                        container.getDateEndNode().setValue(DateUtils.asLocalDateTime((Date)segment.getDateEnd()));
                    }
                }).show((Node)controller.getView());
            }
        });
        ((GdsBookabilityItemMain)mainCard.getContent()).getReadonlyCell().setHidden(true);
        readonlyNode.getViewState().stateProperty().addListener((s, o, n) -> mainCard.revalidateActions());
    }

    private List<FlightSegment> getSegments(String item) {
        ArrayList<FlightSegment> segments = new ArrayList<FlightSegment>();
        Flight flight = new Flight();
        try {
            XUtil.fromString((String)item, (XSerializable)flight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (FlightSegmentTariff tariff : flight.getSegmentTariffs()) {
            segments.addAll(tariff.getSegments());
        }
        return segments;
    }
}

