/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers.gdsbookabilityitem;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.gds.entity.handlers.gdsbookabilityitem.GdsBookabilityItemControllerInterceptor;
import com.gridnine.xtrip.client.fx.gds.entity.handlers.gdsbookabilityitem.GdsBookabilityItemHandlerConfigurator;
import com.gridnine.xtrip.client.fx.gds.model.GdsBookabilityItemContainerVM;
import com.gridnine.xtrip.client.fx.gds.model.GdsBookabilityItemMainVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.gds.model.GdsBookabilityItem;
import com.gridnine.xtrip.common.xml.XUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import org.w3c.dom.Element;

public class StandardGdsBookabilityItemHandlerConfigurator
implements GdsBookabilityItemHandlerConfigurator {
    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<GdsBookabilityItem, Void>, GdsBookabilityItemContainerVM>> toVM, List<BiConsumer<GdsBookabilityItemContainerVM, DataTransferPackage<GdsBookabilityItem, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new GdsBookabilityItemControllerInterceptor());
        toVM.add((dtp, vm) -> {
            GdsBookabilityItem model = (GdsBookabilityItem)dtp.getContainer().getEntity();
            GdsBookabilityItemMainVM mainVM = vm.getMain();
            mainVM.setGds(model.getGds());
            mainVM.setDate(DateUtils.asLocalDateTime((Date)model.getDate()));
            mainVM.setDateBegin(DateUtils.asLocalDateTime((Date)model.getDateBegin()));
            mainVM.setDateEnd(DateUtils.asLocalDateTime((Date)model.getDateEnd()));
            mainVM.setDepartureLocation(model.getDepartureLocation());
            mainVM.setArrivalLocation(model.getArrivalLocation());
            mainVM.setAirline(model.getAirline());
            mainVM.setDescription(model.getDescription());
            vm.setFlight(StandardGdsBookabilityItemHandlerConfigurator.getFlightData(model.getFlightData()));
            vm.setTrace(StandardGdsBookabilityItemHandlerConfigurator.getTraceData(model.getTraceData()));
        });
        fromVM.add((vm, dtp) -> {
            GdsBookabilityItem model = (GdsBookabilityItem)dtp.getContainer().getEntity();
            GdsBookabilityItemMainVM mainVM = vm.getMain();
            model.setGds(mainVM.getGds());
            model.setDate(DateUtils.asDate((LocalDateTime)mainVM.getDate()));
            model.setDateBegin(DateUtils.asDate((LocalDateTime)mainVM.getDateBegin()));
            model.setDateEnd(DateUtils.asDate((LocalDateTime)mainVM.getDateEnd()));
            model.setDepartureLocation(mainVM.getDepartureLocation());
            model.setArrivalLocation(mainVM.getArrivalLocation());
            model.setAirline(mainVM.getAirline());
            model.setDescription(mainVM.getDescription());
        });
    }

    public static String getFlightData(byte[] flightData) {
        String flightXml = null;
        if (flightData != null) {
            try {
                Element flightEl = XUtil.fromBytes((byte[])flightData);
                flightXml = XUtil.toString((Element)flightEl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flightXml;
    }

    public static String getTraceData(byte[] data) {
        String traceXml = null;
        try {
            Element traceEl = XUtil.fromBytes((byte[])data);
            traceXml = XUtil.toString((Element)traceEl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return traceXml;
    }
}

