/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.png.PngCompressor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JDeli {
    private static final Color BACKGROUND_COLOR = new Color(84, 130, 31);
    private static final Color FOREGROUND_COLOR = Color.WHITE;
    private static final Font FONT = new Font("SansSerif", 1, 13);

    private static void doAction(String string, String[] stringArray) {
        Action action;
        try {
            action = Action.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            action = null;
        }
        if (action == null) {
            System.out.println("JDeli action '" + string + "' not recognised. Available actions are: " + Arrays.toString((Object[])Action.values()));
        } else {
            switch (action) {
                case COMPRESSPNG: {
                    PngCompressor.main(stringArray);
                }
            }
        }
    }

    private static String[] removeFirstValue(String[] stringArray) {
        int n = stringArray.length - 1;
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 1, stringArray2, 0, n);
        return stringArray2;
    }

    private static JLabel getStyledLabel(JLabel jLabel) {
        jLabel.setFont(FONT);
        jLabel.setForeground(FOREGROUND_COLOR);
        return jLabel;
    }

    private static void showHelpWindow() {
        final JFrame jFrame = new JFrame("JDeli - Java Decoding and Encoding Library for Images");
        jFrame.setSize(440, 400);
        jFrame.setDefaultCloseOperation(3);
        final JPanel jPanel = new JPanel();
        jPanel.setBackground(BACKGROUND_COLOR);
        jPanel.setLayout(new GridLayout(0, 1));
        ImageIcon imageIcon = new ImageIcon(JDeli.class.getClass().getResource("/com/idrsolutions/image/res/logo.png"));
        JLabel jLabel = new JLabel(imageIcon);
        jFrame.getContentPane().add((Component)jLabel, "North");
        jPanel.add(JDeli.getStyledLabel(new JLabel(" JDeli - Java Decoding and Encoding Library for Images")));
        jPanel.add(JDeli.getStyledLabel(new JLabel(" ")));
        jPanel.add(JDeli.getStyledLabel(new JLabel(" Features: ")));
        jPanel.add(JDeli.getStyledLabel(new JLabel("          TiffEncoder (Single/Multi Page)")));
        jPanel.add(JDeli.getStyledLabel(new JLabel("          TiffDecoder (Single/Multi Page)")));
        jPanel.add(JDeli.getStyledLabel(new JLabel("          PngEncoder")));
        jPanel.add(JDeli.getStyledLabel(new JLabel("          PngCompressor")));
        jPanel.add(JDeli.getStyledLabel(new JLabel("          JpegEncoder")));
        jPanel.add(JDeli.getStyledLabel(new JLabel("          JpegDecoder")));
        jPanel.add(JDeli.getStyledLabel(new JLabel("          Jpeg2000Decoder")));
        jPanel.add(JDeli.getStyledLabel(new JLabel(" ")));
        final JLabel jLabel2 = new JLabel("<html>&nbsp;Homepage: https://www.idrsolutions.com/jdeli</html>");
        jLabel2.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(12));
                jLabel2.setText("<html>&nbsp;Homepage: <u>https://www.idrsolutions.com/jdeli</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(0));
                jLabel2.setText("<html>&nbsp;Homepage: https://www.idrsolutions.com/jdeli</html>");
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli"));
                }
                catch (IOException iOException) {
                    JDeli.writeLog("Exception: " + iOException.getMessage());
                }
                catch (URISyntaxException uRISyntaxException) {
                    JDeli.writeLog("Exception: " + uRISyntaxException.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        jPanel.add(JDeli.getStyledLabel(jLabel2));
        final JLabel jLabel3 = new JLabel("<html>&nbsp;License: https://www.idrsolutions.com/jdeli/license</html>");
        jLabel3.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(12));
                jLabel3.setText("<html>&nbsp;License: <u>https://www.idrsolutions.com/jdeli/license</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(0));
                jLabel3.setText("<html>&nbsp;License: https://www.idrsolutions.com/jdeli/license</html>");
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli/license"));
                }
                catch (URISyntaxException uRISyntaxException) {
                    JDeli.writeLog("Exception: " + uRISyntaxException.getMessage());
                }
                catch (IOException iOException) {
                    JDeli.writeLog("Exception :" + iOException.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        jPanel.add(JDeli.getStyledLabel(jLabel3));
        final JLabel jLabel4 = new JLabel("<html>&nbsp;Javadoc: https://files.idrsolutions.com/jdeli-javadoc/</html>");
        jLabel4.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(12));
                jLabel4.setText("<html>&nbsp;Javadoc: <u>https://files.idrsolutions.com/jdeli-javadoc/</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(0));
                jLabel4.setText("<html>&nbsp;Javadoc: https://files.idrsolutions.com/jdeli-javadoc/</html>");
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Desktop.getDesktop().browse(new URI("https://files.idrsolutions.com/jdeli-javadoc/"));
                }
                catch (IOException iOException) {
                    JDeli.writeLog("Exception: " + iOException.getMessage());
                }
                catch (URISyntaxException uRISyntaxException) {
                    JDeli.writeLog("Exception: " + uRISyntaxException.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        jPanel.add(JDeli.getStyledLabel(jLabel4));
        jPanel.add(JDeli.getStyledLabel(new JLabel(" ")));
        jPanel.add(JDeli.getStyledLabel(new JLabel(" Available command line arguments are: " + Arrays.toString((Object[])Action.values()))));
        jPanel.add(JDeli.getStyledLabel(new JLabel(" ")));
        jFrame.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(BACKGROUND_COLOR);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        jButton.setSize(150, 75);
        jButton.setMaximumSize(new Dimension(150, 75));
        jPanel2.add(jButton);
        jFrame.getContentPane().add((Component)jPanel2, "South");
        jFrame.setVisible(true);
        jFrame.setLocationRelativeTo(null);
        jFrame.setResizable(false);
    }

    private static void writeLog(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            JDeli.showHelp();
        } else {
            JDeli.doAction(stringArray[0], JDeli.removeFirstValue(stringArray));
        }
    }

    private static void showHelp() {
        String string = "JDeli - Java Decoding and Encoding Library for Images\n\nFeatures:\n\tTiffEncoder (Single/Multi Page)\n\tTiffDecoder (Single/Multi Page)\n\tPngEncoder\n\tPngCompressor\n\tJpegEncoder\n\tJpegDecoder\n\tJpeg2000Decoder\n\nHomepage: https://www.idrsolutions.com/jdeli\nLicense: https://www.idrsolutions.com/jdeli/license\nJavadoc: https://files.idrsolutions.com/jdeli-javadoc/\n\nAvailable command line arguments are: " + Arrays.toString((Object[])Action.values());
        if (System.console() != null) {
            System.out.println(string);
        } else if (!GraphicsEnvironment.isHeadless()) {
            JDeli.showHelpWindow();
        }
    }

    private static enum Action {
        COMPRESSPNG;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

