/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.parser.DecoderOptions;

public class FunctionContext
implements PaintContext {
    final GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private final PDFFunction[] function;
    private final int pageHeight;
    private final boolean colorsReversed;
    private int xstart;
    private int ystart;

    FunctionContext(int n, float f, GenericColorSpace genericColorSpace, boolean bl, PDFFunction[] pDFFunctionArray) {
        this.colorsReversed = bl;
        this.pageHeight = n;
        this.shadingColorSpace = genericColorSpace;
        this.function = pDFFunctionArray;
        this.scaling = f;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        this.xstart = n;
        this.ystart = n2;
        int[] nArray = new int[n3 * n4 * 4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5;
                int n6;
                int n7;
                Color color = this.calculateColor(j, i);
                if (this.colorsReversed) {
                    n7 = 255 - color.getRed();
                    n6 = 255 - color.getGreen();
                    n5 = 255 - color.getBlue();
                } else {
                    n7 = color.getRed();
                    n6 = color.getGreen();
                    n5 = color.getBlue();
                }
                int n8 = (i * n3 + j) * 4;
                nArray[n8] = n7;
                nArray[n8 + 1] = n6;
                nArray[n8 + 2] = n5;
                nArray[n8 + 3] = 255;
            }
        }
        WritableRaster writableRaster = new BufferedImage(n3, n4, 2).getRaster();
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private Color calculateColor(float f, float f2) {
        float f3;
        float f4;
        if (DecoderOptions.isRunningOnMac) {
            f4 = this.scaling * (f + (float)this.xstart);
            f3 = this.scaling * (f2 + (float)this.ystart);
        } else {
            f4 = this.scaling * (f + (float)this.xstart);
            f3 = this.scaling * ((float)this.pageHeight - (f2 + (float)this.ystart));
        }
        float[] fArray = new float[]{f4, f3};
        float[] fArray2 = ShadingFactory.applyFunctions(this.function, fArray);
        int n = fArray2.length;
        this.shadingColorSpace.setColor(fArray2, n);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }
}

