/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.AxialContext;
import com.idrsolutions.pdf.color.shading.CoonsContext;
import com.idrsolutions.pdf.color.shading.FreeFormContext;
import com.idrsolutions.pdf.color.shading.FunctionContext;
import com.idrsolutions.pdf.color.shading.LatticeFormContext;
import com.idrsolutions.pdf.color.shading.RadialContext;
import com.idrsolutions.pdf.color.shading.Shape67;
import com.idrsolutions.pdf.color.shading.TensorContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;

public class ShadedPaint
implements PdfPaint,
Paint,
Serializable {
    public static final int FUNCTION = 1;
    public static final int AXIAL = 2;
    public static final int RADIAL = 3;
    public static final int FREEFORM = 4;
    public static final int LATTICEFORM = 5;
    public static final int COONS = 6;
    public static final int TENSOR = 7;
    private static final boolean debug = false;
    private int renderingType = 3;
    protected PDFFunction[] function;
    protected GenericColorSpace shadingColorSpace;
    private PdfObject Shading;
    protected float[] coords;
    protected int shadingType;
    protected float[] domain = new float[]{0.0f, 1.0f};
    private int type;
    private boolean[] isExtended = new boolean[2];
    private boolean colorsReversed;
    public float scaling;
    public int cropX;
    public int textX;
    public int textY;
    public int cropH;
    private float[] background;
    public boolean isPrinting;
    private boolean isFromSH;
    private HashMap patchShades;
    float[][] matrix;
    private float[][] CTM;
    private ArrayList<Shape67> shapesList = new ArrayList();

    public ShadedPaint(PdfObject pdfObject, boolean bl, GenericColorSpace genericColorSpace, PdfObjectReader pdfObjectReader, float[][] fArray, boolean bl2, float[][] fArray2, boolean bl3) {
        this.isPrinting = bl;
        this.colorsReversed = bl2;
        this.type = pdfObject.getInt(1487255197);
        this.CTM = fArray2;
        this.matrix = fArray;
        this.isFromSH = bl3;
        this.init(pdfObject, genericColorSpace, pdfObjectReader, fArray);
    }

    public ShadedPaint() {
    }

    private void init(PdfObject pdfObject, GenericColorSpace genericColorSpace, PdfObjectReader pdfObjectReader, float[][] fArray) {
        Object object;
        boolean[] blArray = pdfObject.getBooleanArray(1144345468);
        if (blArray != null) {
            this.isExtended = blArray;
        }
        this.shadingColorSpace = genericColorSpace;
        this.Shading = pdfObject;
        this.shadingType = pdfObject.getInt(1487255197);
        this.background = pdfObject.getFloatArray(1921025959);
        PdfObject pdfObject2 = pdfObject.getDictionary(1518239089);
        byte[][] byArray = pdfObject.getKeyArray(1518239089);
        if (pdfObject2 != null) {
            this.function = new PDFFunction[1];
            this.function[0] = FunctionFactory.getFunction(pdfObject2, pdfObjectReader);
        } else if (byArray != null) {
            int n = 0;
            if (byArray != null) {
                n = byArray.length;
            }
            if (byArray != null) {
                int n2;
                PdfObject[] pdfObjectArray = new PdfObject[n];
                for (n2 = 0; n2 < n; ++n2) {
                    String string = new String(byArray[n2]);
                    if (string.startsWith("<<")) {
                        object = new FunctionObject(1);
                        ObjectDecoder objectDecoder = new ObjectDecoder(pdfObjectReader.getObjectReader());
                        objectDecoder.readDictionaryAsObject((PdfObject)object, 0, byArray[n2]);
                    } else {
                        object = new FunctionObject(string);
                        pdfObjectReader.readObject((PdfObject)object);
                    }
                    pdfObjectArray[n2] = object;
                }
                this.function = new PDFFunction[pdfObjectArray.length];
                int n3 = pdfObjectArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.function[n2] = FunctionFactory.getFunction(pdfObjectArray[n2], pdfObjectReader);
                }
            }
        }
        float[] fArray2 = pdfObject.getFloatArray(1026641277);
        if (fArray2 != null) {
            this.domain = fArray2;
        }
        if ((object = pdfObject.getFloatArray(1061308290)) != null) {
            int n = ((float[])object).length;
            this.coords = new float[n];
            System.arraycopy(object, 0, this.coords, 0, n);
            if (fArray != null) {
                float f = fArray[0][0];
                float f2 = fArray[0][1];
                float f3 = fArray[1][0];
                float f4 = fArray[1][1];
                float f5 = fArray[2][0];
                float f6 = fArray[2][1];
                if (this.type == 2) {
                    float f7 = this.coords[0];
                    float f8 = this.coords[1];
                    float f9 = this.coords[2];
                    float f10 = this.coords[3];
                    this.coords[0] = f * f7 + f3 * f8 + f5;
                    this.coords[1] = f2 * f7 + f4 * f8 + f6;
                    this.coords[2] = f * f9 + f3 * f10 + f5;
                    this.coords[3] = f2 * f9 + f4 * f10 + f6;
                }
            } else if (this.type == 2 && DecoderOptions.isRunningOnMac && this.coords[1] > this.coords[3]) {
                this.colorsReversed = true;
            }
        }
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        PaintContext paintContext;
        int n;
        int n2;
        if (!this.isPrinting) {
            n2 = (int)(affineTransform.getTranslateX() + (double)this.cropX - (double)((float)this.textX * this.scaling));
            n = (int)(affineTransform.getTranslateY() - (double)this.cropH + (double)((float)this.textY * this.scaling));
        } else {
            n2 = (int)affineTransform.getTranslateX();
            n = (int)affineTransform.getTranslateY();
            this.scaling = (float)affineTransform.getScaleY();
        }
        switch (this.type) {
            case 1: {
                paintContext = new FunctionContext(this.cropH, (float)(1.0 / affineTransform.getScaleX()), this.shadingColorSpace, this.colorsReversed, this.function);
                break;
            }
            case 2: {
                paintContext = new AxialContext(affineTransform, this.renderingType, this.isPrinting, n2, n, this.cropX, this.cropH, 1.0f / this.scaling, this.isExtended, this.domain, this.coords, this.shadingColorSpace, this.colorsReversed, this.background, this.function);
                break;
            }
            case 3: {
                paintContext = new RadialContext(affineTransform, this.isPrinting, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.function);
                break;
            }
            case 4: {
                paintContext = new FreeFormContext(this.shadingColorSpace, null, this.Shading, this.matrix, this.cropH, this.scaling, n2, n);
                break;
            }
            case 5: {
                paintContext = new LatticeFormContext(this.shadingColorSpace, null, this.Shading, this.matrix, this.cropH, this.scaling, n2, n);
                break;
            }
            case 6: {
                if (!this.shapesList.isEmpty()) {
                    paintContext = new CoonsContext(affineTransform, this.shapesList, this.background, this.cropH, 1.0f / this.scaling, n2, n);
                    break;
                }
                CoonsContext coonsContext = new CoonsContext(affineTransform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.cropH, 1.0f / this.scaling, n2, n, this.function);
                this.shapesList = coonsContext.getShapes();
                paintContext = coonsContext;
                break;
            }
            case 7: {
                if (!this.shapesList.isEmpty()) {
                    paintContext = new TensorContext(affineTransform, this.shapesList, this.background, this.cropH, 1.0f / this.scaling, n2, n);
                    break;
                }
                TensorContext tensorContext = new TensorContext(affineTransform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.cropH, 1.0f / this.scaling, n2, n, this.function);
                this.shapesList = tensorContext.getShapes();
                paintContext = tensorContext;
                break;
            }
            default: {
                paintContext = null;
            }
        }
        return paintContext;
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public void setScaling(double d, double d2, float f, float f2, float f3) {
        this.scaling = f;
        this.cropX = (int)d;
        this.cropH = (int)d2;
        this.textX = (int)f2;
        this.textY = (int)f3;
    }

    @Override
    public boolean isPattern() {
        return true;
    }

    @Override
    public int getRGB() {
        return 0;
    }

    @Override
    public void setRenderingType(int n) {
        this.renderingType = n;
    }

    @Override
    public boolean isTexture() {
        return false;
    }
}

