/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;

public class CalRGBColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4569336292751894930L;
    private int r;
    private int g;
    private int b;
    private static final double cs00 = 3.240449;
    private static final double cs01 = -1.537136;
    private static final double cs02 = -0.498531;
    private static final double cs10 = -0.969265;
    private static final double cs11 = 1.876011;
    private static final double cs12 = 0.041556;
    private static final double cs20 = 0.055643;
    private static final double cs21 = -0.204026;
    private static final double cs22 = 1.057229;
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;

    public CalRGBColorSpace(float[] fArray, float[] fArray2, float[] fArray3) {
        this.cs = ColorSpace.getInstance(1001);
        this.setCIEValues(fArray, null, fArray2, fArray3);
        this.setType(1008872003);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = n * n2;
        for (int i = 0; i < n3 * 3; i += 3) {
            float f = byArray[i] & 0xFF;
            float f2 = byArray[i + 1] & 0xFF;
            float f3 = byArray[i + 2] & 0xFF;
            this.convertToRGB(f, f2, f3);
            byArray[i] = (byte)this.r;
            byArray[i + 1] = (byte)this.g;
            byArray[i + 2] = (byte)this.b;
        }
        return byArray;
    }

    @Override
    public final BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        byArray = this.dataToRGBByteArray(byArray, n, n2, false);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int[] nArray = new int[]{0, 1, 2};
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    @Override
    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    @Override
    public final void reset() {
        this.lastC = -255.0f;
        this.lastI = -255.0f;
        this.lastE = -255.0f;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.currentColor = new PdfColor(0, 0, 0);
    }

    @Override
    public final void setColor(float[] fArray, int n) {
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f};
        if (n == 3) {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = fArray[i];
                if (!(fArray2[i] > 1.0f)) continue;
                return;
            }
            this.convertToRGB(fArray2[0], fArray2[1], fArray2[2]);
            this.currentColor = new PdfColor(this.r, this.g, this.b);
        } else if (n == 1 && this.getIndexedMap() != null) {
            int n2 = (int)(fArray[0] * 3.0f);
            byte[] byArray = this.getIndexedMap();
            fArray2[0] = (float)(byArray[n2] & 0xFF) / 255.0f;
            fArray2[1] = (float)(byArray[n2 + 1] & 0xFF) / 255.0f;
            fArray2[2] = (float)(byArray[n2 + 2] & 0xFF) / 255.0f;
            this.convertToRGB(fArray2[0], fArray2[1], fArray2[2]);
            this.currentColor = new PdfColor(this.r, this.g, this.b);
        }
    }

    private void convertToRGB(float f, float f2, float f3) {
        if (this.lastC != f || this.lastI != f2 || this.lastE != f3) {
            double d = Math.pow(f, this.G[0]);
            double d2 = Math.pow(f2, this.G[1]);
            double d3 = Math.pow(f3, this.G[2]);
            double d4 = (double)this.Ma[0] * d + (double)this.Ma[3] * d2 + (double)this.Ma[6] * d3;
            double d5 = (double)this.Ma[1] * d + (double)this.Ma[4] * d2 + (double)this.Ma[7] * d3;
            double d6 = (double)this.Ma[2] * d + (double)this.Ma[5] * d2 + (double)this.Ma[8] * d3;
            double d7 = 3.240449 * d4 + -1.537136 * d5 + -0.498531 * d6;
            double d8 = -0.969265 * d4 + 1.876011 * d5 + 0.041556 * d6;
            double d9 = 0.055643 * d4 + -0.204026 * d5 + 1.057229 * d6;
            double d10 = 1.0 / (3.240449 * (double)this.W[0] + -1.537136 * (double)this.W[1] + -0.498531 * (double)this.W[2]);
            double d11 = 1.0 / (-0.969265 * (double)this.W[0] + 1.876011 * (double)this.W[1] + 0.041556 * (double)this.W[2]);
            double d12 = 1.0 / (0.055643 * (double)this.W[0] + -0.204026 * (double)this.W[1] + 1.057229 * (double)this.W[2]);
            this.r = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(d7 * d10), 0.5));
            this.g = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(d8 * d11), 0.5));
            this.b = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(d9 * d12), 0.5));
            this.lastC = f;
            this.lastI = f2;
            this.lastE = f3;
        }
    }

    static double clip(double d) {
        if (d > 1.0) {
            return 1.0;
        }
        return d;
    }
}

