/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private final int[] a1;
    private final int[] b1;
    private final int[] c1;
    private final Map cache = new HashMap();
    private float[] prevFloat;

    @Override
    public void reset() {
        super.reset();
        this.isConverted = false;
    }

    public ICCColorSpace(PdfObject pdfObject) {
        this.a1 = new int[256];
        this.b1 = new int[256];
        this.c1 = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.a1[i] = -1;
            this.b1[i] = -1;
            this.c1[i] = -1;
        }
        this.setType(1247168582);
        this.cs = ColorSpace.getInstance(1000);
        byte[] byArray = pdfObject.getDecodedStream();
        if (byArray == null) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error in ICC data");
            }
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(byArray));
                this.type = this.cs.getType();
            }
            catch (Exception exception) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
                }
                this.failed = true;
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    @Override
    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    private static boolean isSame(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return false;
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setColor(float[] fArray, int n) {
        if (ICCColorSpace.isSame(this.prevFloat, fArray)) {
            return;
        }
        float[] fArray2 = this.cs.toRGB(fArray);
        this.currentColor = new PdfColor(fArray2[0], fArray2[1], fArray2[2]);
        this.prevFloat = (float[])fArray.clone();
    }

    @Override
    public byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        if (this.componentCount == 4) {
            return this.convert4Index(byArray);
        }
        return byArray;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        if (byArray.length > 9 && byArray[6] == 74 && byArray[7] == 70 && byArray[8] == 73 && byArray[9] == 70) {
            return this.nonRGBJPEGToRGBImage(byArray, n, n2, null, n3, n4);
        }
        return this.algorithmicICCToRGB(byArray, n, n2, n3, n4, fArray);
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, int n5) throws PdfException {
        byte[] byArray2 = this.getIndexedMap();
        if (this.cs.getNumComponents() == 3 || byArray2 != null) {
            return super.JPEG2000ToRGBImage(byArray, n, n2, fArray, n3, n4, n5);
        }
        return this.JPEG2000ToImage(byArray, n3, n4, fArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage algorithmicICCToRGB(byte[] byArray, int n, int n2, int n3, int n4, float[] fArray) {
        BufferedImage bufferedImage = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            Object object;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(imageReader = (object = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            object = imageReader.readRaster(0, null);
            if (imageReader.getRawImageType(0) == null || this.alternative == -1) {
                BufferedImage bufferedImage2 = this.nonRGBJPEGToRGBImage(byArray, n, n2, fArray, n3, n4);
                return bufferedImage2;
            }
            object = ICCColorSpace.cleanupRaster((Raster)object, n3, n4, this.componentCount);
            n = ((Raster)object).getWidth();
            n2 = ((Raster)object).getHeight();
            byte[] byArray2 = new byte[n * n2 * 3];
            byArray = ((DataBufferByte)((Raster)object).getDataBuffer()).getData();
            int n5 = n * n2 * 3;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n6 = 0;
            float f4 = -1.0f;
            float f5 = -1.0f;
            float f6 = -1.0f;
            for (int i = 0; i < n5; i += 3) {
                float f7 = (float)(byArray[i] & 0xFF) / 255.0f;
                float f8 = (float)(byArray[1 + i] & 0xFF) / 255.0f;
                float f9 = (float)(byArray[2 + i] & 0xFF) / 255.0f;
                if (f4 != f7 || f5 != f8 || f6 != f9) {
                    float[] fArray2 = new float[]{f7, f8, f9};
                    float[] fArray3 = this.cs.toRGB(fArray2);
                    f = fArray3[0] * 255.0f;
                    f2 = fArray3[1] * 255.0f;
                    f3 = fArray3[2] * 255.0f;
                    f4 = f7;
                    f5 = f8;
                    f6 = f9;
                }
                byArray2[n6++] = (byte)f;
                byArray2[n6++] = (byte)f2;
                byArray2[n6++] = (byte)f3;
            }
            int[] nArray = new int[]{0, 1, 2};
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem with color conversion " + exception);
            }
        }
        finally {
            block20: {
                try {
                    byteArrayInputStream.close();
                    imageReader.dispose();
                    imageInputStream.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block20;
                    LogWriter.writeLog("Problem closing  " + exception);
                }
            }
        }
        return bufferedImage;
    }
}

