/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Point;

public class DisplayOffsets {
    protected boolean dragLeft;
    protected boolean dragTop;
    private int userOffsetX;
    private int userOffsetY;
    private int userPrintOffsetX;
    private int userPrintOffsetY;
    private int facingCursorX = 10000;
    private int facingCursorY = 10000;

    public void setUserOffsets(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 0: {
                this.userOffsetX = n;
                this.userOffsetY = n2;
                break;
            }
            case 1: {
                this.userPrintOffsetX = n;
                this.userPrintOffsetY = -n2;
                break;
            }
            case 995: {
                this.facingCursorX = 0;
                this.facingCursorY = n3;
                this.setDragCorner(n4);
                break;
            }
            case 998: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                this.setDragCorner(n4);
                break;
            }
            case 999: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                this.setDragCorner(n4);
                break;
            }
            case 996: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                this.setDragCorner(n4);
                break;
            }
            case 997: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                this.setDragCorner(n4);
                break;
            }
            default: {
                throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
            }
        }
    }

    public Point getUserOffsets(int n) {
        switch (n) {
            case 0: {
                return new Point(this.userOffsetX, this.userOffsetY);
            }
            case 1: {
                return new Point(this.userPrintOffsetX, this.userPrintOffsetY);
            }
            case 999: {
                return new Point(this.facingCursorX, this.facingCursorY);
            }
        }
        throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
    }

    public int getUserPrintOffsetX() {
        return this.userPrintOffsetX;
    }

    public int getUserPrintOffsetY() {
        return this.userPrintOffsetY;
    }

    public int getUserOffsetX() {
        return this.userOffsetX;
    }

    public int getUserOffsetY() {
        return this.userOffsetY;
    }

    public void setDragCorner(int n) {
        this.dragLeft = n == 998 || n == 996 || n == 995;
        this.dragTop = n == 996 || n == 997;
    }

    public boolean getDragLeft() {
        return this.dragLeft;
    }

    public boolean getDragTop() {
        return this.dragTop;
    }
}

