/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javafx.scene.layout.Pane;
import org.jpedal.display.Display;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.ScalingFactory;

public class GUIDisplay
implements Display {
    protected int lastFormPage = -1;
    protected int lastStart = -1;
    protected int lastEnd = -1;
    protected int pageUsedForTransform;
    protected int lastIndent = -1;
    protected double indent;
    public RenderChangeListener customRenderChangeListener;
    public int rx;
    public int ry;
    public int rw;
    public int rh;
    public DecoderOptions options;
    public static boolean allowChangeCursor = true;
    public final MultiDisplayOptions multiDisplayOptions = new MultiDisplayOptions();
    public static boolean default_turnoverOn = true;
    public static boolean default_separateCover = true;
    public DynamicVectorRenderer currentDisplay;
    public boolean isInitialised;
    public boolean overRideAcceleration;
    public boolean useAcceleration = true;
    public boolean ignoreScalingForAcceleration;
    public boolean accelerationAlwaysRedraw;
    public PageOffsets currentOffset;
    private int[] highlightedImage;
    protected GUIThumbnailPanel thumbnails;
    public int[] pageOffsetH;
    public int[] pageOffsetW;
    public boolean[] isRotated;
    public int topW;
    public int topH;
    public double cropX;
    public double cropY;
    public double cropW;
    public double cropH;
    public int crx;
    public int cry;
    public int crw;
    public int crh;
    public int displayRotation;
    public int displayView = 1;
    public int lastDisplayRotation;
    public int insetW;
    public int insetH;
    public float scaling;
    public float lastScaling;
    public int pageNumber;
    public float oldScaling = -1.0f;
    public float oldRotation = -1.0f;
    public PdfPageData pageData;
    @Deprecated
    public static int CURRENT_BORDER_STYLE = 1;
    protected double[] displayScalingDbl;

    @Override
    public int getYCordForPage(int n, float f) {
        if (f == -2.0f || f != -1.0f && f != this.oldScaling) {
            this.oldScaling = f;
            this.setPageOffsets(n);
        }
        return this.getYCordForPage(n);
    }

    @Override
    public boolean getBoolean(Display.BoolValue boolValue) {
        switch (boolValue) {
            case SEPARATE_COVER: {
                return this.multiDisplayOptions.isSeparateCover();
            }
            case TURNOVER_ON: {
                return this.multiDisplayOptions.isTurnoverOn();
            }
        }
        return false;
    }

    @Override
    public void setBoolean(Display.BoolValue boolValue, boolean bl) {
        switch (boolValue) {
            case SEPARATE_COVER: {
                this.multiDisplayOptions.setSeparateCover(bl);
                return;
            }
            case TURNOVER_ON: {
                this.multiDisplayOptions.setTurnoverOn(bl);
                return;
            }
        }
    }

    @Override
    public void setObjectValue(int n, Object object) {
        switch (n) {
            case 21: {
                this.customRenderChangeListener = (RenderChangeListener)object;
                break;
            }
            default: {
                throw new RuntimeException("setObjectValue does not take value " + n);
            }
        }
    }

    @Override
    public void setCursorBoxOnScreen(Rectangle rectangle, boolean bl) {
    }

    @Override
    public int[] getPageSize(int n) {
        int n2;
        int n3;
        int[] nArray = new int[2];
        int n4 = 0;
        int n5 = 0;
        if (n == 4 && this.multiDisplayOptions.getPageW() != null) {
            if (this.multiDisplayOptions.isSeparateCover()) {
                n3 = this.pageNumber;
                if ((n3 & 1) == 1) {
                    --n3;
                }
                n2 = n3 + 1;
            } else {
                n3 = this.pageNumber;
                if ((n3 & 1) == 0) {
                    --n3;
                }
                n2 = n3 + 1;
            }
            if (n3 == 0) {
                n4 = this.multiDisplayOptions.getPageH(n2);
                n5 = this.multiDisplayOptions.getPageW(n2) * 2;
            } else {
                n4 = this.multiDisplayOptions.getPageH(n3);
                if (n2 < this.multiDisplayOptions.getPageH().length) {
                    if (n4 < this.multiDisplayOptions.getPageH(n2)) {
                        n4 = this.multiDisplayOptions.getPageH(n2);
                    }
                    n5 = this.multiDisplayOptions.getPageW(n3) + this.multiDisplayOptions.getPageW(n2);
                } else {
                    n5 = this.multiDisplayOptions.getPageW(n3) * 2;
                }
            }
        }
        n3 = this.currentOffset.getGaps();
        n2 = this.currentOffset.getDoubleGaps();
        switch (n) {
            case 4: {
                nArray[0] = n5 + this.insetW + this.insetW;
                nArray[1] = n4 + this.insetH + this.insetH;
                break;
            }
            case 2: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    nArray[0] = (int)((float)this.currentOffset.getBiggestHeight() * this.scaling) + this.insetW + this.insetW;
                    nArray[1] = (int)((float)this.currentOffset.getTotalSingleWidth() * this.scaling) + n3 + this.insetH + this.insetH;
                    break;
                }
                nArray[0] = (int)((float)this.currentOffset.getBiggestWidth() * this.scaling) + this.insetW + this.insetW;
                nArray[1] = (int)((float)this.currentOffset.getTotalSingleHeight() * this.scaling) + n3 + this.insetH + this.insetH;
                break;
            }
            case 3: {
                int n6 = this.pageData.getPageCount();
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    if (n6 == 2) {
                        nArray[0] = (int)((float)this.currentOffset.getDoublePageHeight() * this.scaling) + this.insetW + this.insetW;
                        nArray[1] = (int)((float)this.currentOffset.getBiggestWidth() * this.scaling) + n3 + this.insetH + this.insetH;
                        break;
                    }
                    nArray[0] = (int)((float)this.currentOffset.getDoublePageHeight() * this.scaling) + this.insetW + this.insetW;
                    nArray[1] = (int)((float)this.currentOffset.getTotalDoubleWidth() * this.scaling) + n2 + this.insetH + this.insetH;
                    break;
                }
                if (n6 == 2) {
                    nArray[0] = (int)((float)this.currentOffset.getDoublePageWidth() * this.scaling) + this.insetW + this.insetW;
                    nArray[1] = (int)((float)this.currentOffset.getBiggestHeight() * this.scaling) + n3 + this.insetH + this.insetH;
                    break;
                }
                nArray[0] = (int)((float)this.currentOffset.getDoublePageWidth() * this.scaling) + this.insetW + this.insetW;
                nArray[1] = (int)((float)this.currentOffset.getTotalDoubleHeight() * this.scaling) + n2 + this.insetH + this.insetH;
            }
        }
        return nArray;
    }

    @Override
    public void setup(boolean bl, PageOffsets pageOffsets) {
        this.useAcceleration = bl;
        this.currentOffset = pageOffsets;
        this.overRideAcceleration = false;
    }

    @Override
    public void setAcceleration(boolean bl) {
        this.useAcceleration = bl;
    }

    @Override
    public void setAccelerationAlwaysRedraw(boolean bl) {
        this.accelerationAlwaysRedraw = bl;
    }

    public void setPageSize(int n, float f) {
        this.pageData.setScalingValue(f);
        this.topW = this.pageData.getScaledCropBoxWidth(n);
        this.topH = this.pageData.getScaledCropBoxHeight(n);
        double d = this.pageData.getScaledMediaBoxHeight(n);
        this.cropX = this.pageData.getScaledCropBoxX(n);
        this.cropY = this.pageData.getScaledCropBoxY(n);
        this.cropW = this.topW;
        this.cropH = this.topH;
        if (this.displayView == 1) {
            this.crx = (int)((double)this.insetW + this.cropX);
            this.cry = (int)((double)this.insetH - this.cropY);
        } else {
            this.crx = this.insetW;
            this.cry = this.insetH;
        }
        int n2 = (int)(d - this.cropH);
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            this.crw = (int)this.cropH;
            this.crh = (int)this.cropW;
            int n3 = this.crx;
            this.crx = this.cry;
            this.cry = n3;
            this.crx += n2;
        } else {
            this.crw = (int)this.cropW;
            this.crh = (int)this.cropH;
            this.cry += n2;
        }
    }

    @Override
    public void decodeOtherPages(int n, int n2) {
    }

    @Override
    public void disableScreen() {
        this.isInitialised = false;
        this.oldScaling = -1.0f;
    }

    @Override
    public float getOldScaling() {
        return this.oldScaling;
    }

    @Override
    public void refreshDisplay() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void flushPageCaches() {
    }

    @Override
    public void init(float f, int n, int n2, DynamicVectorRenderer dynamicVectorRenderer, boolean bl) {
        if (n2 < 1) {
            n2 = 1;
        }
        if (dynamicVectorRenderer != null) {
            this.currentDisplay = dynamicVectorRenderer;
        }
        this.scaling = f;
        this.displayRotation = n;
        this.pageNumber = n2;
        this.insetW = this.options.getInsetW();
        this.insetH = this.options.getInsetH();
        if (dynamicVectorRenderer != null) {
            dynamicVectorRenderer.setInset(this.insetW, this.insetH);
        }
        this.pageData.setScalingValue(f);
        if (bl) {
            this.setPageOffsets(this.pageNumber);
            this.isInitialised = true;
        }
        this.lastScaling = f;
    }

    @Override
    public void setThumbnailPanel(GUIThumbnailPanel gUIThumbnailPanel) {
        this.thumbnails = gUIThumbnailPanel;
    }

    @Override
    public void stopGeneratingPage() {
        this.multiDisplayOptions.setIsGeneratingOtherPages(false);
        this.multiDisplayOptions.waitToDieThred();
    }

    @Override
    public int getYCordForPage(int n) {
        int[] nArray = this.multiDisplayOptions.getyReached();
        if (nArray != null) {
            return nArray[n] + this.insetH;
        }
        return this.insetH;
    }

    public int getStartPage() {
        return this.multiDisplayOptions.getStartViewPage();
    }

    public int getEndPage() {
        return this.multiDisplayOptions.getEndViewPage();
    }

    @Override
    public void setScaling(float f) {
        this.scaling = f;
        if (this.pageData != null) {
            this.pageData.setScalingValue(f);
        }
    }

    @Override
    public void setHighlightedImage(int[] nArray) {
        this.highlightedImage = nArray;
    }

    @Override
    public int[] getHighlightedImage() {
        return this.highlightedImage;
    }

    @Override
    public int getXCordForPage(int n) {
        int[] nArray = this.multiDisplayOptions.getxReached();
        if (nArray != null) {
            return nArray[n] + this.insetW;
        }
        return this.insetW;
    }

    @Override
    public void setPageOffsets(int n) {
        int n2 = this.pageData.getPageCount();
        this.multiDisplayOptions.resetValues(n2);
        this.pageOffsetW = new int[n2 + 1];
        this.pageOffsetH = new int[n2 + 1];
        this.isRotated = new boolean[n2 + 1];
        int n3 = 10;
        if (this.multiDisplayOptions.isTurnoverOn() && n2 != 2 && !this.pageData.hasMultipleSizes() && this.displayView == 4) {
            n3 = 0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int[] nArray = this.multiDisplayOptions.getPageW();
        int[] nArray2 = this.multiDisplayOptions.getPageH();
        for (int i = 1; i < n2 + 1; ++i) {
            nArray[i] = this.pageData.getScaledCropBoxWidth(i);
            nArray2[i] = this.pageData.getScaledCropBoxHeight(i);
            int n8 = this.pageData.getRotation(i) + this.displayRotation;
            if (n8 >= 360) {
                n8 -= 360;
            }
            if (n8 == 90 || n8 == 270) {
                int n9 = nArray[i];
                nArray[i] = nArray2[i];
                nArray2[i] = n9;
                this.isRotated[i] = true;
            }
            if ((i & 1) == 1) {
                if (nArray[i] > n6) {
                    n6 = nArray[i];
                }
                if (nArray2[i] <= n7) continue;
                n7 = nArray2[i];
                continue;
            }
            if (this.multiDisplayOptions.getPageW(i) > n4) {
                n4 = this.multiDisplayOptions.getPageW(i);
            }
            if (nArray2[i] <= n5) continue;
            n5 = nArray2[i];
        }
        int[] nArray3 = this.multiDisplayOptions.getxReached();
        int[] nArray4 = this.multiDisplayOptions.getyReached();
        for (int i = 1; i < n2 + 1; ++i) {
            int n10 = 0;
            if (n2 == 2 && (this.displayView == 4 || this.displayView == 3) || this.displayView == 4 && !this.multiDisplayOptions.isSeparateCover()) {
                if ((i & 1) == 1) {
                    nArray3[i] = 0;
                    nArray4[i] = 0;
                    continue;
                }
                nArray3[i] = nArray3[i - 1] + nArray[i - 1] + n3;
                nArray4[i] = 0;
                if (i == 2 && this.pageData.getRotation(1) == 270) continue;
                this.pageOffsetW[2] = nArray[2] - nArray[1] + this.pageOffsetW[1];
                this.pageOffsetH[2] = nArray2[2] - nArray2[1] + this.pageOffsetH[1];
                continue;
            }
            if (i == 1) {
                if (this.displayView == 2) {
                    nArray3[1] = 0;
                    nArray4[1] = 0;
                    this.pageOffsetW[1] = 0;
                    this.pageOffsetH[1] = 0;
                    this.pageOffsetW[0] = n3;
                    this.pageOffsetH[0] = n3;
                    continue;
                }
                if (this.displayView == 3) {
                    this.pageOffsetW[0] = n3;
                    this.pageOffsetH[0] = n3;
                    this.pageOffsetW[1] = 0;
                    this.pageOffsetH[1] = 0;
                    nArray3[1] = n4 + n3;
                    nArray4[1] = 0;
                    continue;
                }
                if (this.displayView != 4) continue;
                nArray3[1] = nArray[1] + n3;
                nArray4[1] = 0;
                continue;
            }
            if (this.displayView == 3) {
                if (i < 2 || (this.pageData.getRotation(i) != 270 && this.pageData.getRotation(i) != 90 || this.pageData.getRotation(i - 1) == 270 && this.pageData.getRotation(i - 1) == 90) && (this.pageData.getRotation(i - 1) != 270 && this.pageData.getRotation(i - 1) != 90 || this.pageData.getRotation(i) == 270 && this.pageData.getRotation(i) == 90)) {
                    this.pageOffsetW[i] = nArray[i] - nArray[i - 1] + this.pageOffsetW[i - 1];
                    this.pageOffsetH[i] = nArray2[i] - nArray2[i - 1] + this.pageOffsetH[i - 1];
                }
                if ((i & 1) == 0) {
                    int n11;
                    if (i < n2) {
                        n10 = (nArray2[i + 1] - nArray2[i]) / 2;
                    }
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    if (i > 3 && (n11 = (nArray2[i - 2] - nArray2[i - 1]) / 2) > 0) {
                        n10 += n11;
                    }
                    nArray4[i] = nArray4[i - 1] + nArray2[i - 1] + n3 + n10;
                } else {
                    n10 = (nArray2[i - 1] - nArray2[i]) / 2;
                    nArray4[i] = nArray4[i - 1] + n10;
                }
                if ((i & 1) == 0) {
                    int n12 = i;
                    nArray3[n12] = nArray3[n12] + (n4 - nArray[i]);
                    continue;
                }
                nArray3[i] = nArray3[i - 1] + nArray[i - 1] + n3;
                continue;
            }
            if (this.displayView == 2) {
                nArray4[i] = nArray4[i - 1] + nArray2[i - 1] + n3;
                if (i >= 2 && ((this.pageData.getRotation(i) == 270 || this.pageData.getRotation(i) == 90) && (this.pageData.getRotation(i - 1) != 270 || this.pageData.getRotation(i - 1) != 90) || (this.pageData.getRotation(i - 1) == 270 || this.pageData.getRotation(i - 1) == 90) && (this.pageData.getRotation(i) != 270 || this.pageData.getRotation(i) != 90))) continue;
                this.pageOffsetW[i] = nArray[i] - nArray[i - 1] + this.pageOffsetW[i - 1];
                this.pageOffsetH[i] = nArray2[i] - nArray2[i - 1] + this.pageOffsetH[i - 1];
                continue;
            }
            if (this.displayView != 4) continue;
            if ((i & 1) == 1) {
                nArray3[i] = nArray3[i - 1] + nArray[i - 1] + n3;
                if (nArray2[i] >= nArray2[i - 1]) continue;
                int n13 = i;
                nArray4[n13] = nArray4[n13] + (nArray2[i - 1] - nArray2[i]) / 2;
                continue;
            }
            nArray3[i] = 0;
            if (i >= n2 || nArray2[i] >= nArray2[i + 1]) continue;
            int n14 = i;
            nArray4[n14] = nArray4[n14] + (nArray2[i + 1] - nArray2[i]) / 2;
        }
    }

    @Override
    public void dispose() {
        this.currentOffset = null;
        this.multiDisplayOptions.setPageValuesToNull();
        this.isRotated = null;
    }

    @Override
    public Rectangle getCursorBoxOnScreen() {
        throw new UnsupportedOperationException("Please use public int[] getCursorBoxOnScreenAsArray() instead");
    }

    @Override
    public int[] getCursorBoxOnScreenAsArray() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getIndent() {
        return this.indent;
    }

    @Override
    public void forceRedraw() {
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
    }

    @Override
    public void setPageRotation(int n) {
        if (this.displayView != 1) {
            n = 0;
        }
        this.pageUsedForTransform = this.pageNumber;
        this.displayScalingDbl = this.displayView != 1 && this.displayView != 4 ? ScalingFactory.getScalingForImage(1, 0, this.scaling, this.pageData) : ScalingFactory.getScalingForImage(this.pageNumber, n, this.scaling, this.pageData);
        int n2 = this.options.getInsetW();
        int n3 = this.options.getInsetH();
        if (n == 90) {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)n2 / this.scaling) * this.displayScalingDbl[1];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)n3 / this.scaling) * this.displayScalingDbl[2];
        } else if (n == 270) {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)(-n2) / this.scaling) * this.displayScalingDbl[1];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)(-n3) / this.scaling) * this.displayScalingDbl[2];
        } else if (n == 180) {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)(-n2) / this.scaling) * this.displayScalingDbl[0];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)n3 / this.scaling) * this.displayScalingDbl[3];
        } else {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)n2 / this.scaling) * this.displayScalingDbl[0];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)(-n3) / this.scaling) * this.displayScalingDbl[3];
        }
        this.refreshDisplay();
    }

    @Override
    public void resetViewableArea() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void paintPage(Graphics2D graphics2D, AcroRenderer acroRenderer, TextLines textLines) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCursorBoxOnScreen(Rectangle rectangle, Color color, int n, int n2, int n3) {
        throw new UnsupportedOperationException("please use updateCursorBoxOnScreen(int[] newOutlineRectangle, int outlineColor, int pageNumber,int x_size,int y_size) instead");
    }

    @Override
    public void updateCursorBoxOnScreen(int[] nArray, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void drawCursor(Graphics graphics, float f) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AffineTransform setViewableArea(Rectangle rectangle) throws PdfException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AffineTransform setViewableArea(int[] nArray) throws PdfException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void drawFacing(Rectangle rectangle) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void paintPage(Pane pane, AcroRenderer acroRenderer, TextLines textLines) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCurrentDisplay(DynamicVectorRenderer dynamicVectorRenderer) {
        this.currentDisplay = dynamicVectorRenderer;
    }

    public int getDisplayRotation() {
        return this.displayRotation;
    }

    public int getRx() {
        return this.rx;
    }

    public int getRy() {
        return this.ry;
    }

    public int getRw() {
        return this.rw;
    }

    public int getRh() {
        return this.rh;
    }

    public int getInsetW() {
        return this.insetW;
    }

    public int getInsetH() {
        return this.insetH;
    }

    @Override
    public Rectangle getDisplayedRectangle() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Rectangle getDisplayedRectangle(boolean bl, Rectangle rectangle) {
        this.rx = rectangle.x;
        this.ry = rectangle.y;
        this.rw = rectangle.width;
        this.rh = rectangle.height;
        if (!(bl || this.rw != 0 && this.rh != 0)) {
            this.rx = 0;
            this.ry = 0;
            this.rw = this.pageData.getScaledCropBoxWidth(this.pageNumber);
            this.rh = this.pageData.getScaledCropBoxHeight(this.pageNumber);
            if (this.pageData.getRotation(this.pageNumber) % 180 != 0) {
                this.rh = this.pageData.getScaledCropBoxWidth(this.pageNumber);
                this.rw = this.pageData.getScaledCropBoxHeight(this.pageNumber);
            }
        }
        return rectangle;
    }
}

