/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;

public class PdfUtilities {
    PdfFileInformation currentFileInformation;
    byte[] byteArray;
    boolean isOpen;
    boolean hasEmbeddedFonts;
    boolean testIfFontsEmbedded;
    int maxCount = -1;
    private int lastPage = -1;
    PdfPageData currentPageData;
    String imageType = "png";
    String name = "image";
    String user_dir = System.getProperty("user.dir");
    PdfDecoderInt decode_pdf;
    static final String separator = System.getProperty("file.separator");
    String password;
    String fileName;

    public PdfUtilities(String string) {
        this.fileName = string;
        this.init();
    }

    public PdfUtilities(byte[] byArray) {
        this.byteArray = byArray;
        this.init();
    }

    public void setPassword(String string) {
        this.password = string;
    }

    void init() {
        FontMappings.setFontReplacements();
        try {
            Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception loading resource bundle");
        }
        this.decode_pdf = new PdfDecoderServer(false);
    }

    void selectPage(int n) throws PdfException {
        if (n != this.lastPage) {
            this.currentPageData = this.decode_pdf.getPdfPageData();
            this.decode_pdf.flushObjectValues(true);
            try {
                this.decode_pdf.decodePage(n);
            }
            catch (Exception exception) {
                throw new PdfException(exception.getMessage());
            }
            this.lastPage = n;
        }
    }

    public int getPageCount() {
        return this.decode_pdf.getPageCount();
    }

    public boolean openPDFFile() throws PdfException {
        int n;
        this.isOpen = false;
        this.lastPage = -1;
        if (this.fileName != null && (n = this.fileName.lastIndexOf(separator)) != -1) {
            this.name = this.fileName.substring(n + 1, this.fileName.length() - 4);
        }
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                if (this.password != null) {
                    throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
                }
                this.isOpen = true;
            } else {
                this.isOpen = true;
                this.currentFileInformation = this.decode_pdf.getFileInformationData();
                this.currentPageData = this.decode_pdf.getPdfPageData();
            }
        }
        catch (Exception exception) {
            throw new PdfException(exception.getMessage());
        }
        return this.isOpen;
    }

    public void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
        this.hasEmbeddedFonts = false;
        this.testIfFontsEmbedded = false;
    }

    public boolean hasEmbeddedFonts() throws Exception {
        if (!this.testIfFontsEmbedded) {
            this.testIfFontsEmbedded = true;
            int n = this.getPageCount();
            for (int i = 1; i < n + 1; ++i) {
                this.decode_pdf.decodePage(i);
                this.hasEmbeddedFonts = this.decode_pdf.hasEmbeddedFonts();
                if (!this.hasEmbeddedFonts) continue;
                i = n;
            }
        }
        return this.hasEmbeddedFonts;
    }

    public Map getDocumentPropertyStringValuesAsMap() {
        String[] stringArray = PdfFileInformation.getFieldNames();
        int n = stringArray.length;
        String[] stringArray2 = this.currentFileInformation.getFieldValues();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], stringArray2[i]);
        }
        return hashMap;
    }

    public String getDocumentPropertyFieldsInXML() {
        return this.currentFileInformation.getFileXMLMetaData();
    }

    public float[] getPageDimensions(int n, PageUnits pageUnits, PageSizeType pageSizeType) {
        float[] fArray = new float[5];
        float f = 0.0f;
        switch (pageUnits) {
            case Pixels: {
                f = 1.0f;
                break;
            }
            case Inches: {
                f = 72.0f;
                break;
            }
            case Centimetres: {
                f = 28.346457f;
            }
        }
        switch (pageSizeType) {
            case MediaBox: {
                fArray[0] = (float)this.currentPageData.getMediaBoxX(n) / f;
                fArray[1] = (float)this.currentPageData.getMediaBoxY(n) / f;
                fArray[2] = (float)this.currentPageData.getMediaBoxWidth(n) / f;
                fArray[3] = (float)this.currentPageData.getMediaBoxHeight(n) / f;
                break;
            }
            case CropBox: {
                fArray[0] = (float)this.currentPageData.getCropBoxX(n) / f;
                fArray[1] = (float)this.currentPageData.getCropBoxY(n) / f;
                fArray[2] = (float)this.currentPageData.getCropBoxWidth(n) / f;
                fArray[3] = (float)this.currentPageData.getCropBoxHeight(n) / f;
            }
        }
        fArray[4] = this.currentPageData.getRotation(n);
        return fArray;
    }

    public static enum PageSizeType {
        MediaBox,
        CropBox;

    }

    public static enum PageUnits {
        Pixels,
        Inches,
        Centimetres;

    }
}

