/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.util.ResourceBundle;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;

abstract class BaseTextExtraction {
    byte[] byteArray;
    boolean isOpen;
    int maxCount = -1;
    private int lastPage = -1;
    PdfGroupingAlgorithms currentGrouping;
    PdfPageData currentPageData;
    String output_dir;
    String imageType = "png";
    String name = "image";
    ExtractTypes type;
    String user_dir = System.getProperty("user.dir");
    PdfDecoderInt decode_pdf;
    static final String separator = System.getProperty("file.separator");
    String password;
    String fileName;

    void decodeFile(String string) throws PdfException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BaseTextExtraction(String string) {
        this.fileName = string;
    }

    public BaseTextExtraction(byte[] byArray) {
        this.byteArray = byArray;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    void init() {
        try {
            Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception loading resource bundle");
        }
        switch (this.type) {
            case FIND_TEXT_IN_RECTANGLE: {
                this.decode_pdf = new PdfDecoderServer(false);
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                break;
            }
            case OUTLINE: {
                this.decode_pdf = new PdfDecoderServer(false);
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                break;
            }
            case TEXT_IN_RECTANGLE: {
                this.decode_pdf = new PdfDecoderServer(false);
                FontMappings.setFontReplacements();
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                break;
            }
            case TEXT_AS_WORDLIST: {
                this.decode_pdf = new PdfDecoderServer(true);
                FontMappings.setFontReplacements();
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                this.decode_pdf.useTextExtraction();
                PdfGroupingAlgorithms.useUnrotatedCoords = false;
                break;
            }
            default: {
                this.decode_pdf = new PdfDecoderServer(false);
            }
        }
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
    }

    void selectPage(int n) throws PdfException {
        if (n != this.lastPage) {
            this.currentPageData = this.decode_pdf.getPdfPageData();
            this.decode_pdf.flushObjectValues(true);
            try {
                boolean bl = this.decode_pdf.getFormRenderer().getCompData().formsRasterizedForDisplay();
                this.decode_pdf.getFormRenderer().getCompData().setRasterizeForms(true);
                this.decode_pdf.decodePage(n);
                this.decode_pdf.getFormRenderer().getCompData().setRasterizeForms(bl);
            }
            catch (Exception exception) {
                throw new PdfException(exception.getMessage());
            }
            this.currentGrouping = this.decode_pdf.getGroupingObject();
            this.lastPage = n;
        }
    }

    public int getPageCount() {
        return this.decode_pdf.getPageCount();
    }

    public boolean openPDFFile() throws PdfException {
        int n;
        this.isOpen = false;
        this.lastPage = -1;
        if (this.fileName != null && (n = this.fileName.lastIndexOf(separator)) != -1) {
            this.name = this.fileName.substring(n + 1, this.fileName.length() - 4);
        }
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                if (this.password != null) {
                    throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
                }
                this.isOpen = true;
            } else {
                this.isOpen = true;
            }
        }
        catch (Exception exception) {
            throw new PdfException(exception.getMessage());
        }
        return this.isOpen;
    }

    public void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
    }

    void processFiles(String string) throws PdfException {
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string);
        } else {
            File file;
            if (!string.endsWith("\\") && !string.endsWith("/")) {
                string = string + separator;
            }
            if (!(file = new File(string)).isDirectory()) {
                throw new PdfException("No input directory " + string);
            }
            String[] stringArray = null;
            try {
                String[] stringArray2 = new File(string);
                if (!stringArray2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                } else {
                    stringArray = stringArray2.list();
                }
            }
            catch (Exception exception) {
                throw new PdfException("Exception trying to access file " + exception.getMessage());
            }
            for (String string2 : stringArray) {
                if (!string2.toLowerCase().endsWith(".pdf")) continue;
                this.fileName = string + string2;
                this.decodeFile(string + string2);
            }
        }
    }

    static enum ExtractTypes {
        FIND_TEXT_IN_RECTANGLE,
        OUTLINE,
        STRUCTURED_TEXT,
        TEXT_AS_WORDLIST,
        TEXT_IN_RECTANGLE;

    }
}

