/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Head
extends Table {
    protected int glyphDataFormat;
    protected int indexToLocFormat;
    protected float[] FontBBox = new float[4];
    protected int flags;
    protected int unitsPerEm = 1024;

    public Head(FontFile2 fontFile2) {
        int n = fontFile2.selectTable(0);
        if (n == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No head table found");
            }
        } else {
            int n2;
            fontFile2.getNextUint32();
            for (n2 = 0; n2 < 3; ++n2) {
                fontFile2.getNextUint32();
            }
            this.flags = fontFile2.getNextUint16();
            this.unitsPerEm = fontFile2.getNextUint16();
            for (n2 = 0; n2 < 2; ++n2) {
                fontFile2.getNextUint64();
            }
            for (n2 = 0; n2 < 4; ++n2) {
                this.FontBBox[n2] = fontFile2.getNextSignedInt16();
            }
            for (n2 = 0; n2 < 3; ++n2) {
                fontFile2.getNextUint16();
            }
            this.indexToLocFormat = fontFile2.getNextUint16();
            this.glyphDataFormat = fontFile2.getNextUint16();
        }
    }

    public Head() {
    }

    public int getIndexToLocFormat() {
        return this.indexToLocFormat;
    }

    public float[] getFontBBox() {
        return this.FontBBox;
    }

    public int getUnitsPerEm() {
        return this.unitsPerEm;
    }
}

