/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Hmtx
extends Table {
    private int[] hMetrics;
    private short[] leftSideBearing;
    private float scaling;

    public Hmtx(FontFile2 fontFile2, int n, int n2, int n3) {
        block11: {
            this.scaling = 0.001f;
            this.scaling = n3;
            if (n2 < 0) {
                n2 = -n2;
            }
            int n4 = fontFile2.selectTable(6);
            int n5 = n - n2;
            this.hMetrics = new int[n];
            this.leftSideBearing = new short[n];
            int n6 = 0;
            if (n4 == 0) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No Htmx table found");
                }
            } else if (n5 < 0) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Invalid Htmx table found");
                }
            } else {
                int n7;
                for (n7 = 0; n7 < n2; ++n7) {
                    this.hMetrics[n7] = n6 = fontFile2.getNextUint16();
                    this.leftSideBearing[n7] = fontFile2.getNextInt16();
                }
                int n8 = fontFile2.getTableSize(6);
                int n9 = n8 - n7 * 4;
                n5 = n9 / 2;
                try {
                    for (int i = n7; i < n5; ++i) {
                        this.hMetrics[i] = n6;
                        this.leftSideBearing[i] = fontFile2.getFWord();
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception in reading Hmtx " + exception);
                }
            }
        }
    }

    public Hmtx() {
        this.scaling = 0.001f;
    }

    public short getRAWLSB(int n) {
        if (this.leftSideBearing == null || n >= this.leftSideBearing.length) {
            return 0;
        }
        return this.leftSideBearing[n];
    }

    public short getLeftSideBearing(int n) {
        int n2 = this.hMetrics.length;
        if (n < n2) {
            return (short)(this.hMetrics[n] & 0xFFFF);
        }
        if (this.leftSideBearing == null) {
            return 0;
        }
        int n3 = n - n2;
        if (n3 >= 0 && n3 < this.leftSideBearing.length) {
            return this.leftSideBearing[n - this.hMetrics.length];
        }
        return 0;
    }

    public float getAdvanceWidth(int n) {
        return (float)(this.hMetrics[n] - this.getLeftSideBearing(n)) / this.scaling;
    }

    public float getWidth(int n) {
        float f = this.hMetrics[n];
        return f / this.scaling;
    }

    public float getUnscaledWidth(int n) {
        return this.hMetrics[n];
    }
}

