/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.BaseDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class ImageTransformerDouble {
    private static final boolean debug = false;
    double ny;
    double nx;
    private Area clip;
    private BufferedImage current_image;
    private final float[][] CTM;
    private float[][] Trm;
    private float[][] Trm1;
    private float[][] Trm2;
    private int i_x;
    private int i_y;
    private int i_w;
    private int i_h;
    private final boolean scaleImage;
    private boolean hasClip;
    float scaling = 1.0f;
    final int pageRotation;

    public ImageTransformerDouble(GraphicsState graphicsState, BufferedImage bufferedImage, boolean bl, float f, int n) {
        this.current_image = bufferedImage;
        this.scaleImage = bl;
        this.scaling = f;
        this.pageRotation = n;
        this.CTM = graphicsState.CTM;
        this.createMatrices();
        if (graphicsState.getClippingShape() != null) {
            this.clip = (Area)graphicsState.getClippingShape().clone();
        }
        this.calcCoordinates();
    }

    public final void doubleScaleTransformShear() {
        this.scale(this.Trm1);
        if (this.clip != null) {
            Area area = (Area)this.clip.clone();
            Area area2 = this.getUnscaledClip((Area)this.clip.clone());
            int n = BaseDisplay.isRectangle(area);
            this.clipImage(area2, area, n);
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = (int)(this.clip.getBounds2D().getMaxX() - (double)this.i_x);
            this.i_h = (int)(this.clip.getBounds2D().getMaxY() - (double)this.i_y);
        } else if (this.current_image.getType() != 10) {
            this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
        }
    }

    public final void doubleScaleTransformScale() {
        if ((double)this.CTM[0][0] != 0.0 & (double)this.CTM[1][1] != 0.0) {
            this.scale(this.Trm2);
        }
    }

    public final void completeImage() {
        if (this.hasClip) {
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = this.current_image.getWidth();
            this.i_h = this.current_image.getHeight();
        }
    }

    private void scale(float[][] fArray) {
        if ((double)fArray[0][0] != 1.0 || (double)fArray[1][1] != 1.0 || (double)fArray[0][1] != 0.0 || (double)fArray[1][0] != 0.0) {
            int n = this.current_image.getWidth();
            int n2 = this.current_image.getHeight();
            AffineTransform affineTransform = new AffineTransform(fArray[0][0], -fArray[0][1], -fArray[1][0], fArray[1][1], 0.0f, 0.0f);
            Area area = new Area(new Rectangle(0, 0, n, n2));
            area.transform(affineTransform);
            this.ny = area.getBounds2D().getY();
            this.nx = area.getBounds2D().getX();
            affineTransform = new AffineTransform((double)fArray[0][0], (double)(-fArray[0][1]), (double)(-fArray[1][0]), (double)fArray[1][1], -this.nx, -this.ny);
            AffineTransformOp affineTransformOp = n > 10 & n2 > 10 ? new AffineTransformOp(affineTransform, ColorSpaces.hints) : new AffineTransformOp(affineTransform, null);
            if (this.scaleImage) {
                if (n2 == 1 && fArray[0][0] == 0.0f && fArray[0][1] > 0.0f && fArray[1][0] < 0.0f && fArray[1][1] == 0.0f) {
                    BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
                    for (int i = 0; i < n; ++i) {
                        int n3 = this.current_image.getRGB(i, 0);
                        bufferedImage.setRGB(0, n - 1 - i, n3);
                    }
                    this.current_image = bufferedImage;
                } else {
                    this.current_image = affineTransformOp.filter(this.current_image, null);
                }
            }
        }
    }

    private void createMatrices() {
        int n;
        int n2;
        float f;
        float f2;
        float f3;
        int n3 = (int)((float)this.current_image.getWidth() / this.scaling);
        int n4 = (int)((float)this.current_image.getHeight() / this.scaling);
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)n3;
        this.Trm[0][1] = this.CTM[0][1] / (float)n3;
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = this.CTM[1][0] / (float)n4;
        this.Trm[1][1] = this.CTM[1][1] / (float)n4;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!((double)this.Trm[j][i] > 0.99 & this.Trm[j][i] < 1.0f)) continue;
                this.Trm[j][i] = 1.0f;
            }
        }
        this.Trm1 = new float[3][3];
        this.Trm2 = new float[3][3];
        float f4 = this.CTM[0][0];
        if (f4 < 0.0f) {
            f4 = -f4;
        }
        if ((f3 = this.CTM[0][1]) < 0.0f) {
            f3 = -f3;
        }
        if ((f2 = this.CTM[1][1]) < 0.0f) {
            f2 = -f2;
        }
        if ((f = this.CTM[1][0]) < 0.0f) {
            f = -f;
        }
        if ((double)this.CTM[0][0] == 0.0 || (double)this.CTM[1][1] == 0.0) {
            this.Trm1 = this.Trm;
        } else if ((double)this.CTM[0][1] == 0.0 && (double)this.CTM[1][0] == 0.0) {
            this.Trm1[0][0] = (float)n3 / this.CTM[0][0];
            this.Trm1[0][1] = 0.0f;
            this.Trm1[0][2] = 0.0f;
            this.Trm1[1][0] = 0.0f;
            this.Trm1[1][1] = (float)n4 / this.CTM[1][1];
            this.Trm1[1][2] = 0.0f;
            this.Trm1[2][0] = 0.0f;
            this.Trm1[2][1] = 0.0f;
            this.Trm1[2][2] = 1.0f;
            this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (!((double)this.Trm1[n][n2] > 0.99 & this.Trm1[n][n2] < 1.0f)) continue;
                    this.Trm1[n][n2] = 1.0f;
                }
            }
            if (this.Trm1[2][0] < 0.0f && this.Trm1[0][0] > 0.0f && this.CTM[0][0] < 0.0f) {
                this.Trm1[2][0] = 0.0f;
                this.Trm1[0][0] = -1.0f;
            }
            if (this.Trm1[2][1] < 0.0f && this.Trm1[1][1] > 0.0f && this.CTM[1][1] < 0.0f && this.CTM[0][0] < 0.0f) {
                this.Trm1[2][1] = 0.0f;
                this.Trm1[1][1] = -1.0f;
            }
        } else {
            this.Trm1[0][0] = f4 > f3 ? (float)n3 / this.CTM[0][0] : (float)n3 / this.CTM[0][1];
            if (this.Trm1[0][0] < 0.0f) {
                this.Trm1[0][0] = -this.Trm1[0][0];
            }
            this.Trm1[0][1] = 0.0f;
            this.Trm1[0][2] = 0.0f;
            this.Trm1[1][0] = 0.0f;
            this.Trm1[1][1] = f2 > f ? (float)n4 / this.CTM[1][1] : (float)n4 / this.CTM[1][0];
            if (this.Trm1[1][1] < 0.0f) {
                this.Trm1[1][1] = -this.Trm1[1][1];
            }
            this.Trm1[1][2] = 0.0f;
            this.Trm1[2][0] = 0.0f;
            this.Trm1[2][1] = 0.0f;
            this.Trm1[2][2] = 1.0f;
            this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (!((double)this.Trm1[n][n2] > 0.99 & this.Trm1[n][n2] < 1.0f)) continue;
                    this.Trm1[n][n2] = 1.0f;
                }
            }
        }
        this.Trm2[0][0] = f4 > f3 ? this.CTM[0][0] / (float)n3 : this.CTM[0][1] / (float)n3;
        if (this.Trm2[0][0] < 0.0f) {
            this.Trm2[0][0] = -this.Trm2[0][0];
        }
        this.Trm2[0][1] = 0.0f;
        this.Trm2[0][2] = 0.0f;
        this.Trm2[1][0] = 0.0f;
        this.Trm2[1][1] = f2 > f ? this.CTM[1][1] / (float)n4 : this.CTM[1][0] / (float)n4;
        if (this.Trm2[1][1] < 0.0f) {
            this.Trm2[1][1] = -this.Trm2[1][1];
        }
        this.Trm2[1][2] = 0.0f;
        this.Trm2[2][0] = 0.0f;
        this.Trm2[2][1] = 0.0f;
        this.Trm2[2][2] = 1.0f;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                if (!((double)this.Trm2[n][n2] > 0.99 & this.Trm2[n][n2] < 1.0f)) continue;
                this.Trm2[n][n2] = 1.0f;
            }
        }
    }

    private void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f & this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f & this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else if (this.CTM[1][0] > 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    private void clipImage(Area area, Area area2, int n) {
        double d = area2.getBounds2D().getX();
        double d2 = area2.getBounds2D().getY();
        int n2 = this.current_image.getWidth();
        int n3 = this.current_image.getHeight();
        int n4 = (int)area.getBounds().getX();
        int n5 = (int)area.getBounds().getY();
        int n6 = (int)area.getBounds().getWidth();
        int n7 = (int)area.getBounds().getHeight();
        if (n > 5) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -this.current_image.getHeight());
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            this.current_image = affineTransformOp.filter(this.current_image, null);
            Area area3 = new Area(new Rectangle(0, 0, n2, n3));
            area3.exclusiveOr(area);
            this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
            Graphics2D graphics2D = this.current_image.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fill(area3);
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.scale(1.0, -1.0);
            affineTransform2.translate(0.0, -this.current_image.getHeight());
            AffineTransformOp affineTransformOp2 = new AffineTransformOp(affineTransform2, ColorSpaces.hints);
            this.current_image = affineTransformOp2.filter(this.current_image, null);
        }
        if (!(this.CTM[1][1] < 0.0f) || this.pageRotation != 0 || !(this.CTM[0][0] > 0.0f) || this.CTM[1][0] != 0.0f || this.CTM[0][1] != 0.0f) {
            n5 = n3 - n7 - n5;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n6 -= n4;
            n4 = 0;
        }
        if (n6 > n2) {
            n6 = n2;
        }
        if (n7 > n3) {
            n7 = n3;
        }
        if (n5 + n7 > n3) {
            n7 = n3 - n5;
        }
        if (n4 + n6 > n2) {
            n6 = n2 - n4;
        }
        if (!(n7 < 1 || n6 < 1 || n4 == 0 && n5 == 0 && n6 == this.current_image.getWidth() && n7 == this.current_image.getHeight() || this.CTM[1][1] == 0.0f && this.pageRotation == 0 && this.CTM[0][0] == 0.0f && this.CTM[1][0] < 0.0f && this.CTM[0][1] > 0.0f)) {
            try {
                this.current_image = this.current_image.getSubimage(n4, n5, n6, n7);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " extracting clipped image with values x=" + n4 + " y=" + n5 + " w=" + n6 + " h=" + n7 + " from image " + this.current_image);
            }
            catch (Error error) {
                LogWriter.writeLog("Exception " + error + " extracting clipped image with values x=" + n4 + " y=" + n5 + " w=" + n6 + " h=" + n7 + " from image " + this.current_image);
            }
        }
        double d3 = (double)this.i_x > d ? (double)this.i_x : d;
        double d4 = (double)this.i_y > d2 ? (double)this.i_y : d2;
        this.i_x = (int)d3;
        this.i_y = (int)d4;
        this.i_w = n6;
        this.i_h = n7;
    }

    private Area getUnscaledClip(Area area) {
        double d = -this.CTM[2][0];
        double d2 = -this.CTM[2][1];
        if (this.CTM[1][0] < 0.0f) {
            d -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][0] < 0.0f && this.CTM[1][0] >= 0.0f) {
            d -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][1] < 0.0f) {
            d2 -= (double)this.CTM[0][1];
        }
        if (this.CTM[1][1] < 0.0f) {
            if (this.CTM[0][1] > 0.0f) {
                d2 -= (double)this.CTM[0][1];
            } else if (this.CTM[1][1] < 0.0f) {
                d2 -= (double)this.CTM[1][1];
            }
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d, d2);
        area.transform(affineTransform);
        AffineTransform affineTransform2 = new AffineTransform(1.0f / this.Trm2[0][0], 0.0f, 0.0f, 1.0f / this.Trm2[1][1], 0.0f, 0.0f);
        area.transform(affineTransform2);
        int n = (int)area.getBounds().getX();
        if (n < 0) {
            area.transform(AffineTransform.getTranslateInstance(-n, 0.0));
        }
        return area;
    }
}

