/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.idrsolutions.image.tiff.TiffDecoder;
import java.awt.image.BufferedImage;
import java.io.RandomAccessFile;

public class TiffHelper {
    private int pageCount;
    private final String file;

    public TiffHelper(String string) {
        this.file = string;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            TiffDecoder tiffDecoder = new TiffDecoder(randomAccessFile);
            this.pageCount = tiffDecoder.getPageCount();
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getTiffPageCount() {
        return this.pageCount;
    }

    public BufferedImage getImage(int n) {
        BufferedImage bufferedImage = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
            TiffDecoder tiffDecoder = new TiffDecoder(randomAccessFile);
            bufferedImage = tiffDecoder.read(n + 1);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bufferedImage;
    }
}

