/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import com.idrsolutions.pdf.color.blends.BlendMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;

public class FormRenderUtilsG2 {
    private static Color getBorderColor(FormObject formObject) {
        Color color = new Color(0, 0, 0, 0);
        if (formObject.getDictionary(7451) != null) {
            PdfObject pdfObject = formObject.getDictionary(7451);
            float[] fArray = pdfObject.getFloatArray(4627);
            color = FormObject.generateColor(fArray);
        }
        return color;
    }

    private static Color getBorderBackgroundColor(FormObject formObject) {
        Color color = new Color(0, 0, 0, 0);
        if (formObject.getDictionary(7451) != null) {
            PdfObject pdfObject = formObject.getDictionary(7451);
            float[] fArray = pdfObject.getFloatArray(4631);
            color = FormObject.generateColor(fArray);
        }
        return color;
    }

    private static void renderBorderSolid(Graphics2D graphics2D, FormObject formObject, int n, int n2, int n3) {
        graphics2D.setStroke(new BasicStroke(n2));
        graphics2D.drawRect(formObject.getBoundingRectangle().x + n2 - 1, n3 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + n2 - 1, formObject.getBoundingRectangle().width - n2 * 2 + 2, formObject.getBoundingRectangle().height - n2 * 2 + 2);
    }

    private static void renderBorderDashed(Graphics2D graphics2D, FormObject formObject, PdfArrayIterator pdfArrayIterator, int n, int n2, int n3) {
        float[] fArray = new float[]{3.0f};
        int n4 = 0;
        if (pdfArrayIterator.getTokenCount() > 0) {
            int n5 = pdfArrayIterator.getTokenCount();
            if (n5 > 0) {
                fArray = pdfArrayIterator.getNextValueAsFloatArray();
            }
            if (n5 > 1) {
                n4 = pdfArrayIterator.getNextValueAsInteger();
            }
        }
        if (fArray.length == 0) {
            graphics2D.setStroke(new BasicStroke(n2));
        } else if (fArray.length > 0) {
            graphics2D.setStroke(new BasicStroke(n2, 0, 0, 10.0f, fArray, n4));
        }
        graphics2D.drawRect(formObject.getBoundingRectangle().x + n2 - 1, n3 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + n2 - 1, formObject.getBoundingRectangle().width - n2 * 2 + 2, formObject.getBoundingRectangle().height - n2 * 2 + 2);
    }

    private static void renderBorderBeveled(Graphics2D graphics2D, FormObject formObject, Color color, int n, int n2, int n3) {
        Color color2 = graphics2D.getColor();
        int n4 = formObject.getBoundingRectangle().x;
        int n5 = n3 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height);
        int n6 = formObject.getBoundingRectangle().width;
        int n7 = formObject.getBoundingRectangle().height;
        graphics2D.setStroke(new BasicStroke(n2, 0, 0, 10.0f));
        graphics2D.drawRect(n4, n5, n6, n7);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(color.darker());
        graphics2D.fillPolygon(new int[]{++n4 + (n6 -= 2), n4 + n6, n4 + n6 - n2, n4 + n6 - n2, n4 + n2, n4}, new int[]{++n5 + (n7 -= 2), n5, n5 + n2, n5 + n7 - n2, n5 + n7 - n2, n5 + n7}, 6);
        graphics2D.setColor(color.brighter());
        graphics2D.fillPolygon(new int[]{n4, n4, n4 + n2, n4 + n2, n4 + n6 - n2, n4 + n6}, new int[]{n5, n5 + n7, n5 + n7 - n2, n5 + n2, n5 + n2, n5}, 6);
        graphics2D.setColor(color2);
    }

    private static void renderBorderInset(Graphics2D graphics2D, FormObject formObject, int n, int n2, int n3) {
        Color color = graphics2D.getColor();
        int n4 = formObject.getBoundingRectangle().x;
        int n5 = n3 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height);
        int n6 = formObject.getBoundingRectangle().width;
        int n7 = formObject.getBoundingRectangle().height;
        graphics2D.setStroke(new BasicStroke(n2));
        graphics2D.drawRect(n4, n5, n6, n7);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillPolygon(new int[]{++n4 + (n6 -= 2), n4 + n6, n4 + n6 - n2, n4 + n6 - n2, n4 + n2, n4}, new int[]{++n5 + (n7 -= 2), n5, n5 + n2, n5 + n7 - n2, n5 + n7 - n2, n5 + n7}, 6);
        graphics2D.setColor(Color.GRAY);
        graphics2D.fillPolygon(new int[]{n4, n4, n4 + n2, n4 + n2, n4 + n6 - n2, n4 + n6}, new int[]{n5, n5 + n7, n5 + n7 - n2, n5 + n2, n5 + n2, n5}, 6);
        graphics2D.setColor(color);
    }

    private static void renderBorderUnderline(Graphics2D graphics2D, FormObject formObject, int n, int n2, int n3) {
        graphics2D.setStroke(new BasicStroke(n2));
        graphics2D.drawLine(formObject.getBoundingRectangle().x + n2 - 1, n3 - formObject.getBoundingRectangle().y + n2 - 1, formObject.getBoundingRectangle().x + formObject.getBoundingRectangle().width - 1, n3 - formObject.getBoundingRectangle().y + n2 - 1);
    }

    public static int renderBorder(Graphics2D graphics2D, FormObject formObject, int n, int n2) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int n3 = 0;
        Color color = FormRenderUtilsG2.getBorderColor(formObject);
        Color color2 = FormRenderUtilsG2.getBorderBackgroundColor(formObject);
        boolean bl = false;
        if (formObject.getDictionary(4643) != null) {
            PdfObject pdfObject = formObject.getDictionary(4643);
            String string = pdfObject.getName(35);
            n3 = pdfObject.getInt(39);
            if (n3 > 0) {
                graphics2D.setColor(color);
                if (string == null || string.equals("S")) {
                    FormRenderUtilsG2.renderBorderSolid(graphics2D, formObject, n3, n, n2);
                    bl = true;
                } else if (string.equals("D")) {
                    PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(20);
                    FormRenderUtilsG2.renderBorderDashed(graphics2D, formObject, pdfArrayIterator, n3, n, n2);
                    bl = true;
                } else if (string.equals("B")) {
                    FormRenderUtilsG2.renderBorderBeveled(graphics2D, formObject, color2, n3, n, n2);
                    bl = true;
                } else if (string.equals("I")) {
                    FormRenderUtilsG2.renderBorderInset(graphics2D, formObject, n3, n, n2);
                    bl = true;
                } else if (string.equals("U")) {
                    FormRenderUtilsG2.renderBorderUnderline(graphics2D, formObject, n3, n, n2);
                    bl = true;
                }
            }
        } else if (formObject.getObjectArray(1110722433) != null) {
            throw new RuntimeException("Border Array not implemented yet");
        }
        if (!bl) {
            graphics2D.setColor(color);
            n3 = 1;
            graphics2D.setStroke(new BasicStroke(n3));
            graphics2D.drawRect(formObject.getBoundingRectangle().x + n3 - 1, n2 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + n3 - 1, formObject.getBoundingRectangle().width - n3 * 2 + 2, formObject.getBoundingRectangle().height - n3 * 2 + 2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        return n3;
    }

    public static FontMetrics renderFont(Graphics2D graphics2D, FormObject formObject, String string, int n) {
        if (formObject.getTextSize() <= 0) {
            if (!formObject.getFieldFlags()[13]) {
                float f = formObject.getBoundingRectangle().height - n * 2 - 2;
                graphics2D.setFont(formObject.getTextFont().deriveFont(f));
                FontMetrics fontMetrics = graphics2D.getFontMetrics(formObject.getTextFont().deriveFont(f));
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                float f2 = (float)((double)(formObject.getBoundingRectangle().width - n * 2 - 4) / rectangle2D.getWidth());
                float f3 = (float)((double)formObject.getBoundingRectangle().height / rectangle2D.getHeight());
                if (f2 > 1.0f && f2 > f3) {
                    f2 = f3;
                }
                if (f2 < 1.0f) {
                    graphics2D.setFont(formObject.getTextFont().deriveFont(f * f2));
                }
            } else {
                graphics2D.setFont(formObject.getTextFont().deriveFont(12.0f));
            }
        } else {
            graphics2D.setFont(formObject.getTextFont());
        }
        if (formObject.getTextColor() != null) {
            graphics2D.setColor(formObject.getTextColor());
        } else {
            graphics2D.setColor(Color.BLACK);
        }
        return graphics2D.getFontMetrics();
    }

    public static void renderComboForms(Graphics2D graphics2D, FormObject formObject, FontMetrics fontMetrics, Rectangle2D rectangle2D, int n, int n2, int n3, int n4) {
        String[] stringArray = formObject.getItemsList();
        if (stringArray != null) {
            int n5;
            int[] nArray = formObject.getIntArray(25);
            int n6 = formObject.getInt(9241);
            if (n6 < 0) {
                n6 = 0;
            }
            if (nArray != null) {
                Color color = graphics2D.getColor();
                Color color2 = new Color((float)(DecoderOptions.highlightColor.getRed() / 255), (float)(DecoderOptions.highlightColor.getGreen() / 255), (float)(DecoderOptions.highlightColor.getBlue() / 255), DecoderOptions.highlightComposite);
                graphics2D.setColor(color2);
                if (formObject.getBoundingRectangle().getHeight() < (double)(fontMetrics.getHeight() * stringArray.length)) {
                    n6 = nArray[0];
                }
                for (n5 = 0; n5 != nArray.length; ++n5) {
                    int n7 = formObject.getBoundingRectangle().x + n2;
                    int n8 = n4 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) - n2;
                    n8 += fontMetrics.getDescent();
                    graphics2D.fillRect(n7, (n8 += fontMetrics.getHeight() * (nArray[n5] - n6)) + n2, formObject.getBoundingRectangle().width - n2 * 2 + 2, fontMetrics.getHeight());
                }
                graphics2D.setColor(color);
            }
            graphics2D.setClip(new Rectangle(formObject.getBoundingRectangle().x + n2 - 1, n4 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + n2 - 1, formObject.getBoundingRectangle().width - n2 * 2 + 2, formObject.getBoundingRectangle().height - n2 * 2 + 2));
            for (int i = n6; i != stringArray.length; ++i) {
                int n9 = formObject.getBoundingRectangle().x + n2 + 2;
                n5 = n4 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + n2 + fontMetrics.getHeight() - n2;
                FormRenderUtilsG2.renderTextString(graphics2D, formObject, stringArray[i], rectangle2D, n9, n5 += fontMetrics.getHeight() * (i - n6), n2, n3);
            }
        }
    }

    public static void renderMultilineTextField(Graphics2D graphics2D, FormObject formObject, FontMetrics fontMetrics, Rectangle2D rectangle2D, String string, int n, int n2, int n3, int n4) {
        int n5 = formObject.getBoundingRectangle().x + n2;
        int n6 = n4 - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) - n2 - n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            FormRenderUtilsG2.renderTextString(graphics2D, formObject, stringTokenizer.nextToken(), rectangle2D, n5, n6 += fontMetrics.getHeight(), n2, n3);
        }
    }

    public static void renderSingleLineTextField(Graphics2D graphics2D, FormObject formObject, FontMetrics fontMetrics, Rectangle2D rectangle2D, String string, int n, int n2, int n3, int n4) {
        int n5 = formObject.getBoundingRectangle().x + n2;
        int n6 = n4 - formObject.getBoundingRectangle().y - (formObject.getBoundingRectangle().height - fontMetrics.getHeight());
        FormRenderUtilsG2.renderTextString(graphics2D, formObject, string, rectangle2D, n5, n6, n2, n3);
    }

    private static void renderTextString(Graphics2D graphics2D, FormObject formObject, String string, Rectangle2D rectangle2D, int n, int n2, int n3, int n4) {
        switch (n4) {
            case 0: {
                graphics2D.drawString(string, (int)((double)n + ((double)(formObject.getBoundingRectangle().width - n3 * 2) - rectangle2D.getWidth()) / 2.0), n2);
                break;
            }
            case 4: {
                graphics2D.drawString(string, (int)((double)(n + formObject.getBoundingRectangle().width - n3 * 2) - rectangle2D.getWidth()) - 2, n2);
                break;
            }
            default: {
                graphics2D.drawString(string, n + 2, n2);
            }
        }
    }

    public static void renderQuadPoint(Graphics2D graphics2D, FormObject formObject, Color color, int n, int n2) {
        float[] fArray = formObject.getFloatArray(1785890247);
        if (fArray != null) {
            Color color2 = graphics2D.getColor();
            Composite composite = graphics2D.getComposite();
            for (int i = 0; i != fArray.length / 8; ++i) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int j = 0; j != 8; ++j) {
                    if (j < 2) {
                        if (j % 2 == 0) {
                            f = fArray[i * 8 + j];
                            f3 = fArray[i * 8 + j];
                            continue;
                        }
                        f2 = fArray[i * 8 + j];
                        f4 = fArray[i * 8 + j];
                        continue;
                    }
                    if (j % 2 == 0) {
                        if (fArray[i * 8 + j] < f) {
                            f = fArray[i * 8 + j];
                        }
                        if (!(fArray[i * 8 + j] > f3)) continue;
                        f3 = fArray[i * 8 + j];
                        continue;
                    }
                    if (fArray[i * 8 + j] < f2) {
                        f2 = fArray[i * 8 + j];
                    }
                    if (!(fArray[i * 8 + j] > f4)) continue;
                    f4 = fArray[i * 8 + j];
                }
                if (formObject.getParameterConstant(1147962727) == 1919840408) {
                    graphics2D.setColor(color);
                    graphics2D.setComposite(new BlendMode(1451587725, 0.5f));
                    graphics2D.fillRect((int)f, (int)((float)n2 - f4), (int)(f3 - f), (int)(f4 - f2));
                }
                graphics2D.setColor(color2);
                graphics2D.setComposite(composite);
            }
        }
    }

    public static void renderPopupWindow(Graphics2D graphics2D, FormObject formObject, Color color, int n, boolean bl, int n2) {
        String string;
        int n3;
        StringTokenizer stringTokenizer;
        String string2;
        String string3;
        String string4 = formObject.getParentPdfObj().getTextStreamValue(29);
        StringBuffer stringBuffer = null;
        if (string4 != null) {
            stringBuffer = new StringBuffer(string4);
            stringBuffer.delete(0, 2);
            stringBuffer.insert(10, ':');
            stringBuffer.insert(13, ':');
            stringBuffer.insert(16, ' ');
            string3 = stringBuffer.substring(0, 4);
            string2 = stringBuffer.substring(6, 8);
            stringBuffer.delete(6, 8);
            stringBuffer.delete(0, 4);
            stringBuffer.insert(0, string2);
            stringBuffer.insert(4, string3);
            stringBuffer.insert(2, '/');
            stringBuffer.insert(5, '/');
            stringBuffer.insert(10, ' ');
        }
        string3 = formObject.getParentPdfObj().getTextStreamValue(591737402);
        string2 = formObject.getParentPdfObj().getTextStreamValue(36);
        if (string2 == null) {
            string2 = "";
        }
        String string5 = "";
        if (string3 != null) {
            string5 = string5 + string3 + '\t';
        }
        if (stringBuffer != null) {
            string5 = string5 + stringBuffer;
        }
        string5 = string5 + '\n' + string2;
        String string6 = formObject.getParentPdfObj().getTextStreamValue(1216184967);
        if (string6 == null) {
            string6 = "";
        }
        if (string6.indexOf(13) != -1) {
            string6 = string6.replaceAll("\r", "\n");
        }
        float[] fArray = formObject.getFloatArray(573911876);
        if (bl) {
            graphics2D.translate(0, 24);
        }
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect((int)fArray[0], n2 - (int)fArray[3], (int)(fArray[2] - fArray[0]), (int)(fArray[3] - fArray[1]));
        graphics2D.setColor(color);
        graphics2D.fillRect((int)fArray[0], n2 - (int)fArray[3], (int)(fArray[2] - fArray[0]), 26);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(new Font("Monospaced", 0, 12));
        graphics2D.setFont(graphics2D.getFont().deriveFont(8.0f));
        if (string5.indexOf(10) == -1) {
            graphics2D.drawString(string5, (int)fArray[0] + 2, (int)((float)(n2 - (int)fArray[3]) + graphics2D.getFont().getSize2D()) + 2);
        } else {
            stringTokenizer = new StringTokenizer(string5, "\n", true);
            n3 = 1;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!string.equals("\n")) {
                    graphics2D.drawString(string, (int)fArray[0] + 2, (int)((float)(n2 - (int)fArray[3]) + (graphics2D.getFont().getSize2D() + 2.0f) * (float)n3));
                    continue;
                }
                ++n3;
            }
        }
        graphics2D.setFont(graphics2D.getFont().deriveFont(7.0f));
        if (string6.indexOf(10) == -1) {
            graphics2D.drawString(string6, (int)fArray[0], (int)((float)(n2 - (int)fArray[3]) + graphics2D.getFont().getSize2D() + 24.0f));
        } else {
            stringTokenizer = new StringTokenizer(string6, "\n", true);
            n3 = 1;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!string.equals("\n")) {
                    graphics2D.drawString(string, (int)fArray[0] + 2, (int)((float)(n2 - (int)fArray[3]) + (graphics2D.getFont().getSize2D() + 3.0f) * (float)n3 + 24.0f));
                    continue;
                }
                ++n3;
            }
        }
    }
}

