/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.data;

import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class ImageData {
    int pX;
    int pY;
    int width;
    int height;
    int depth = 1;
    boolean imageMask;
    byte[] objectData;
    boolean isDCT;
    boolean isJPX;
    boolean isJBIG;
    private int numComponents;
    int mode;
    private boolean removed;

    public ImageData(PdfObject pdfObject, byte[] byArray, int n) {
        this.objectData = byArray;
        this.width = pdfObject.getInt(959726687);
        this.height = pdfObject.getInt(959926393);
        int n2 = pdfObject.getInt(-1344207655);
        if (n2 != -1) {
            this.depth = n2;
        }
        this.imageMask = pdfObject.getBoolean(1516403337);
    }

    public ImageData(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isImageMask() {
        return this.imageMask;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public byte[] getObjectData() {
        return this.objectData;
    }

    public void setObjectData(byte[] byArray) {
        this.objectData = byArray;
    }

    public void setpX(int n) {
        this.pX = n;
    }

    public void setpY(int n) {
        this.pY = n;
    }

    public int getpX() {
        return this.pX;
    }

    public int getpY() {
        return this.pY;
    }

    public void swapValues() {
        int n = this.pX;
        this.pX = this.pY;
        this.pY = n;
    }

    public boolean isJPX() {
        return this.isJPX;
    }

    public boolean isDCT() {
        return this.isDCT;
    }

    public boolean isJBIG() {
        return this.isJBIG;
    }

    public PdfArrayIterator getFilter(PdfObject pdfObject) {
        PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
        if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
            while (pdfArrayIterator.hasMoreTokens()) {
                int n = pdfArrayIterator.getNextValueAsConstant(true);
                this.isDCT = n == 1180911742;
                this.isJPX = n == 1399277700;
                this.isJBIG = n == 1247500931;
            }
        } else {
            pdfArrayIterator = null;
        }
        return pdfArrayIterator;
    }

    public void setCompCount(int n) {
        this.numComponents = n;
    }

    public int getCompCount() {
        return this.numComponents;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean bl) {
        this.removed = bl;
    }
}

