/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.render.output.FontMapper;

public class GenericFontMapper
implements FontMapper {
    private static final String DEFAULT_FONT = "DEFAULT_FONT";
    String style = "normal";
    String weight = "normal";
    String family;
    private String fontID;
    private int fontMode = 3;
    private boolean isFontEmbedded;
    private boolean isFontSubstituted;
    public static final Map<String, String> fontMappings = new HashMap<String, String>();
    public static final Map<String, Integer> fontSizeAdjustments = new HashMap<String, Integer>();
    private static final Map<String, String> fontStyle = new HashMap<String, String>();
    private static final Map<String, String> fontWeight = new HashMap<String, String>();
    private String rawFont;

    public GenericFontMapper(String string) {
        this.init(string);
        this.rawFont = string;
    }

    public GenericFontMapper(String string, int n, boolean bl, boolean bl2) {
        this.fontMode = n;
        this.isFontEmbedded = bl;
        this.isFontSubstituted = bl2;
        this.rawFont = string;
        this.init(string);
    }

    private void init(String string) {
        String string2;
        if (this.fontMode == 6 || this.fontMode == 7) {
            this.fontID = string;
            if (!this.isFontEmbedded || StandardFonts.isStandardFont(string, true)) {
                int n = string.indexOf(44);
                if (n == -1) {
                    n = string.indexOf(45);
                }
                if (n == -1) {
                    for (int i = string.length() - 1; i >= 0; --i) {
                        int n2 = string.codePointAt(i);
                        if (n2 < 48 || n2 > 57) continue;
                        if (i >= string.length() - 1) break;
                        n = i - 1;
                        break;
                    }
                }
                if (n > 0) {
                    this.findAttributes(string);
                }
            }
        } else if (!(this.directMapFont(string) || this.mapFont(string2 = this.findAttributes(string)) || this.hasSimiliarMapping(string2))) {
            switch (this.fontMode) {
                case 3: {
                    this.fontID = DEFAULT_FONT;
                    break;
                }
                case 2: {
                    throw new RuntimeException("Font " + string + " not mapped");
                }
            }
        }
    }

    private String findAttributes(String string) {
        int n;
        String string2 = string;
        int n2 = string.indexOf(44);
        if (n2 == -1) {
            n2 = string.indexOf(45);
        }
        if (n2 == -1) {
            n2 = string.lastIndexOf(32);
        }
        if (n2 == -1) {
            for (int i = string.length() - 1; i >= 0; --i) {
                n = string.codePointAt(i);
                if (n < 48 || n > 57) continue;
                if (i >= string.length() - 1) break;
                n2 = i - 1;
                break;
            }
        }
        if (n2 != -1) {
            String string3 = string.substring(n2 + 1, string.length()).toLowerCase();
            this.family = string2 = string.substring(0, n2);
            n = 0;
            for (String string4 : fontMappings.keySet()) {
                if (!string4.startsWith(this.family)) continue;
                n = 1;
            }
            if (n != 0 || !this.isFontEmbedded) {
                if (string3.contains("heavy")) {
                    this.weight = "900";
                } else if (string3.endsWith("black")) {
                    this.weight = "bolder";
                } else if (string3.contains("light")) {
                    this.weight = "lighter";
                } else if (string3.contains("condensed")) {
                    this.weight = "100";
                } else if (string3.contains("bold")) {
                    this.weight = "bold";
                }
                if (string3.equals("it") || string3.contains("italic") || string3.contains("kursiv") || string3.contains("oblique")) {
                    this.style = "italic";
                }
            }
        }
        return string2;
    }

    private boolean mapFont(String string) {
        if (fontMappings.get(string) != null) {
            this.fontID = string;
            return true;
        }
        return false;
    }

    private boolean directMapFont(String string) {
        boolean bl = this.mapFont(string);
        if (!bl) {
            return false;
        }
        if (fontStyle.containsKey(string)) {
            this.style = fontStyle.get(string);
        }
        if (fontWeight.containsKey(string)) {
            this.weight = fontWeight.get(string);
        }
        return true;
    }

    private boolean hasSimiliarMapping(String string) {
        Set<String> set = fontMappings.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : set) {
            String string3;
            String string4 = string2.toLowerCase();
            if (string4.equals(string3 = string.toLowerCase())) {
                this.fontID = string2;
                return true;
            }
            if (!string4.contains(string3) && !string3.contains(string4)) continue;
            hashSet.add(string2);
        }
        if (!hashSet.isEmpty()) {
            String[] stringArray = new String[hashSet.size()];
            stringArray = hashSet.toArray(stringArray);
            this.fontID = stringArray[0];
            if (hashSet.size() > 1) {
                for (int i = 1; i < stringArray.length; ++i) {
                    if (stringArray[i].length() >= this.fontID.length()) continue;
                    this.fontID = stringArray[i];
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getFont() {
        String string = fontMappings.get(this.fontID);
        if (string == null && this.family != null && !this.isFontEmbedded) {
            string = fontMappings.get(this.family);
        }
        if (string == null && (this.fontMode == 6 || this.fontMode == 7)) {
            string = this.rawFont = this.rawFont.replaceAll("[.,@*#]", "-");
        } else if (string != null && this.isFontEmbedded && this.fontMode == 6) {
            string = this.fontID;
        }
        return string == null ? "" : string;
    }

    @Override
    public String getStyle() {
        if (this.isFontEmbedded) {
            this.style = "normal";
        }
        return this.style;
    }

    @Override
    public String getWeight() {
        if (this.isFontEmbedded) {
            this.weight = "normal";
        }
        return this.weight;
    }

    @Override
    public boolean isFontEmbedded() {
        return this.isFontEmbedded;
    }

    @Override
    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    @Override
    public boolean equals(FontMapper fontMapper) {
        return this.getStyle().equals(fontMapper.getStyle()) && this.getFont().equals(fontMapper.getFont()) && this.getWeight().equals(fontMapper.getWeight()) && this.isFontEmbedded() == fontMapper.isFontEmbedded();
    }

    static {
        if (fontMappings.keySet().isEmpty()) {
            fontMappings.put("Arial", "Arial, Helvetica, sans-serif");
            fontMappings.put("ArialMT", "Arial, Helvetica, sans-serif");
            fontMappings.put("ArialBlack", "'Arial Black', Gadget, sans-serif");
            fontMappings.put("ComicSansMS", "'Comic Sans MS', Textile, cursive");
            fontMappings.put("CourierNew", "'Courier New', Courier, monospace");
            fontMappings.put("Georgia", "Georgia, 'Times New Roman', Times, serif");
            fontMappings.put("Impact", "Impact, Charcoal, sans-serif");
            fontMappings.put("LucidaConsole", "'Lucida Console', Monaco, monospace");
            fontMappings.put("LucidaSansUnicode", "'Lucida Sans Unicode', 'Lucida Grande', sans-serif");
            fontMappings.put("PalatinoLinotype", "'Palatino Linotype', 'Book Antiqua', Palatino, serif");
            fontMappings.put("Tahoma", "Tahoma, Geneva, sans-serif");
            fontMappings.put("TimesNewRoman", "'Times New Roman', Times, serif");
            fontMappings.put("Times", "'Times New Roman', Times, serif");
            fontMappings.put("Trebuchet", "'Trebuchet MS', Helvetica, sans-serif");
            fontMappings.put("Verdana", "Verdana, Geneva, sans-serif");
            fontMappings.put("Symbol", "Symbol");
            fontMappings.put("Webdings", "Webdings");
            fontMappings.put("Wingdings", "Wingdings, 'Zapf Dingbats'");
            fontMappings.put("MSSansSerif", "'MS Sans Serif', Geneva, sans-serif");
            fontMappings.put("MSSerif", "'MS Serif', 'New York', serif");
            fontMappings.put("Helvetica", "Helvetica, Arial, sans-serif");
            fontMappings.put("ZapfDingbats", "Wingdings, 'Zapf Dingbats'");
            fontMappings.put(DEFAULT_FONT, "'Times New Roman', Times, serif");
            fontSizeAdjustments.put(DEFAULT_FONT, -1);
        }
    }
}

