/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Double
implements Serializable {
    int increment_size = 1000;
    protected int current_item;
    int max_size = 250;
    private double[] items = new double[this.max_size];
    private int checkPoint = -1;

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }

    protected static int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public Vector_Double(int n) {
        this.max_size = n;
        this.items = new double[this.max_size];
    }

    public final double[] get() {
        return this.items;
    }

    public final void addElement(double d) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = d;
        ++this.current_item;
    }

    public final double elementAt(int n) {
        if (n >= this.max_size) {
            return 0.0;
        }
        return this.items[n];
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0.0;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0.0;
            }
        }
        this.current_item = 0;
    }

    public final double pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    private void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            double[] dArray = this.items;
            this.items = new double[this.max_size];
            System.arraycopy(dArray, 0, this.items, 0, n2);
            this.increment_size = Vector_Double.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        double[] dArray = new double[this.current_item];
        System.arraycopy(this.items, 0, dArray, 0, this.current_item);
        this.items = dArray;
        this.max_size = this.current_item;
    }
}

