/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.ProductParserHelper;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import java.util.Date;

public class AirProductParserHelper {
    private static final int PNR_DAYS_THRESHOLD = 365;
    public static final ProductParserHelper.ProductParserHandler<Product> handler = new ProductParserHelper.ProductParserHandler<Product>(){

        @Override
        public Product createProduct() {
            return new Product();
        }

        @Override
        public int getThreshold() {
            return 365;
        }

        @Override
        public void setSystemNumber(Product product, String systemNumber) {
            product.setSystemNumber(systemNumber);
        }

        @Override
        public void setIssueDate(Product product, Date issueDate) {
            product.setIssueDate(issueDate);
        }

        @Override
        public void setStatus(Product product, ProductStatus status) {
            product.setStatus(status);
        }

        @Override
        public void setTicketType(Product product, TicketType ticketType) {
            product.setTicketType(ticketType);
        }

        @Override
        public void setProductCategory(Product product, ProductCategory productCategory) {
            product.setProductCategory(productCategory);
        }

        @Override
        public void setBlankOwner(Product product, EntityReference<Organization> blankOwner) {
            product.setBlankOwnerRef(blankOwner);
        }

        @Override
        public void setSupplier(Product product, EntityReference<Organization> supplier) {
            AirProductHelper.setSupplier((Product)product, supplier);
        }

        @Override
        public void setAgency(Product product, EntityReference<Organization> agency) {
            AirProductHelper.setAgency((Product)product, agency);
        }

        @Override
        public void setSubagency(Product product, EntityReference<Organization> subagency) {
            AirProductHelper.setSubagency((Product)product, subagency);
        }

        @Override
        public void setPreviousProduct(Product product, Product previousProduct) {
            product.setPreviousProduct(previousProduct);
        }

        @Override
        public void setNextProduct(Product product, Product nextProduct) {
            product.setNextProduct(nextProduct);
        }

        @Override
        public void addRelatedProduct(Product product, BaseProduct relatedProduct) {
            if (relatedProduct instanceof Product) {
                product.getRelatedProducts().add((Product)relatedProduct);
            }
        }
    };

    public static ProductSearchResult searchProductSell(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductSell(context, handler);
    }

    public static ProductSearchResult searchProductRefund(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductRefund(context, handler);
    }

    public static ProductSearchResult searchProductExchange(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductExchange(context, handler);
    }

    public static ProductSearchResult searchProductVoid(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductVoid(context, handler);
    }

    public static ProductSearchContext.ProductCreateResult createProduct(ProductStatus status, String systemNumber, ProductCategory category) {
        return ProductParserHelper.createProduct(status, systemNumber, category, handler);
    }
}

