/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.BranchIndex;
import com.gridnine.xtrip.common.parsers.helpers.BranchSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.BranchSearchResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;

public class BranchParserHelper {
    public static BranchSearchResult searchBranch(BranchSearchContext searchContext) throws Exception {
        List branchIndexes = Collections.emptyList();
        if (!TextUtil.isBlank((String)searchContext.getKpp())) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BranchIndex.Property.kpp.name(), (Object)searchContext.getKpp()));
            branchIndexes = EntityStorage.get().search(BranchIndex.class, query).getData();
        }
        if (branchIndexes.size() > 0) {
            BranchSearchResult searchResult = new BranchSearchResult();
            searchResult.setBranch((EntityContainer<Branch>)EntityStorage.get().resolve(((BranchIndex)branchIndexes.get(0)).getSource()));
            searchResult.setExists(true);
            searchResult.setUnique(branchIndexes.size() == 1);
            return searchResult;
        }
        Branch branch = new Branch();
        EntityContainer branchContainer = EntityContainer.create((BaseEntity)branch);
        BranchSearchResult searchResult = new BranchSearchResult();
        searchResult.setBranch((EntityContainer<Branch>)branchContainer);
        searchResult.setExists(false);
        searchResult.setUnique(true);
        return searchResult;
    }
}

