/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.HoldingIndex;
import com.gridnine.xtrip.common.parsers.helpers.HoldingSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.HoldingSearchResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;

public class HoldingParserHelper {
    public static HoldingSearchResult searchHolding(HoldingSearchContext searchContext) throws Exception {
        List holdingIndexes = Collections.emptyList();
        if (!TextUtil.isBlank((String)searchContext.getInn())) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)HoldingIndex.Property.registrationId.name(), (Object)searchContext.getInn()));
            holdingIndexes = EntityStorage.get().search(HoldingIndex.class, query).getData();
        }
        if (holdingIndexes.size() > 0) {
            HoldingSearchResult searchResult = new HoldingSearchResult();
            searchResult.setHolding((EntityContainer<Holding>)EntityStorage.get().resolve(((HoldingIndex)holdingIndexes.get(0)).getSource()));
            searchResult.setExists(true);
            searchResult.setUnique(holdingIndexes.size() == 1);
            return searchResult;
        }
        Holding holding = new Holding();
        EntityContainer holdingContainer = EntityContainer.create((BaseEntity)holding);
        HoldingSearchResult searchResult = new HoldingSearchResult();
        searchResult.setHolding((EntityContainer<Holding>)holdingContainer);
        searchResult.setExists(false);
        searchResult.setUnique(true);
        return searchResult;
    }
}

