/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.ProductParserHelper;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import java.util.Date;

public class InsuranceAccidentProductParserHelper {
    private static final int PNR_DAYS_THRESHOLD = 365;
    public static final ProductParserHelper.ProductParserHandler<InsuranceAccident> handler = new ProductParserHelper.ProductParserHandler<InsuranceAccident>(){

        @Override
        public InsuranceAccident createProduct() {
            return new InsuranceAccident();
        }

        @Override
        public int getThreshold() {
            return 365;
        }

        @Override
        public void setSystemNumber(InsuranceAccident product, String systemNumber) {
            product.setSystemNumber(systemNumber);
        }

        @Override
        public void setIssueDate(InsuranceAccident product, Date issueDate) {
            product.setIssueDate(issueDate);
        }

        @Override
        public void setStatus(InsuranceAccident product, ProductStatus status) {
            product.setStatus(status);
        }

        @Override
        public void setTicketType(InsuranceAccident product, TicketType ticketType) {
            product.setTicketType(ticketType);
        }

        @Override
        public void setProductCategory(InsuranceAccident product, ProductCategory productCategory) {
        }

        @Override
        public void setBlankOwner(InsuranceAccident product, EntityReference<Organization> blankOwner) {
            product.setBlankOwner(blankOwner);
        }

        @Override
        public void setSupplier(InsuranceAccident product, EntityReference<Organization> supplier) {
            InsuranceAccidentHelper.setSupplier((InsuranceAccident)product, supplier);
        }

        @Override
        public void setAgency(InsuranceAccident product, EntityReference<Organization> agency) {
            InsuranceAccidentHelper.setAgency((InsuranceAccident)product, agency);
        }

        @Override
        public void setSubagency(InsuranceAccident product, EntityReference<Organization> subagency) {
            InsuranceAccidentHelper.setSubagency((InsuranceAccident)product, subagency);
        }

        @Override
        public void setPreviousProduct(InsuranceAccident product, InsuranceAccident previousProduct) {
            product.setPreviousProduct(previousProduct);
        }

        @Override
        public void setNextProduct(InsuranceAccident product, InsuranceAccident nextProduct) {
            product.setNextProduct(nextProduct);
        }

        @Override
        public void addRelatedProduct(InsuranceAccident product, BaseProduct relatedProduct) {
            if (relatedProduct != null) {
                product.setRelatedProductUid(relatedProduct.getUid());
            }
        }
    };

    public static ProductSearchResult searchProductSell(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductSell(context, handler);
    }

    public static ProductSearchResult searchProductRefund(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductRefund(context, handler);
    }

    public static ProductSearchResult searchProductVoid(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductVoid(context, handler);
    }

    public static ProductSearchContext.ProductCreateResult createProduct(ProductStatus status, String systemNumber) {
        return ProductParserHelper.createProduct(status, systemNumber, null, handler);
    }
}

