/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.parsers.helpers.OrganizationSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.OrganizationSearchResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;

public class OrganizationParserHelper {
    public static OrganizationSearchResult searchOrganization(OrganizationSearchContext searchContext) throws Exception {
        SearchQuery query;
        List organizationIndexes = Collections.emptyList();
        if (!(TextUtil.isBlank((String)searchContext.getCode()) && TextUtil.isBlank((String)searchContext.getInn()) && TextUtil.isBlank((String)searchContext.getKpp()))) {
            query = new SearchQuery();
            if (!TextUtil.isBlank((String)searchContext.getCode())) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)searchContext.getCode()));
            }
            if (!TextUtil.isBlank((String)searchContext.getInn())) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.registrationId.name(), (Object)searchContext.getInn()));
            }
            if (!TextUtil.isBlank((String)searchContext.getKpp())) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.kpp.name(), (Object)searchContext.getKpp()));
            }
            organizationIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        }
        if (organizationIndexes.size() == 0 && !TextUtil.isBlank((String)searchContext.getCode())) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)searchContext.getCode()));
            organizationIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        }
        if (organizationIndexes.size() > 0) {
            OrganizationSearchResult searchResult = new OrganizationSearchResult();
            searchResult.setOrganization((EntityContainer<Organization>)EntityStorage.get().resolve(((OrganizationIndex)organizationIndexes.get(0)).getSource()));
            searchResult.setExists(true);
            searchResult.setUnique(organizationIndexes.size() == 1);
            return searchResult;
        }
        Organization organization = new Organization();
        EntityContainer organizationContainer = EntityContainer.create((BaseEntity)organization);
        OrganizationSearchResult searchResult = new OrganizationSearchResult();
        searchResult.setOrganization((EntityContainer<Organization>)organizationContainer);
        searchResult.setExists(false);
        searchResult.setUnique(true);
        return searchResult;
    }
}

