/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.parsers.helpers.PersonSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.PersonSearchResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class PersonParserHelper {
    private static final CollectionUtil.Equator<PersonSearchContext, Person> passportDataEquator = new CollectionUtil.Equator<PersonSearchContext, Person>(){

        public boolean equal(PersonSearchContext searchContext, Person person) {
            return CollectionUtil.intersect(searchContext.getPassportDatas(), (Collection)person.getPassports(), (CollectionUtil.Equator)new CollectionUtil.Equator<PersonSearchContext.PassportData, Passport>(){

                public boolean equal(PersonSearchContext.PassportData passportData, Passport passport) {
                    if (passportData == null && passport == null) {
                        return true;
                    }
                    if (passportData == null || passport == null) {
                        return false;
                    }
                    if (passportData.getType() != null && passport.getType() != null && passportData.getType() != passport.getType()) {
                        return false;
                    }
                    if (!(TextUtil.isBlank((String)passportData.getNumber()) || TextUtil.isBlank((String)passport.getNumber()) || TextUtil.isSame((String)passportData.getNumber(), (String)passport.getNumber()))) {
                        return false;
                    }
                    if (!(TextUtil.isBlank((String)passportData.getLastName()) || TextUtil.isBlank((String)passport.getLastName()) || TextUtil.isSame((String)passportData.getLastName(), (String)passport.getLastName()))) {
                        return false;
                    }
                    if (!(TextUtil.isBlank((String)passportData.getFirstName()) || TextUtil.isBlank((String)passport.getFirstName()) || TextUtil.isSame((String)passportData.getFirstName(), (String)passport.getFirstName()))) {
                        return false;
                    }
                    if (!(TextUtil.isBlank((String)passportData.getMiddleName()) || TextUtil.isBlank((String)passport.getMiddleName()) || TextUtil.isSame((String)passportData.getMiddleName(), (String)passport.getMiddleName()))) {
                        return false;
                    }
                    if (passportData.getGender() != null && passport.getGender() != null && passportData.getGender() != passport.getGender()) {
                        return false;
                    }
                    if (passportData.getBirthday() != null && passport.getBirthday() != null && !MiscUtil.isSameDay((Date)passportData.getBirthday(), (Date)passport.getBirthday())) {
                        return false;
                    }
                    return passportData.getCitizenship() == null || passport.getCitizenship() == null || MiscUtil.equals(passportData.getCitizenship(), (Object)passport.getCitizenship());
                }
            }, (boolean)true).size() > 0;
        }
    };
    private static final CollectionUtil.Equator<PersonSearchContext, Person> commonDataEquator = new CollectionUtil.Equator<PersonSearchContext, Person>(){

        public boolean equal(PersonSearchContext searchContext, Person person) {
            if (searchContext.getLastNames().size() > 0 && person.getLastName().getValues().values().size() > 0 && !this.contains(searchContext.getLastNames(), person.getLastName().getValues().values())) {
                return false;
            }
            if (searchContext.getFirstNames().size() > 0 && person.getFirstName().getValues().values().size() > 0 && !this.contains(searchContext.getFirstNames(), person.getFirstName().getValues().values())) {
                return false;
            }
            if (searchContext.getPatronymic().size() > 0 && person.getMiddleName().getValues().values().size() > 0 && !this.contains(searchContext.getPatronymic(), person.getMiddleName().getValues().values())) {
                return false;
            }
            List<Passport> genderPassports = person.getPassports().stream().filter(item -> item.getGender() != null).collect(Collectors.toList());
            if (searchContext.getGender() != null && genderPassports.size() > 0 && !this.contains(searchContext.getGender(), genderPassports)) {
                return false;
            }
            List<Passport> birthdayPassports = person.getPassports().stream().filter(item -> item.getBirthday() != null).collect(Collectors.toList());
            return searchContext.getBirthday() == null || birthdayPassports.size() <= 0 || this.contains(searchContext.getBirthday(), birthdayPassports);
        }

        private boolean contains(Collection<String> col1, Collection<String> col2) {
            for (String value1 : col1) {
                for (String value2 : col2) {
                    if (!TextUtil.isSame((String)value1, (String)value2, (boolean)true, (boolean)true)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean contains(Gender gender, List<Passport> passports) {
            for (Passport passport : passports) {
                if (passport.getGender() == null || gender != passport.getGender()) continue;
                return true;
            }
            return false;
        }

        private boolean contains(Date birthday, List<Passport> passports) {
            for (Passport passport : passports) {
                if (passport.getBirthday() == null || !MiscUtil.isSameDay((Date)birthday, (Date)passport.getBirthday())) continue;
                return true;
            }
            return false;
        }
    };

    public static PersonSearchResult searchPerson(PersonSearchContext searchContext) throws Exception {
        Person person;
        EntityContainer personContainer;
        ArrayList<EntityContainer> personContainers;
        PersonSearchResult searchResult;
        SearchQuery query;
        List personIndexes = Collections.emptyList();
        SearchCriterion organizationCriterion = null;
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        criterions.add(SearchQueryHelper.buildOrContainsStringCriterion((String)PersonIndex.Property.employmentsUids.name(), (Collection)searchContext.getOrganizations().stream().map(EntityReference::getUid).collect(Collectors.toList())));
        if (criterions.size() > 0) {
            organizationCriterion = SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()]));
        }
        if (!TextUtil.isBlank((String)searchContext.getExternalCode())) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.externalCodes.name(), (Object)searchContext.getExternalCode()));
            if (organizationCriterion != null) {
                query.getCriteria().getCriterions().add(organizationCriterion);
            }
            personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        }
        if (personIndexes.size() > 0) {
            PersonSearchResult searchResult2 = new PersonSearchResult();
            searchResult2.setPerson((EntityContainer<Person>)EntityStorage.get().resolve(((PersonIndex)personIndexes.get(0)).getSource()));
            searchResult2.setExists(true);
            searchResult2.setUnique(personIndexes.size() == 1);
            return searchResult2;
        }
        if (!TextUtil.isBlank((String)searchContext.getCode())) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.code.name(), (Object)searchContext.getCode()));
            if (organizationCriterion != null) {
                query.getCriteria().getCriterions().add(organizationCriterion);
            }
            personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        }
        if (personIndexes.size() > 0) {
            searchResult = new PersonSearchResult();
            searchResult.setPerson((EntityContainer<Person>)EntityStorage.get().resolve(((PersonIndex)personIndexes.get(0)).getSource()));
            searchResult.setExists(true);
            searchResult.setUnique(personIndexes.size() == 1);
            return searchResult;
        }
        if (TextUtil.nonBlank((String)searchContext.getRegistrationIdKz())) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.registrationIdKz.name(), (Object)searchContext.getRegistrationIdKz()));
            if (organizationCriterion != null) {
                query.getCriteria().getCriterions().add(organizationCriterion);
            }
            personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        }
        if (personIndexes.size() > 0) {
            searchResult = new PersonSearchResult();
            searchResult.setPerson((EntityContainer<Person>)EntityStorage.get().resolve(((PersonIndex)personIndexes.get(0)).getSource()));
            searchResult.setExists(true);
            searchResult.setUnique(personIndexes.size() == 1);
            return searchResult;
        }
        query = new SearchQuery();
        criterions = new ArrayList();
        for (PersonSearchContext.PassportData passportData : searchContext.getPassportDatas()) {
            if (TextUtil.isBlank((String)passportData.getNumber())) continue;
            criterions.add(SearchCriterion.contains((String)PersonIndex.Property.passportNumbers.name(), (Object)passportData.getNumber().trim()));
        }
        if (criterions.size() > 0) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            if (organizationCriterion != null) {
                query.getCriteria().getCriterions().add(organizationCriterion);
            }
            personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        }
        if (personIndexes.size() > 0) {
            personContainers = new ArrayList();
            for (PersonIndex personIndex : personIndexes) {
                personContainer = EntityStorage.get().resolve(personIndex.getSource());
                if (personContainer == null || !passportDataEquator.equal((Object)searchContext, (Object)(person = (Person)personContainer.getEntity()))) continue;
                personContainers.add(personContainer);
            }
            if (personContainers.size() > 0) {
                PersonSearchResult personSearchResult = new PersonSearchResult();
                personSearchResult.setPerson((EntityContainer<Person>)((EntityContainer)personContainers.get(0)));
                personSearchResult.setExists(true);
                personSearchResult.setUnique(personContainers.size() == 1);
                return personSearchResult;
            }
        }
        query = new SearchQuery();
        criterions = new ArrayList();
        for (String string : searchContext.getLastNames()) {
            if (TextUtil.isBlank((String)string)) continue;
            criterions.add(SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)String.format("%%%s%%", string.trim())));
        }
        if (criterions.size() > 0) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            if (organizationCriterion != null) {
                query.getCriteria().getCriterions().add(organizationCriterion);
            }
            personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        }
        if (personIndexes.size() > 0) {
            personContainers = new ArrayList<EntityContainer>();
            for (PersonIndex personIndex : personIndexes) {
                personContainer = EntityStorage.get().resolve(personIndex.getSource());
                if (personContainer == null || !commonDataEquator.equal((Object)searchContext, (Object)(person = (Person)personContainer.getEntity()))) continue;
                personContainers.add(personContainer);
            }
            if (personContainers.size() > 0) {
                PersonSearchResult personSearchResult = new PersonSearchResult();
                personSearchResult.setPerson((EntityContainer<Person>)((EntityContainer)personContainers.get(0)));
                personSearchResult.setExists(true);
                personSearchResult.setUnique(personContainers.size() == 1);
                return personSearchResult;
            }
        }
        return PersonParserHelper.createNewPerson();
    }

    public static PersonSearchResult createNewPerson() {
        Person person = new Person();
        EntityContainer personContainer = EntityContainer.create((BaseEntity)person);
        PersonSearchResult searchResult = new PersonSearchResult();
        searchResult.setPerson((EntityContainer<Person>)personContainer);
        searchResult.setExists(false);
        searchResult.setUnique(true);
        return searchResult;
    }
}

