/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.ProductParserHelper;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import java.util.Date;

public class UniversalProductParserHelper {
    private static final int PNR_DAYS_THRESHOLD = 365;
    public static final ProductParserHelper.ProductParserHandler<UniversalProduct> handler = new ProductParserHelper.ProductParserHandler<UniversalProduct>(){

        @Override
        public UniversalProduct createProduct() {
            return new UniversalProduct();
        }

        @Override
        public int getThreshold() {
            return 365;
        }

        @Override
        public void setSystemNumber(UniversalProduct product, String systemNumber) {
            product.setSystemNumber(systemNumber);
        }

        @Override
        public void setIssueDate(UniversalProduct product, Date issueDate) {
            product.setIssueDate(issueDate);
        }

        @Override
        public void setStatus(UniversalProduct product, ProductStatus status) {
            product.setStatus(status);
        }

        @Override
        public void setTicketType(UniversalProduct product, TicketType ticketType) {
            product.setTicketType(ticketType);
        }

        @Override
        public void setProductCategory(UniversalProduct product, ProductCategory productCategory) {
        }

        @Override
        public void setBlankOwner(UniversalProduct product, EntityReference<Organization> blankOwner) {
            product.setBlankOwner(blankOwner);
        }

        @Override
        public void setSupplier(UniversalProduct product, EntityReference<Organization> supplier) {
            UniversalProductHelper.setSupplier((UniversalProduct)product, supplier);
        }

        @Override
        public void setAgency(UniversalProduct product, EntityReference<Organization> agency) {
            UniversalProductHelper.setAgency((UniversalProduct)product, agency);
        }

        @Override
        public void setSubagency(UniversalProduct product, EntityReference<Organization> subagency) {
            UniversalProductHelper.setSubagency((UniversalProduct)product, subagency);
        }

        @Override
        public void setPreviousProduct(UniversalProduct product, UniversalProduct previousProduct) {
            product.setPreviousProduct(previousProduct);
        }

        @Override
        public void setNextProduct(UniversalProduct product, UniversalProduct nextProduct) {
            product.setNextProduct(nextProduct);
        }

        @Override
        public void addRelatedProduct(UniversalProduct product, BaseProduct relatedProduct) {
        }
    };

    public static ProductSearchResult searchProductSell(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductSell(context, handler);
    }

    public static ProductSearchResult searchProductRefund(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductRefund(context, handler);
    }

    public static ProductSearchResult searchProductExchange(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductExchange(context, handler);
    }

    public static ProductSearchResult searchProductVoid(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductVoid(context, handler);
    }

    public static ProductSearchContext.ProductCreateResult createProduct(ProductStatus status, String systemNumber) {
        return ProductParserHelper.createProduct(status, systemNumber, null, handler);
    }
}

