/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.transfers.model.standard;

import com.gridnine.xtrip.common.model.booking.VendorAdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.handlers.standard.TransferHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.transfers.CommonTransfersHelper;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.stream.Collectors;

public class TransfersProductHandler
extends TransferHandler {
    public BigDecimal getAdditionalFeeEquivalentAmount(Transfer product) {
        return CommonTransfersHelper.getAdditionalServiceSum(product);
    }

    public Money getAdditionalFee(Transfer product) {
        BigDecimal price = CommonTransfersHelper.getAdditionalServiceSum(product);
        String currency = DictHelper.getLocalCurrency();
        if (product.getFare() != null && TextUtil.nonBlank((String)product.getFare().getCurrency())) {
            currency = product.getFare().getCurrency();
        }
        Money result = new Money();
        result.setValue(price);
        result.setCurrency(currency);
        return result;
    }

    public Collection<VendorAdditionalService> getProductBaseAdditionalServices(Transfer product) {
        return product.getAdditionalServices().stream().map(as -> {
            VendorAdditionalService info = new VendorAdditionalService();
            info.setAmount(MoneyHelper.buildMoney((BigDecimal)as.getPrice(), (String)as.getCurrency()));
            info.setVatAmount(as.getEquivalentVatAmount());
            info.setVatRate(as.getEquivalentVatRate());
            info.setSource(as.getUid());
            info.setTypeCaption(EnumUtil.stringValueOf((Enum)as.getType()));
            return info;
        }).collect(Collectors.toList());
    }

    public Collection<VendorAdditionalService> getProductEquivalentAdditionalServices(Transfer product) {
        return product.getAdditionalServices().stream().map(as -> {
            VendorAdditionalService info = new VendorAdditionalService();
            info.setAmount(MoneyHelper.buildMoney((BigDecimal)as.getPrice(), (String)as.getCurrency()));
            info.setVatAmount(as.getEquivalentVatAmount());
            info.setVatRate(as.getEquivalentVatRate());
            info.setSource(as.getUid());
            return info;
        }).collect(Collectors.toList());
    }
}

